/**
 * Copyright 0xABCDEF ( http://wonderfl.net/user/0xABCDEF )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/x9ca
 */

package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.MovieClip;
    import flash.display.BitmapData;
    import flash.geom.Rectangle;
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    [SWF(width=460,height=460,frameRate=60)]
    public class Snake extends Sprite {
        public function Snake() {
            const fieldWidth:int = 46;
			const fieldHeight:int = 46;
			const fieldScale:Number = 10;
			const defaultTimerSpeed:Number = 100;
			
			var score:int = 0;
			var isFinished:Boolean = false;
			
			var fieldData:BitmapData = new BitmapData(fieldWidth,fieldHeight,false,0xFFFFFF);
			var field:Bitmap = new Bitmap(fieldData);
			var fieldContainer:MovieClip = new MovieClip();
			
			field.scaleX = fieldScale;
			field.scaleY = fieldScale;
			
			fieldContainer.addChild(field);
			this.addChild(fieldContainer);
			
			var food:Object = new Object();
			food.x = Math.round(Math.random()*(fieldWidth-3)+1);
			food.y = Math.round(Math.random()*(fieldHeight-3)+1);
			fieldData.setPixel(food.x,food.y,0xFF0000);
			
			var snake:Object = new Object();
			snake.x = Math.round((fieldWidth/2));
			snake.y = Math.round((fieldHeight/2));
			fieldData.setPixel(snake.x,snake.y,0x000000);
			
			var tailArray:Array = new Array();
			tailArray.push({x:snake.x,y:snake.y});
			tailArray.push({x:snake.x-1,y:snake.y});
			tailArray.push({x:snake.x-2,y:snake.y});
			
			for(i=0;i<tailArray.length;i++){
				fieldData.setPixel(tailArray[i].x,tailArray[i].y,0x000000);
			}
			
			for(i=0;i<fieldWidth;i++){
				fieldData.setPixel(i,0,0xAAAAAA);
			}
			for(i=0;i<fieldWidth;i++){
				fieldData.setPixel(i,fieldHeight-1,0xAAAAAA);
			}
			for(i=0;i<fieldHeight;i++){
				fieldData.setPixel(0,i,0xAAAAAA);
			}
			for(i=0;i<fieldHeight;i++){
				fieldData.setPixel(fieldWidth-1,i,0xAAAAAA);
			}
			
			var snakeDirection:String = "right";
			var timer:Timer = new Timer(defaultTimerSpeed,0);
			timer.start();
			isFinished = false;
			trace("game start");
			
			const r:Rectangle = new Rectangle(0,0,fieldWidth,fieldHeight);
			
			var isMoved:Boolean = false;
			
			function ke(e:KeyboardEvent):void {
				if((e.keyCode == Keyboard.LEFT)&&(isMoved == true)) {
					if(snakeDirection != "right"){
						snakeDirection = "left";
					}
					isMoved = false;
				}else if((e.keyCode == Keyboard.RIGHT)&&(isMoved == true)) {
					if(snakeDirection != "left"){
						snakeDirection = "right";
					}
					isMoved = false;
				}else if((e.keyCode == Keyboard.UP)&&(isMoved == true)) {
					if(snakeDirection != "down"){
						snakeDirection = "up";
					}
					isMoved = false;
				}else if((e.keyCode == Keyboard.DOWN)&&(isMoved == true)) {
					if(snakeDirection != "up"){
						snakeDirection = "down";
					}
					isMoved = false;
				}
				if(isFinished == true){
					fieldData.fillRect(r,0xFFFFFF);
					snakeDirection = "right";
					timer.delay = 100;
					food.x = Math.round(Math.random()*(fieldWidth-3)+1);
					food.y = Math.round(Math.random()*(fieldHeight-3)+1);
					fieldData.setPixel(food.x,food.y,0xFF0000);
					snake.x = Math.round((fieldWidth/2));
					snake.y = Math.round((fieldHeight/2));
					fieldData.setPixel(snake.x,snake.y,0x000000);	
					tailArray = new Array();
					tailArray.push({x:snake.x,y:snake.y});
					tailArray.push({x:snake.x-1,y:snake.y});
					tailArray.push({x:snake.x-2,y:snake.y});
					for(i=0;i<tailArray.length;i++){
						fieldData.setPixel(tailArray[i].x,tailArray[i].y,0x000000);
					}
					for(i=0;i<fieldWidth;i++){
						fieldData.setPixel(i,0,0xAAAAAA);
					}
					for(i=0;i<fieldWidth;i++){
						fieldData.setPixel(i,fieldHeight-1,0xAAAAAA);
					}
					for(i=0;i<fieldHeight;i++){
						fieldData.setPixel(0,i,0xAAAAAA);
					}
					for(i=0;i<fieldHeight;i++){
						fieldData.setPixel(fieldWidth-1,i,0xAAAAAA);
					}
					score = 0;
					timer.start();
					isFinished = false;
					trace("game start");
				}
			}
			
			stage.addEventListener(KeyboardEvent.KEY_DOWN,ke);
			
			var i:int;
			
			function t(e:TimerEvent):void{
				for(i=tailArray.length-1;i>0;i--){
					tailArray[i].x = tailArray[i-1].x;
					tailArray[i].y = tailArray[i-1].y;
				}
				tailArray[0].x = snake.x;
				tailArray[0].y = snake.y;
				if((snake.x > 0)&&(snake.x < (fieldWidth-1))&&(snake.y > 0)&&(snake.y < (fieldHeight-1))){
					if(snakeDirection == "left"){
						snake.x--;
					}else if(snakeDirection == "right"){
						snake.x++;
					}else if(snakeDirection == "up"){
						snake.y--;
					}else if(snakeDirection == "down"){
						snake.y++;
					}
					for(i=0;i<tailArray.length-1;i++){
						if((snake.x == tailArray[i].x)&&(snake.y == tailArray[i].y)){
							timer.stop();
							isFinished = true;
							trace("game over");
							break;
						}
					}
					if(isMoved == false){
						isMoved = true;
					}
				}else{
					timer.stop();
					isFinished = true;
					trace("game over");
				}
				fieldData.fillRect(r,0xFFFFFF);
				fieldData.setPixel(snake.x,snake.y,0x000000);
				for(i=0;i<tailArray.length;i++){
					fieldData.setPixel(tailArray[i].x,tailArray[i].y,0x000000);
				}
				if((snake.x == food.x)&&(snake.y == food.y)){
					if(snakeDirection == "left"){
						tailArray.push({x:tailArray[tailArray.length-1].x--,y:tailArray[tailArray.length-1].y});
					}else if(snakeDirection == "right"){
						tailArray.push({x:tailArray[tailArray.length-1].x++,y:tailArray[tailArray.length-1].y});
					}else if(snakeDirection == "up"){
						tailArray.push({x:tailArray[tailArray.length-1].x,y:tailArray[tailArray.length-1].y--});
					}else if(snakeDirection == "down"){
						tailArray.push({x:tailArray[tailArray.length-1].x,y:tailArray[tailArray.length-1].y++});
					}
					timer.delay *= 0.99;
					score++;
					trace("score : "+score);
					food.x = Math.round(Math.random()*(fieldWidth-3)+1);
					food.y = Math.round(Math.random()*(fieldHeight-3)+1);
				}
				fieldData.setPixel(food.x,food.y,0xFF0000);
				for(i=0;i<fieldWidth;i++){
					fieldData.setPixel(i,0,0xAAAAAA);
				}
				for(i=0;i<fieldWidth;i++){
					fieldData.setPixel(i,fieldHeight-1,0xAAAAAA);
				}
				for(i=0;i<fieldHeight;i++){
					fieldData.setPixel(0,i,0xAAAAAA);
				}
				for(i=0;i<fieldHeight;i++){
					fieldData.setPixel(fieldWidth-1,i,0xAAAAAA);
				}
			}
			
			timer.addEventListener(TimerEvent.TIMER,t);
        }
    }
}