/**
 * Copyright s26 ( http://wonderfl.net/user/s26 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/x97S
 */

// forked from s26's flash on 2012-10-4
package {
    import flash.geom.*;
    import flash.events.*;
    import flash.display.*;
    import flash.media.*;
    public class FlashTest extends Sprite {
        
        private var _bmp:Bitmap;
        private var _bmd:BitmapData;
        private var _bmdRect:Rectangle;

        
        private var camera:Camera;
        private var video:Video;
        
        public function FlashTest() {
            camera = Camera.getCamera();
            if (camera != null) {
                video = new Video(480,480);
                video.attachCamera(camera);
                //addChild(video);
                _bmd = new BitmapData(video.width, video.height)
                init()
            }
        }
        private function init():void{
            _bmp = new Bitmap(_bmd);
            addChild(_bmp);
            stage.addEventListener(Event.ENTER_FRAME,onEnterFrameHandler);
        }
        
        private function onEnterFrameHandler(e:Event):void{
            _bmd.draw(video);
            var _glayArray:Array = new Array();
            for(var i:uint = 0 ; i < 480 ; i++){
                var _glayArrayInner:Array = new Array();
                _glayArray.push(_glayArrayInner);
                for(var j:uint = 0 ; j < 480 ; j++){
                    var color  : uint = _bmd.getPixel(i,j);
                    var _red   : uint = (color >> 16) & 0xFF;
                    var _green : uint = (color >>  8) & 0xFF;
                    var _blue  : uint = (color >>  0) & 0xFF;
                    var _grey:uint = (_red + _green + _blue)/3;
                    _glayArray[i][j] = _grey;
                }
            }
            
            for(i =1 ; i < 479 ; i++){
                for(j = 1 ; j < 479 ; j++){
                    var hensa:int = 0;
                    for(var n:int = -1 ; n < 2 ; n++){
                        for(var m:int = -1 ; m < 2 ; m++){
                            hensa -= _glayArray[i+n][j+m];
                        }
                    }
                    hensa += _glayArray[i][j]*9;
                    if(hensa > 40){
                        _bmd.setPixel(i,j,0x000000);
                    }else if(hensa < -40){
                        _bmd.setPixel(i,j,0x000000);
                    }else{
                        _bmd.setPixel(i,j,0xffffff);
                    }


                }
            }
            
        }


    }
}