/**
 * Copyright indr ( http://wonderfl.net/user/indr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/x8wE
 */

package {
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.setTimeout;
    

    
    public class DocumentClass extends Sprite {
     
        private var _container:RankingContainer;
        
        public function DocumentClass() {
            // write as3 code here..
           
           _container = new RankingContainer();
           addChild(_container);
           
 
           var xml:XML = null;          
           var items:Array = ParseXmlData(createSampleXml1());
           _container.updateItems(items);
           
           setTimeout(setData2, 2000);
           setTimeout(setData3, 4000);
           return;
           
           
           xml = createSampleXml1();
           this.SetData(xml);
           
           xml = createSampleXml2();
           this.SetData(xml);     
           
           xml = createSampleXml3();
           this.SetData(xml);              
        }
        
        private function setData2():void {
            _container.updateItems(ParseXmlData(createSampleXml2()));
        }
            
        private function setData3():void {
            _container.updateItems(ParseXmlData(createSampleXml3()));
        }

  
        
        private var _stage:String = "";
        private var _round:String = "";
        private var _items:Array = new Array();
        
        
        public function SetData(xmlData:XML):void
        {
            var newItems:Array = ParseXmlData(xmlData);
            
            UpdateCurrentItems(newItems);

            DisplayCurrentItems();
        }
        
        private function UpdateCurrentItems(newItems:Array):void
        {
            RemoveStaleItemsAndUpdateRank(newItems);
            
            InsertNewItems(newItems);

            SortItems();
        }

        private function RemoveStaleItemsAndUpdateRank(newItems:Array):void
        {
            var itemsToRemove:Array = FindStaleItemsAndUpdateRank(newItems);

            for each(var itemToRemove:RankingListItem in itemsToRemove) {
                var idx:int = _items.indexOf(itemToRemove);
                _items = _items.slice(idx, 1);
            }
        }

        private function FindStaleItemsAndUpdateRank(newItems:Array):Array
        {
            var result:Array = new Array();
            for each(var currentItem:RankingListItem in _items)
            {
                var newItem:RankingListItem = FindByTshirt(newItems, currentItem.Tshirt);
                
                if (newItem == null) {
                    result.push(currentItem);
                }
                else
                    currentItem.Rank = newItem.Rank;
            }
            return result;
        }

        private function InsertNewItems(newItems:Array):void
        {
            for each(var newItem:RankingListItem in newItems)
            {
                var currentItem:RankingListItem = FindByTshirt(_items, newItem.Tshirt);
                if (currentItem == null)
                    _items.push(newItem);
            }
        }
        
        private function SortItems():void
        {
            _items.sortOn(["Rank"]);
        }


        private function FindByTshirt(items:Array, tshirt:int):RankingListItem{
            for each(var item:RankingListItem in items) {
                if (item.Tshirt == tshirt)
                    return item;
            }
            return null;
        }

        
        private function DisplayCurrentItems():void
        {
            DebugOutput("");
            DebugOutput(_stage + " - " + _round);
            for each(var each:RankingListItem in _items){
                DebugOutput(each.Rank + " / " + each.Name + " / " + each.Tshirt);                
            }
        }
        
        private function ParseXmlData(xmlData:XML):Array
        {
            var result:Array = new Array();
            var item:RankingListItem = null;

            _stage = xmlData.element.data.(@id=="stage").@value;
            _round = GetDataValue(xmlData, "round");

            for each(var element:XML in xmlData.children())
            {
                var fieldName:String = element.data.@id;
                var fieldValue:String = element.data.@value;
                
                
                
                var regex:RegExp = /f(\d*)_(rank|tshirt|name|country|result|diff)/ig;   
                var match:Object = regex.exec(fieldName);
                if (match == null) {
                    continue;
                }                
                    
                var idx:int = parseInt(match[1]);
                if (result.length > idx)
                    item = result[idx];
                else {
                    item = new RankingListItem();
                    result.push(item);
                }                    

                if (match[2] == "rank")
                    item.Rank = parseInt(fieldValue);
                else if (match[2] == "name")
                    item.Name = fieldValue;
                else if (match[2] == "tshirt")
                    item.Tshirt = parseInt(fieldValue);
                else if (match[2] == "country")
                    item.country = fieldValue;
                else if (match[2] == "result")
                    item.result = fieldValue;
                else if (match[2] == "diff")
                    item.diff = fieldValue;
               
            }
            
            return result;
        }

        private function GetDataValue(xml:XML, id:String):String {
            return xml.element.data.(@id==id).@value;
        }


        private var nextY:int = 0;
        
        private function DebugOutput(text:String):void {
            var textField:TextField = new TextField();
            textField.text = text;
            textField.y = nextY;
            textField.width = 1000;
            this.addChild(textField);
            
            nextY = nextY + 12;
        }
        
        private function createSampleXml1():XML
        {
            var xmlString:String = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n"
+ "<elements>"
+ "<element><data id=\"stage\" value=\"Lead Men\"/></element>\r\n"
+ "<element><data id=\"round\" value=\"Qualifications Group 1\"/></element>\r\n"

+ "<element><data id=\"f0_tshirt\" value=\"101\"/></element>\r\n"
+ "<element><data id=\"f0_name\" value=\"Hans\"/></element>\r\n"
+ "<element><data id=\"f0_country\" value=\"RUS\"/></element>\r\n"
+ "<element><data id=\"f0_rank\" value=\"1\"/></element>\r\n"
+ "<element><data id=\"f0_result\" value=\"12.123\"/></element>\r\n"
+ "<element><data id=\"f0_diff\" value=\"+1.00\"/></element>\r\n"

+ "<element><data id=\"f1_tshirt\" value=\"102\"/></element>\r\n"
+ "<element><data id=\"f1_name\" value=\"Peter\"/></element>\r\n"
+ "<element><data id=\"f1_country\" value=\"RUS\"/></element>\r\n"
+ "<element><data id=\"f1_rank\" value=\"2\"/></element>\r\n"
+ "<element><data id=\"f1_result\" value=\"12.123\"/></element>\r\n"
+ "<element><data id=\"f1_diff\" value=\"+1.00\"/></element>\r\n"

+ "</elements>";
            return new XML(xmlString);
        }
        
        private function createSampleXml2():XML
        {
            var xmlString:String = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n"
+ "<elements>"
+ "<element><data id=\"stage\" value=\"Lead Men\"/></element>\r\n"
+ "<element><data id=\"round\" value=\"Semi Finals\"/></element>\r\n"

+ "<element><data id=\"f0_tshirt\" value=\"101\"/></element>\r\n"
+ "<element><data id=\"f0_name\" value=\"Hans\"/></element>\r\n"
+ "<element><data id=\"f0_country\" value=\"RUS\"/></element>\r\n"
+ "<element><data id=\"f0_rank\" value=\"1\"/></element>\r\n"
+ "<element><data id=\"f0_result\" value=\"12.123\"/></element>\r\n"
+ "<element><data id=\"f0_diff\" value=\"+1.00\"/></element>\r\n"

+ "<element><data id=\"f1_tshirt\" value=\"103\"/></element>\r\n"
+ "<element><data id=\"f1_name\" value=\"Zweier\"/></element>\r\n"
+ "<element><data id=\"f1_country\" value=\"RUS\"/></element>\r\n"
+ "<element><data id=\"f1_rank\" value=\"2\"/></element>\r\n"
+ "<element><data id=\"f1_result\" value=\"12.123\"/></element>\r\n"
+ "<element><data id=\"f1_diff\" value=\"+1.00\"/></element>\r\n"

+ "<element><data id=\"f2_tshirt\" value=\"102\"/></element>\r\n"
+ "<element><data id=\"f2_name\" value=\"Peter\"/></element>\r\n"
+ "<element><data id=\"f2_country\" value=\"RUS\"/></element>\r\n"
+ "<element><data id=\"f2_rank\" value=\"3\"/></element>\r\n"
+ "<element><data id=\"f2_result\" value=\"12.123\"/></element>\r\n"
+ "<element><data id=\"f2_diff\" value=\"+1.00\"/></element>\r\n"


+ "</elements>";
            return new XML(xmlString);
        }
        
        private function createSampleXml3():XML
        {
            var xmlString:String = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n"
+ "<elements>"
+ "<element><data id=\"stage\" value=\"Lead Men\"/></element>\r\n"
+ "<element><data id=\"round\" value=\"Qualifications Group 1\"/></element>\r\n"

+ "<element><data id=\"f0_tshirt\" value=\"101\"/></element>\r\n"
+ "<element><data id=\"f0_name\" value=\"Hans\"/></element>\r\n"
+ "<element><data id=\"f0_country\" value=\"RUS\"/></element>\r\n"
+ "<element><data id=\"f0_rank\" value=\"2\"/></element>\r\n"
+ "<element><data id=\"f0_result\" value=\"12.123\"/></element>\r\n"
+ "<element><data id=\"f0_diff\" value=\"+1.00\"/></element>\r\n"

+ "<element><data id=\"f1_tshirt\" value=\"103\"/></element>\r\n"
+ "<element><data id=\"f1_name\" value=\"Zweier\"/></element>\r\n"
+ "<element><data id=\"f1_country\" value=\"RUS\"/></element>\r\n"
+ "<element><data id=\"f1_rank\" value=\"3\"/></element>\r\n"
+ "<element><data id=\"f1_result\" value=\"12.123\"/></element>\r\n"
+ "<element><data id=\"f1_diff\" value=\"+1.00\"/></element>\r\n"


+ "<element><data id=\"f2_tshirt\" value=\"104\"/></element>\r\n"
+ "<element><data id=\"f2_name\" value=\"Gregor\"/></element>\r\n"
+ "<element><data id=\"f2_country\" value=\"RUS\"/></element>\r\n"
+ "<element><data id=\"f2_rank\" value=\"1\"/></element>\r\n"
+ "<element><data id=\"f2_result\" value=\"12.123\"/></element>\r\n"
+ "<element><data id=\"f2_diff\" value=\"+1.00\"/></element>\r\n"

+ "</elements>";
            return new XML(xmlString);
        }

    }
}

import flash.display.MovieClip;
import flash.text.TextField;

internal class RankingContainer extends MovieClip
{
    private var _updateCount:int = 0;
    private var _boxes:Array = new Array();   
    private var _items:Array = new Array();
    
    private var _debug:TextField = new TextField();
    
    public function RankingContainer():void {
        addChild(_debug);
        _debug.y = 300;
        _debug.width = 300;
        _debug.text = "halo";
    }
    
    private function setDebugText(text:String):void {
        _debug.text = text;
    }

    
    public function updateItems(items:Array):void
    {
        _updateCount++;
        setDebugText("entered updateItems() - update count: " + _updateCount.toString());
        _items = items;

        markStaleBoxes();
        
        updateActiveBoxes();

        insertNewBoxes();

        transition();     
        
        removeStaleBoxes();   
        
        setDebugText("leaving updateItems() - update count: " + _updateCount.toString());
    }

    private function markStaleBoxes():void
    {
        setDebugText("entered markStaleBoxes()");
        
        var markedCount:int = 0;
        for each(var box:RankingBox in _boxes) {
            var item:RankingListItem = findItem(box.tshirt);
            if (item == null) {
                box.markStale();
                markedCount++;
                continue;
            }           
        }
        
        setDebugText("leaving markStaleBoxes() - marked count: " + markedCount.toString());
    }


    private function updateActiveBoxes():void
    {
        setDebugText("entered updateActiveBoxes()");

        for each(var box:RankingBox in _boxes) {
            var item:RankingListItem = findItem(box.tshirt);
            if (item == null)
                continue;
            
            box.updateItem(item);
        }
        
        setDebugText("leaving updateActiveBoxes()");
    }

    private function insertNewBoxes():void
    {
        setDebugText("entered insertNewBoxes()");
       
        var creationCount:int;
        var box:RankingBox;
        for each(var item:RankingListItem in _items) {
            box = findBox(item.Tshirt);
            
            if (box == null) {
                box = createBox(item);
                creationCount++;
            }
        }
 
        setDebugText("leaving insertNewBoxes() / boxes created: " + creationCount.toString()); 
    }
   
    private function removeStaleBoxes():void
    {
        setDebugText("entered removeStaleBoxes()");

        // Ich habe keine Ahnung, was in ActionScript passiert, wenn man in einer for-each-Schleife
        // das Array sliced. Deshalb der sichere Weg: Wir merken uns, welche Boxen wir in der 
        // zweiten Schleife dann entfernen.        
        var boxesToRemove:Array = new Array();
        for each(var box:RankingBox in _boxes) {
             if (box.getIsStale())
                 boxesToRemove.push(box);   
        }


        var removalCount:int;
        for each(var boxToRemove:RankingBox in boxesToRemove) {
            removeChild(boxToRemove);    
            var idx:int = _boxes.indexOf(boxToRemove);
            _boxes = _boxes.slice(idx, 1);
            removalCount++;
        }
        
        setDebugText("leaving removeStaleBoxes() - boxes removed: " + removalCount.toString());
    }

    private function createBox(item:RankingListItem):RankingBox {
        var result:RankingBox = new RankingBox();
        result.setItem(item);
        result.visible = true;
        _boxes.push(result);
        addChild(result);
        return result;
    }

    private function findItem(tshirt:int):RankingListItem
    {
        for each(var item:RankingListItem in _items) {
            if (item.Tshirt == tshirt)
                return item;
        }
        return null;
    }


    private function findBox(tshirt:int):RankingBox
    {
        for each(var box:RankingBox in _boxes) {
            if (box.tshirt == tshirt)
                return box;
        }
        return null;
    }
    
    private function transition():void {
        setDebugText("entered transition()");
        
        for each(var box:RankingBox in _boxes) {
            setDebugText("calling box.transition()");
            box.transition();
        }
        
        setDebugText("leaving transition()");
    }

}  

internal class RankingBox extends MovieClip
{
    private const _positionOffset:int = 20;
    private var _textBox:TextField;   
    
    private var _isStale:Boolean = false;
    private var _position:int;
    
    public var tshirt:int;
    
    public function getIsStale():Boolean {
        return _isStale;
    }

    
    private var _item:RankingListItem;
    
    public function RankingBox(): void {
        _textBox = new TextField();
        _textBox.y = 0;
        _textBox.x = 0;
        _textBox.width = 300;
        _textBox.visible = true;
        addChild(_textBox);
    }

    private function makeVisible():void {
        // TODO: Fade out dieser Box
        this.visible = true;
    }
    
    private function makeInvisible():void {
        // TODO: Fade in dieser Box
        this.visible = false;
    }
    
    private function moveToPosition(position:int):void {
        var newY:int = 100 + position * _positionOffset;
        if (!this.visible) {
            // TODO: Nichts. Es ist nicht sichtbar, da können wir die Position blitzartig setzen.
            this.y = newY;
        }
        else {
            // TODO: Verschieben der Box
            this.y = newY;
        }

    }
    
    public function markStale():void {
        _isStale = true;
        updateTextBoxText();
    }

    public function setItem(item:RankingListItem):void {
        _item = item;
        tshirt = item.Tshirt;
        updateTextBoxText();
    }
    
    private function updateTextBoxText():void {
        var text:String = "";
        if (_isStale)
           text = "STALE";
        _textBox.text = text + " " + _item.Rank + " / " + _item.Name + " / " + tshirt.toString() + " / " + _item.country + " / " + _item.result + " / " + _item.diff;
    }

    
    public function updateItem(item:RankingListItem):void {
        setItem(item);    
    }

    public function transition():void {
        if (_isStale) {
            makeInvisible();
            return;
        }

        moveToPosition(_item.Rank - 1);
        makeVisible();
        
    }
}


internal class RankingListItem {
    public var Rank:int;
    public var NewRank:int;
    public var Name:String;
    public var Tshirt:int;
    public var country:String;
    public var result:String;
    public var diff:String;
}


    

