/**
 * Copyright ChevyRay ( http://wonderfl.net/user/ChevyRay )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/x8rG
 */

package
{
    import flash.filters.GlowFilter;
    import flash.geom.Matrix;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.filters.BlurFilter;
    import flash.display.Shape;
    import flash.events.Event;
    import flash.display.Sprite;
    
    public class BlobTrail extends Sprite
    {
        public var bitmap:Bitmap;
        public var canvas:BitmapData;
        public var circle:Shape = new Shape();
        public var matrix:Matrix = new Matrix();
        public var overlay:Shape = new Shape();
        
        public function BlobTrail()
        {
            stage.frameRate = 60;
            
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            
            canvas = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0);
            bitmap = new Bitmap(canvas);
            addChild(bitmap);
            
            bitmap.filters = [new BlurFilter(50, 50, 3)];
            
            circle.graphics.beginFill(0xFFFFFF);
            circle.graphics.drawCircle(0, 0, 25);
            
            overlay.graphics.beginFill(0x000000, 0.05);
            overlay.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            
            addEventListener(Event.ENTER_FRAME, update);
        }
        
        public function update(e:Event):void
        {
            canvas.draw(overlay);
            
            matrix.tx = mouseX;
            matrix.ty = mouseY;
            canvas.draw(circle, matrix);
        }
    }
}