/**
 * Copyright salmonboy11 ( http://wonderfl.net/user/salmonboy11 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/x8a5
 */

// forked from lizhi's google image
package  
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.ProgressEvent;
    import flash.geom.Point;
    import flash.net.URLRequest;
    import flash.system.Security;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    /**
     * ...
     * @author lizhi
     */
    [SWF(width=465,height=465,backgroundColor=0xffffff,frameRate=60)]
    public class GoogleTest extends Sprite
    {
        private var sprite:BitmapDataSprite;
        private var numcols:int;
        private var numrows:int;
        private var isMouseDown:Boolean = false;
        private var loader:Loader;
        private var info:TextField
        public function GoogleTest() 
        {
            Security.loadPolicyFile("http://assets.wonderfl.net/crossdomain.xml");
            
            
            loader = new Loader();
            loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/4/4e/4e97/4e973c0b6096cdf13fa71af7c6836caecac9514d"));
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loader_complete);
            loader.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, loader_progress);
            info = new TextField;
            addChild(info);
            info.autoSize = TextFieldAutoSize.LEFT;
        }
        
        private function loader_progress(e:ProgressEvent):void 
        {
            info.text = e.bytesLoaded + "/" + e.bytesTotal;
        }
        
        private function loader_complete(e:Event):void 
        {
            var bmd:BitmapData = (loader.content as Bitmap).bitmapData;
            var world:World = new World;
            world.start();
            sprite = new BitmapDataSprite(world);
            var sw:int = bmd.width / 6;
            var sh:int = bmd.height / 3;
            var offest:Point = new Point(-int(bmd.width / 12), -int(bmd.height / 6));
            var gap:int = 10;
            numcols = 6;
            numrows = 3;
            for (var y:int = 0; y < numrows;y++ ){
                for (var x:int = 0; x < numcols/2;x++ ) {
                    sprite.addAnimation(AnimationParser.parserByIndexs(bmd,sw , sh, gap, Vector.<uint>([y*numcols+x]),offest, (y*numcols+x)+""));
                    sprite.addAnimation(AnimationParser.parserByIndexs(bmd,sw , sh, gap, Vector.<uint>([y*numcols+x,y*numcols+x+3]),offest,y*numcols+x+3+""));
                }
            }
            sprite.play("7");
            world.add(sprite);
            sprite.x = stage.stageWidth / 2;
            sprite.y = stage.stageHeight / 2;
            addChild(world);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, stage_mouseMove);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, stage_mouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, stage_mouseUp);
        }
        
        private function stage_mouseUp(e:MouseEvent):void 
        {
            isMouseDown = false;
            stage_mouseMove(null);
        }
        
        private function stage_mouseDown(e:MouseEvent):void 
        {
            isMouseDown = true;
            stage_mouseMove(null);
        }
        
        private function stage_mouseMove(e:MouseEvent):void 
        {
            var dx:Number = mouseX - sprite.x;
            var dy:Number = mouseY - sprite.y;
            var w:Number = 50;
            var x:int = 1;
            if (dx<-w) {
                x = 0;
            }else if (dx>w) {
                x = 2;
            }
            var y:int = 1;
            if (dy<-w) {
                y = 0;
            }else if (dy>w) {
                y = 2;
            }
            sprite.play((y*numcols+x+(isMouseDown?3:0))+"",sprite.frame);
        }
        
    }

}
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.MovieClip;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.Matrix;
import flash.geom.Point;
import flash.geom.Rectangle;


class AnimationData
    {
        public var name:String;
        public var frames:Vector.<uint>;
        public var bmds:Vector.<BitmapData>;
        public var offset:Point;
        public var wh:Point;
        public function AnimationData() 
        {
            
        }
        public function updateWH():void {
            if (wh == null) wh = new Point;
            for each(var bmd:BitmapData in bmds) {
                wh.x = wh.x < bmd.width?bmd.width:wh.x;
                wh.y = wh.y < bmd.height?bmd.height:wh.y;
            }
        }
    }
    class AnimationParser 
    {
        /**
         * 最基本的生成函数
         */
        static public function parser(bmds:Vector.<BitmapData>,frames:Vector.<uint>, offset:Point,name:String):AnimationData {
            var ani:AnimationData = new AnimationData;
            ani.bmds = bmds;
            ani.updateWH();
            ani.frames = frames;
            ani.name = name;
            ani.offset = offset;
            return ani;
        }
        
        /**
         * 动态间隔生成
         */
        static public function parserDynamicGap(bmds:Vector.<BitmapData>, gap:int, offset:Point, name:String):AnimationData {
            var frames:Vector.<uint> = new Vector.<uint>;
            for (var i:int = 0; i < bmds.length;i++ ) {
                for (var j:int = 0; j <= gap;j++ ) {
                    frames.push(i);
                }
            }
            return parser(bmds,frames,offset,name);
        }
        
        /**
         * 根据rect生成
         */
        static public function parserByRectsAndGap(bmd:BitmapData, rects:Vector.<Rectangle>, gap:int, offset:Point, name:String):AnimationData {
            var bmds:Vector.<BitmapData> = new Vector.<BitmapData>;
            for (var i:int = 0; i < rects.length; ++i)
            {
                var rect:Rectangle = rects[i];
                var bmd1:BitmapData = new BitmapData(rect.width, rect.height, true, 0);
                bmd1.setVector(bmd1.rect, bmd.getVector(rect));
                bmds.push(bmd1);
            }
            return parserDynamicGap(bmds, gap, offset, name);
        }
        
        static public function parserByIndexs(bmd:BitmapData, sw:int, sh:int, gap:int, indexs:Vector.<uint>,offset:Point, name:String):AnimationData {
            var numCols:int = int(bmd.width / sw);
            var bmds:Vector.<BitmapData> = new Vector.<BitmapData>;
            var rect:Rectangle = new Rectangle(0, 0, sw, sh);
            for each(var i:int in indexs) {
                var x:int = i % numCols;
                var y:int = i / numCols;
                var bmd1:BitmapData = new BitmapData(sw, sh, true, 0);
                rect.x = x * sw;
                rect.y = y * sh;
                bmd1.setVector(bmd1.rect, bmd.getVector(rect));
                bmds.push(bmd1);
            }
            return parserDynamicGap(bmds, gap, offset, name);
        }
        
        static public function parserByMovieClip(mc:MovieClip, name:String, gap:int = 0):AnimationData {
            var rects:Array = [];
            var w:Sprite = new Sprite;
            w.addChild(mc);
            var bmds:Vector.<BitmapData> = new Vector.<BitmapData>;
            var minX:int = int.MAX_VALUE;
            var minY:int = int.MAX_VALUE;
            for (var i:int = 0; i < mc.totalFrames;i++ ) {
                mc.gotoAndStop(i + 1);
                var r:Rectangle = w.getBounds(w);
                minX = Math.min(minX, r.x);
                minY = Math.min(minY, r.y);
                rects.push(r);
            }
            for (i = 0; i < mc.totalFrames; i++ ) {
                mc.gotoAndStop(i + 1);
                r = rects[i];
                r.left = minX;
                r.top = minY;
                var bmd:BitmapData = new BitmapData(Math.max(1, r.width), Math.max(1, r.height), true, 0);
                bmd.draw(w, new Matrix(1, 0, 0, 1, -r.x, -r.y));
                bmds.push(bmd);
            }
            return parserDynamicGap(bmds,gap,new Point(minX,minY),name);
        }
    }
class BitmapDataSprite extends Sprite
        {
            public var next:BitmapDataSprite;
            public var pre:BitmapDataSprite;
            private var image:Bitmap;
            private var isPlaying:Boolean = false;
            private var currentAnimationName:String;
            public var currentAnimationBitmapData:BitmapData;
            private var currentAnimationData:AnimationData;
            private var _frame:int;
            private var animations:Array;
            public var bound:Rectangle;
            public var gridindexs:Array;
            
            public var onMouseOver:Function;
            public var onMouseOut:Function;
            
            private var world:World;
            
            public var scaleGap:Number = 1;
            public function BitmapDataSprite(world:World) 
            {
                this.world = world;
            }
            public function update():void {
                if (isPlaying && currentAnimationData) {
                    if (frame*scaleGap >= currentAnimationData.frames.length) _frame = 0;
                    currentAnimationBitmapData = currentAnimationData.bmds[currentAnimationData.frames[int(frame*scaleGap)]];
                    image.bitmapData = currentAnimationBitmapData;
                    _frame++;
                }
            }
            public function play(name:String, frame:int = 0):void {
                isPlaying = true;
                _frame = frame;
                currentAnimationName = name;
                currentAnimationData = animations[name];
                if (image == null) image = new Bitmap;
                addChild(image);
                image.x = currentAnimationData.offset.x;
                image.y = currentAnimationData.offset.y;
            }
            public function stop(name:String, frame:int=0):void {
                isPlaying = false;
            }
            public function addAnimation(ani:AnimationData):AnimationData {
                if (bound == null) bound = new Rectangle;
                if (bound.left > ani.offset.x) bound.left = ani.offset.x;
                if (bound.top > ani.offset.y) bound.top = ani.offset.y;
                if (bound.right < ani.offset.x + ani.wh.x) bound.right = ani.offset.x + ani.wh.x;
                if (bound.bottom < ani.offset.y + ani.wh.y) bound.bottom = ani.offset.y + ani.wh.y;
                if (animations==null) animations = [];
                animations[ani.name] = ani;
                return ani;
            }
            
            public function get frame():int 
            {
                return _frame;
            }
        }class World extends BitmapDataSprite
    {
        private var sprite:BitmapDataSprite;
        private var endSprite:BitmapDataSprite;
        private var sprites:Array;
        private var mouseSprites:Vector.<BitmapDataSprite>;
        
        private var grid:Array;
        private var _gridWidth:Number = 123;
        private var _gridHeight:Number = 58;
        private var firstPoint:Point = new Point;
        private var secondObject:Point = new Point;
        private var lastMouseSprite:BitmapDataSprite;
        
        public function World() 
        {
            super(null);
            sprites = [];
            mouseChildren = false;
        }
        public function add(sprite:BitmapDataSprite,enableMouse:Boolean=false):BitmapDataSprite {
            addChild(sprite);
            if (this.sprite == null) {
                this.sprite = sprite;
            }else {
                endSprite.next = sprite;
                sprite.pre = endSprite;
            }
            endSprite = sprite;
            if (enableMouse) {
                addToGrid(sprite);
                addEventListener(MouseEvent.MOUSE_MOVE, testGrid);
                addEventListener(MouseEvent.MOUSE_OUT, testGrid);
                if (mouseSprites == null) mouseSprites = new Vector.<BitmapDataSprite>;
                mouseSprites.push(sprite);
            }
            sprites.push(sprite);
            return sprite;
        }
        
        public function sortByY():void {
            sprites.sortOn("y", Array.NUMERIC);
            while (numChildren > 0) {
                removeChildAt(0);
            }
            for each(var s:BitmapDataSprite in sprites) {
                addChild(s);
            }
        }
        
        public function resetGridNoSort():void {
            grid = [];
            for each(var sprite:BitmapDataSprite in mouseSprites) {
                for (var y:int = (sprite.y+sprite.bound.top)/ _gridHeight; y < int((sprite.y+sprite.bound.bottom) / _gridHeight) + 1;y++ ) {
                    if (grid[y] == null) grid[y] = [];
                    for (var x:int = (sprite.x+sprite.bound.left) / _gridWidth; x < int((sprite.x+sprite.bound.right) / _gridWidth) + 1;x++ ) {
                        if (grid[y][x] == null) grid[y][x] = [];
                        grid[y][x].unshift(sprite);
                    }
                }
            }
        }
        
        public function addToGrid(sprite:BitmapDataSprite):void {
            if (grid == null) grid = [];
            if (sprite.gridindexs) {
                for (var i:int = 0; i < sprite.gridindexs.length;i+=2 ) {
                    var x:int = sprite.gridindexs[i];
                    var y:int = sprite.gridindexs[i + 1];
                    if (grid[y] && grid[y][x]) {
                        var index:int = grid[y][x].indexOf(sprite);
                        if (index != -1) grid[y][x].splice(index, 1);
                    }
                }
            }
            
            sprite.gridindexs = [];
            for (y = (sprite.y+sprite.bound.top)/ _gridHeight; y < int((sprite.y+sprite.bound.bottom) / _gridHeight) + 1;y++ ) {
                if (grid[y] == null) grid[y] = [];
                for (x = (sprite.x+sprite.bound.left) / _gridWidth; x < int((sprite.x+sprite.bound.right) / _gridWidth) + 1;x++ ) {
                    if (grid[y][x] == null) grid[y][x] = [];
                    var flag:Boolean = true;
                    for (i = 0; i < grid[y][x].length;i++ ) {
                        var temp:BitmapDataSprite = grid[y][x][i];
                        if (getChildIndex(temp)<getChildIndex(sprite)) {
                            grid[y][x].splice(i, 0, sprite);
                            flag = false;
                            break;
                        }
                    }
                    if (flag) grid[y][x].push(sprite);
                    sprite.gridindexs.push(x, y);
                }
            }
        }
        
        //格子鼠标碰撞检测类
        private function testGrid(e:MouseEvent):void 
        {
            var x:int = mouseX / _gridWidth;
            var y:int = mouseY / _gridHeight;
            var flag:Boolean = false;
            if (grid && grid[y] && grid[y][x]) {
                for each(var sprite:BitmapDataSprite in grid[y][x]){
                    var bmd:BitmapData = sprite.currentAnimationBitmapData;
                    firstPoint.x = sprite.x;
                    firstPoint.y = sprite.y;
                    secondObject.x = mouseX;
                    secondObject.y = mouseY;
                    if (bmd.hitTest(firstPoint,0,secondObject)) {
                        if (sprite == lastMouseSprite) {
                            
                        }else {
                            if (lastMouseSprite) {
                                if (lastMouseSprite.onMouseOut!=null) lastMouseSprite.onMouseOut(lastMouseSprite);
                            }
                            lastMouseSprite = sprite;
                            if (lastMouseSprite.onMouseOver!=null) lastMouseSprite.onMouseOver(lastMouseSprite);
                        }
                        flag = true;
                        break;
                    }
                }
            }
            
            if (!flag&&lastMouseSprite) {
                if (lastMouseSprite.onMouseOut!=null) lastMouseSprite.onMouseOut(lastMouseSprite);
                lastMouseSprite = null;
            }
        }
        
        public function remove(sprite:BitmapDataSprite):BitmapDataSprite {
            return null;
        }
        override public function update():void {
            super.update();
            var temp:BitmapDataSprite = sprite;
            while (temp) {
                temp.update();
                temp = temp.next;
            }
        }
        public function start():void {
            addEventListener(Event.ENTER_FRAME, enterFrame);
        }
        public function pause():void {
            removeEventListener(Event.ENTER_FRAME, enterFrame);
        }
        private function enterFrame(e:Event):void {
            update();
            trace("HAHAHA FRANCIAS!!!");
        }
        
        public function set gridWidth(value:Number):void 
        {
            _gridWidth = value;
        }
        
        public function set gridHeight(value:Number):void 
        {
            _gridHeight = value;
        }
    }
    