/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/x8L0
 */

package {
    import flash.events.Event;
    import com.bit101.components.*;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    public class FlashTest extends Sprite 
    {
        private var w:Number;
        private var h:Number;   
        private var ratio:int;
        private var color:uint;
        private var gird:Gird;
        
        public function FlashTest() 
        {
                //Init Variable.
                color = 0xFFFFFFFF;
                ratio = 25;
                w = stage.stageWidth;
                h = stage.stageHeight - 55;
                
                //Init Bitmap.
                initBitmap();
                
                //Init Controller.
                new Controller(stage,draw);
                
                //Init gird.
                gird = new Gird(ratio,ratio,0x333333);
                addChild(gird);
                gird.fill(w,h);
                
                //Init components.
                initComponents();
        }
        
        private var bd:BitmapData;
        private var b:Bitmap;
        
        private function initBitmap():void
        {
               bd = new BitmapData(w / ratio, h / ratio, false, 0x000000);
               
               b = new Bitmap(bd);
               addChild(b);
               b.scaleX = b.scaleY = ratio;
        }
         
         private function draw(px:Number,py:Number):void
         {
              bd.setPixel(int(px / b.scaleX),int(py / b.scaleY), color);
         }        
         
         private function initComponents():void
         {
                var l:Label = new Label(this, 5, h, "Select color and draw");
                l.scaleX = l.scaleY = 1.3;
                
                new PushButton(this, 5, h + 25, "White Brush", function(e:*):void
                    {color = 0xFFFFFFFF;}).width = 65;
                new PushButton(this, 75, h + 25, "Black Brush", function(e:*):void
                    {color = 0xFF000000;}).width = 65;
                new PushButton(this, 145, h + 25, "Red Brush", function(e:*):void
                    {color = 0xFFFF0000;}).width = 65;
                new PushButton(this, 215, h + 25, "Green Brush", function(e:*):void
                    {color = 0xFF00FF00;}).width = 65;
                new PushButton(this, 285, h + 25, "Blue Brush", function(e:*):void
                    {color = 0xFF0000FF;}).width = 65;
                new PushButton(this, 355, h + 25, "Draw Gird", toogleGird).width = 65;
         }
         
         private function toogleGird(e:*):void
         {
                gird.visible = !gird.visible;
         }

    }
}
import flash.display.Graphics;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.display.Stage;
import flash.text.TextField;
import flash.text.TextFormat;

class Controller 
{
    private var stg:Stage;
    private var draw:Function;
    private var md:Boolean;
       
    public function Controller(s:Stage,drawPixel:Function)
    {
        stg = s;
        draw = drawPixel;
        md = false;
        
        s.addEventListener(Event.ENTER_FRAME,onEnterFrame);
        s.addEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
        s.addEventListener(MouseEvent.MOUSE_UP,onMouseUp);
    }
    private function onMouseDown(e:MouseEvent):void
    {
            md = true;          draw(stg.mouseX,stg.mouseY);
    }
    private function onMouseUp(e:MouseEvent):void
    {
            md = false;
    }
    private function onEnterFrame(e:Event):void
    {
            if(md)                 draw(stg.mouseX,stg.mouseY);
    }
}
class Gird extends Sprite
{
    private var girdW:Number;
    private var girdH:Number;
    private var girdColor:uint;
    
    public function Gird(w:Number,h:Number,color:uint):void
    {
        girdW = w;
        girdH = h;
        girdColor = color;
    }
    public function fill(w:Number,h:Number):void
    {
        graphics.lineStyle(.1,girdColor);
        for(var i:int = 0; i < w; i += girdW)
        {
                graphics.moveTo(i,0);
                graphics.lineTo(i,h);
        }
         for(var j:int = 0; j < h; j += girdH)
        {
                graphics.moveTo(0,j);
                graphics.lineTo(w,j);
        }
    }
}
