/**
 * Copyright tenasaku ( http://wonderfl.net/user/tenasaku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/x8DR
 */

// 2010年4月16日
// モザイク処理なのですが
// 元画像の該当領域内からランダムに選んだピクセルの色を使います
// ======
// 元画像は次の3枚のうちからランダムに選びます
//   http://www.tenasaku.com/images/northpole.jpg
//   http://www.tenasaku.com/images/katabami.jpg
//   http://www.tenasaku.com/images/sicily.jpg
// いずれも携帯のカメラで撮ったチャチな写真ですけど
// ======
// 2010年4月17日
// 写真追加しました
//	http://www.tenasaku.com/images/lamen.jpg
//	http://www.tenasaku.com/images/machiya.jpg
//	http://www.tenasaku.com/images/tsutsuji.jpg
//	http://www.tenasaku.com/images/akaneya.jpg
//	http://www.tenasaku.com/images/halloween.jpg

package {

	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.net.*;
	import flash.system.*;
	import flash.text.*;

	public class Main extends Sprite {

		private const IMAGE_URL:Array = [
			"http://www.tenasaku.com/images/northpole.jpg",
			"http://www.tenasaku.com/images/katabami.jpg",
			"http://www.tenasaku.com/images/sicily.jpg",
			"http://www.tenasaku.com/images/lamen.jpg",
			"http://www.tenasaku.com/images/machiya.jpg",
			"http://www.tenasaku.com/images/tsutsuji.jpg",
			"http://www.tenasaku.com/images/akaneya.jpg",
			"http://www.tenasaku.com/images/halloween.jpg"
		];
		private const GRID_SIZE:int = 8;
		private var screen:BitmapData;
		private var source:BitmapData;
		private var frameCount:int = 0;
		private var numCols:int,numRows:int;
		private function loadImage():void {
			var message:TextField = new TextField();
			message.autoSize = TextFieldAutoSize.LEFT;
			message.textColor = 0xffffff;
			message.background = false;
			message.text = "LOADING IMAGE...";
			message.x = (stage.stageWidth-message.width)/2;
			message.y = (stage.stageHeight-message.height)/2;
			var context:LoaderContext = new LoaderContext();
			context.checkPolicyFile = true;
			var ldr:Loader = new Loader();
			ldr.contentLoaderInfo.addEventListener(
				Event.COMPLETE, 
				function (e:Event):void {
					source.draw(ldr);
					ldr.unload();
					message.text = "";
				}
			);
			this.addChild(message);
			ldr.load(new URLRequest( IMAGE_URL[ Math.floor(Math.random()*IMAGE_URL.length) ] ), context );
		}

		private function setGrid(h:int,v:int,c:uint):void {
			if ( ( h < 0 )||( h >= stage.stageWidth/GRID_SIZE ) ) return;
			if ( ( v < 0 )||( v >= stage.stageHeight/GRID_SIZE ) ) return;
			screen.fillRect(
				new Rectangle(
					h*GRID_SIZE+1,
					v*GRID_SIZE+1,
					GRID_SIZE-1,
					GRID_SIZE-1
				),
				c
			);
		}

		private function atEveryFrame(e:Event):void {
			var i:int,j:int;
			for ( i = 0 ; i < numCols ; ++i )
			for ( j = 0 ; j < numRows ; ++j ) {
				var c:uint = source.getPixel(
					i*GRID_SIZE+Math.floor(Math.random()*GRID_SIZE),
					j*GRID_SIZE+Math.floor(Math.random()*GRID_SIZE)
				);
				setGrid(i,j,c);
			}
		}

		private function redrawGrid():void {
			var GRID_COLOR:uint = 0x006600;
			var col:int;
			var row:int;
			col = 0;
			while ( col < stage.stageWidth ) {
				for ( row = 0 ; row < stage.stageHeight ; ++row )
					screen.setPixel(col,row,GRID_COLOR);
				col += GRID_SIZE;
			}
			row = 0;
			while ( row < stage.stageHeight ) {
				for ( col = 0 ; col < stage.stageWidth ; ++col )
					screen.setPixel(col,row,GRID_COLOR);
				row += GRID_SIZE;
			}
		}

		private function initialize(e:Event):void {
			this.removeEventListener(Event.ADDED_TO_STAGE, initialize);
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			screen = new BitmapData(stage.stageWidth,stage.stageHeight,false,0);
			source = new BitmapData(stage.stageWidth,stage.stageHeight,false,0);
			this.addChild(new Bitmap(screen));
			loadImage();
			frameCount = 0;
			numCols = Math.floor(stage.stageWidth/GRID_SIZE);
			numRows = Math.floor(stage.stageHeight/GRID_SIZE);
			stage.addEventListener(Event.ENTER_FRAME, atEveryFrame);
		}
		// The Main constructor simply calles initialize() function.

		public function Main():void {
			if ( stage != null ) {
				initialize(null);
			} else {
				this.addEventListener(Event.ADDED_TO_STAGE, initialize);
			}
		}

	} // end of class Main
} // end of package

