/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/x84R
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    
    import flash.geom.Point;
    import flash.filters.BlurFilter;
    
    [SWF(width = "465", height = "465", frameRate="60")]
    
    
    /**
     * ...
     * @author 
     */
    public class Main extends Sprite 
    {
        
        private var field:Field;
        private var bmd:BitmapData;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            graphics.beginFill(0);
            graphics.drawRect(0, 0, WIDTH, HEIGHT);
            graphics.endFill();
            
            bmd = new BitmapData(WIDTH, HEIGHT, true, 0);
            addChild( new Bitmap(bmd) );
            
            field = new Field(WIDTH,HEIGHT,true,0);
            addChild( new Bitmap( field ) );
            
            addEventListener( Event.ENTER_FRAME, Update );
        }
        
        private function Update(e:Event):void
        {
            bmd.lock();
            bmd.fillRect( bmd.rect, 0 );
            bmd.draw( field );
            bmd.applyFilter( bmd, bmd.rect, new Point(), new BlurFilter(10,10,2) );
            bmd.unlock();
            field.Update();
        }
        
    }
    
}
import flash.display.BitmapData;
import flash.filters.ColorMatrixFilter;
import flash.geom.Point;

const WIDTH:int = 465;
const HEIGHT:int = 465;

class Particle {
    public var x:Number;
    public var y:Number;
    public var vx:Number;
    public var vy:Number;
    
    public var target:Particle = null;
}

class Field extends BitmapData {
    
    private var particles:Vector.<Particle>;
    
    private var filter:ColorMatrixFilter;
    
    public function Field(width:int, height:int, transparent:Boolean = true, fillColor:uint = 0xFFFFFFFF) {
        super(width, height, transparent, fillColor);
        
        particles = new Vector.<Particle>();
        for ( var i:int = 0; i < 500; i++ )
        {
            AddParticle();
        }    
        SetParticleTarget();
        
        filter = new ColorMatrixFilter([
            1, 0, 0, 0, 0,
            0, 1, 0, 0, 0,
            0, 0, 1, 0, 0,
            0, 0, 0, 0.99, 0
        ]); 
    }
    
    
    private function AddParticle() : void
    {
        if ( particles == null )    return;
        
        var particle:Particle = new Particle();
        particle.x = Math.random() * WIDTH;
        particle.y = Math.random() * HEIGHT;
        
        var angle:Number = (Math.random() * 360);
        particle.vx = Math.cos( angle * Math.PI / 180 )*0.5;
        particle.vy = Math.sin( angle * Math.PI / 180 )*0.5;
        
        particles.push( particle );
    }
    
    private function SetParticleTarget() : void {
        var num:int = particles.length;
        for ( var i:int = 0; i < num; i++ )
        {
            particles[i].target = particles[(i + 1 + int(Math.random() * (num - 1))) % num];
        }
    }
    
    
    public function Update() : void
    {
        var num:int = particles.length;
        
        this.lock();
        this.applyFilter( this, rect, new Point(), filter );
        
        for ( var i:int = 0; i < num; i++ )
        {
            var target:Particle = particles[i].target;
            
            particles[i].vx = particles[i].vx + (particles[i].x - target.x) * 0.001 + 0.3;
            particles[i].vy = particles[i].vy + (particles[i].y - target.y) * 0.001 - 0.2;
            
            var vLen:Number = Math.sqrt(particles[i].vx * particles[i].vx + particles[i].vy * particles[i].vy);
            if ( vLen > 2 )
            {
                particles[i].vx = particles[i].vx / vLen * 2;
                particles[i].vy = particles[i].vy / vLen * 2;
            }
            
            particles[i].x += particles[i].vx;
            particles[i].y += particles[i].vy;
            
            if ( particles[i].x < 0 )            particles[i].x = WIDTH + (particles[i].x % WIDTH);
            else if ( particles[i].x >= WIDTH ) particles[i].x = particles[i].x % WIDTH;
            
            if ( particles[i].y < 0 )            particles[i].y = HEIGHT + (particles[i].y % HEIGHT);
            else if ( particles[i].y >= HEIGHT ) particles[i].y = particles[i].y % HEIGHT;
            
            this.setPixel32( particles[i].x, particles[i].y, 0xFFFFFFFF );
            this.setPixel32( particles[i].x+1, particles[i].y+1, 0xFFAAAAAA );
        }
        
        this.unlock();
    }
    
}