/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/x7dC
 */

// forked from kotobuki's forked from: RGBCube for AS3
// forked from kotobuki's RGBCube for AS3
package {
    import flash.events.Event;

    import org.papervision3d.cameras.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.scenes.*;
    import org.papervision3d.view.*;

    import funnel.*;

    [SWF(backgroundColor="0x7F7F7F")]

    public class MeasuringTheTilt_Accelerometer extends BasicView {
        // The cube
        private var cube:Cube;

        // The FIO system
        private var fio:Fio;

        // the pins connected to the X and Y axis pin
        private var xAxisPin:Pin;
        private var yAxisPin:Pin;
    
        public function MeasuringTheTilt_Accelerometer() {
            fio = new Fio([1], Fio.FIRMATA);
            fio.samplingInterval = 20;

            xAxisPin = fio.ioModule(1).analogPin(2);
            yAxisPin = fio.ioModule(1).analogPin(1);

            // Set filters to remove noise and scale inputs
            xAxisPin.addFilter(new Convolution(Convolution.MOVING_AVERAGE));
            xAxisPin.addFilter(new Scaler(0.298, 0.704, -1, 1));
            yAxisPin.addFilter(new Convolution(Convolution.MOVING_AVERAGE));
            yAxisPin.addFilter(new Scaler(0.303, 0.704, -1, 1));

            // Create the cube
            var materialsList:MaterialsList = new MaterialsList();
            materialsList.addMaterial(new ColorMaterial(0xFF0000), "front");
            materialsList.addMaterial(new ColorMaterial(0x00FF00), "back");
            materialsList.addMaterial(new ColorMaterial(0x0000FF), "right");
            materialsList.addMaterial(new ColorMaterial(0xFFFF00), "left");
            materialsList.addMaterial(new ColorMaterial(0xFF00FF), "top");
            materialsList.addMaterial(new ColorMaterial(0x00FFFF), "bottom");
            cube = new Cube(materialsList, 200, 200, 200);
            scene.addChild(cube);

            // Set the camera
            camera.x = 0;
            camera.y = 0;
            camera.z = -500;
            camera.focus = 500;
            camera.zoom = 1;

            // Ready to run!
            startRendering();
        }

        override protected function onRenderTick(event:Event = null):void {
            cube.rotationZ = Math.asin(yAxisPin.value) / Math.PI * 180;;
            cube.rotationX = Math.asin(xAxisPin.value) / Math.PI * 180;;

            renderer.renderScene(scene, camera, viewport);
        }
    }
}