/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/x7Q1
 */

// forked from Scmiz's land
// forked from Scmiz's flash on 2011-4-10
package {
	import flash.display.DisplayObject;
    import flash.events.Event;
    import flash.display.Sprite;
	import flash.display.Graphics;
	
    import org.papervision3d.view.BasicView;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.utils.MaterialsList;

    public class FlashTest extends Sprite {
        private var _view:BasicView;
		private var _container:DisplayObject3D;
        
        public function FlashTest() {
			drawBG(
				this.graphics,
				255, 240, 240,
				255, 200, 200
			);
			
            _view = new BasicView(465, 465);
            _view.camera.zoom = 50;
            this.addChild(_view);            
            
            _container = new DisplayObject3D();
            _view.scene.addChild(_container);

			_container.addChild(new MelodyObjA());

            _view.startRendering();

            var proc:Function = function(e:Event):void {
				_container.rotationY += 1;
            };
            this.addEventListener(Event.ENTER_FRAME, proc);
        }
		

		private function drawBG(g:Graphics, topColorR:uint, topColorG:uint, topColorB:uint, bottomColorR:uint, bottomColorG:uint, bottomColorB:uint):void {
			g.clear();
			
			for (var index:uint = 0; index < 465; ++index) {
				var ratio:Number = Math.abs(Number(233 - index)) / 233;
				ratio = Math.sin(ratio * Math.PI * 0.5);
				var ratioR:Number = 1.0 - ratio;
				var cr:uint = (topColorR * ratioR) + (bottomColorR * ratio);
				var cg:uint = (topColorG * ratioR) + (bottomColorG * ratio);
				var cb:uint = (topColorB * ratioR) + (bottomColorB * ratio);
				var color:uint = (cr << 16) + (cg << 8) + (cb << 0);
				
				g.beginFill(color);
				g.drawRect(0, 1 * index, 465, 1);
				g.endFill();
			}
		}
    }
}

import org.papervision3d.view.BasicView;
import org.papervision3d.objects.DisplayObject3D;
import org.papervision3d.objects.primitives.Cube;
import org.papervision3d.materials.ColorMaterial;
import org.papervision3d.materials.utils.MaterialsList;
class MelodyObjA extends DisplayObject3D
{
	private var _frame1:DisplayObject3D;
	private var _frame2:DisplayObject3D;
	private var _frame3:DisplayObject3D;
	private var _plate:DisplayObject3D;
	
	public function MelodyObjA() {
		var thickness:Number = 10;
		var frameWidth:Number = 30;
		_frame1 = createFrame(frameWidth, 450, thickness, 0xd0ffd0);
		_frame2 = createFrame(frameWidth, 360, thickness, 0xffa0a0);
		_frame3 = createFrame(frameWidth, 270, thickness, 0xffffb0);
		
		_plate = new DisplayObject3D();
		var mat:ColorMaterial = new ColorMaterial(0xff8080);
		var materials:MaterialsList = new MaterialsList();
		materials.addMaterial(mat, "all");
		var size:Number = 150;
		var cube:Cube = new Cube(materials, size, thickness, size);
		_plate.addChild(cube);
		
		_frame1.rotationY = -15;
		_frame2.rotationY = 10;
		_frame3.rotationY = -5;
		_plate.rotationY = 0;
		
		this.addChild(_frame1);
		this.addChild(_frame2);
		this.addChild(_frame3);
		this.addChild(_plate);
	}

	private function createFrame(width:Number, height:Number, thickness:Number, color:uint):DisplayObject3D {
		var obj:DisplayObject3D = new DisplayObject3D();

		var mat:ColorMaterial = new ColorMaterial(color);
		var materials:MaterialsList = new MaterialsList();
		materials.addMaterial(mat, "all");

		var c1:Cube = new Cube(materials, width, thickness, height);
		var c2:Cube = new Cube(materials, width, thickness, height);
		var c3:Cube = new Cube(materials, height - (width * 2), thickness, width);
		var c4:Cube = new Cube(materials, height - (width * 2), thickness, width);

		c1.x = -(height * 0.5) + (width * 0.5);
		c1.y = 0;
		c2.x = +(height * 0.5) - (width * 0.5);
		c2.y = 0;
		c3.x = 0;
		c3.y = c1.x;
		c4.x = 0;
		c4.y = c2.x;

		obj.addChild(c1);
		obj.addChild(c2);
		obj.addChild(c3);
		obj.addChild(c4);
		return obj;
	}
}