/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/x6dl
 */

// forked from makc3d's forked from: Smoking Cursor G2
// added basic optimizations, the rest is up to logic improvements
package 
{
    import flash.display.StageScaleMode;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.BlendMode;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.filters.ColorMatrixFilter;
    import flash.filters.DisplacementMapFilter;
    import flash.filters.DisplacementMapFilterMode;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;

    [SWF(width=300,height=300, backgroundColor=0)]

    public class SmokingCursor2_2 extends MovieClip 
    {
        private const WIDTH : Number = 300;
        private const HEIGHT : Number = 300;
        private var bmpClouds : BitmapData;
        private var bmpClouds10 : BitmapData;

        private var pixelsBmp : BitmapData;

        private var origin : Point = new Point(0, 0);

        private var displace : DisplacementMapFilter;

        private var channels : uint;
        private var seed : Number;

        private var cursor : Sprite = new Sprite();

        private var cf : ColorMatrixFilter;
        private var output : BitmapData;
        private var num : int;

        private var pixels : Array;
        private var ct : ColorTransform;
        private var p1 : Point;
        private var black : BitmapData;
        private var px : Number;
        private var py : Number;
        private var size : int;
        private var curSize : int;

        private var tmpOut : BitmapData; 

        public function SmokingCursor2_2()
        {
            num = 6;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            bmpClouds = new BitmapData(WIDTH + num * 7 + 20 * 2, HEIGHT, false);
            bmpClouds10 = new BitmapData(0.1*bmpClouds.width, 0.1*bmpClouds.height, false);
        
            pixelsBmp = new BitmapData(WIDTH, HEIGHT, false, 0);//,0xFFFFFF);

            output = new BitmapData(WIDTH, HEIGHT, false, 0);
            addChild(new Bitmap(output));
            
            black = new BitmapData(WIDTH, HEIGHT, false, 0);
            
            
            pixels = [];
            for(var i : int = 0;i < num;i++)
            {
        
                var pixel : BitmapData = new BitmapData(WIDTH, HEIGHT, false, 0);//,0xFFFFFF);
                pixels.push(pixel);
            }
        
            seed = 3;
            channels = BitmapDataChannel.RED | BitmapDataChannel.BLUE;
            
            cf = new ColorMatrixFilter([2, 0, 0, 0, 0, 
                                               0, 1, 0, 0, 0, 
                                               0, 0, 1, 0, 0, 
                                            0, 0, 0, 1, 0]);
                                            
            
            addEventListener(Event.ENTER_FRAME, update);
            
            
            ct = new ColorTransform();
            ct.alphaMultiplier = 1 / num;
            
            p1 = new Point();
            
       
            
            px = mouseX;
            py = mouseY;
            size = 5;
            curSize = 0;
            
            var blur : BlurFilter = new BlurFilter(3, 3, 2);
            cursor.filters = [blur];

            tmpOut = new BitmapData(WIDTH, HEIGHT, false, 0);
            displace = new DisplacementMapFilter(bmpClouds, new Point, BitmapDataChannel.BLUE, BitmapDataChannel.RED, 15, 5, DisplacementMapFilterMode.COLOR, 0);
        }

        private function update(evt : Event) : void
        {
            with(cursor)
            {
                graphics.clear();
                if(px == mouseX && py == mouseY)
                {
                    graphics.beginFill(0xffffff);
                    
                    graphics.moveTo(mouseX - 6, mouseY - 0);
                    graphics.lineTo(mouseX + 11 - 6, mouseY + 10 - 2);
                    graphics.lineTo(mouseX + 6 - 6, mouseY + 10 - 2);
                    graphics.lineTo(mouseX + 2 - 6, mouseY + 12 - 2);
                
                    if(curSize < size) curSize++;
                } 
                else 
                {
                    graphics.moveTo(px, py);
                    graphics.lineStyle(6, 0xffffff, 6);
                    graphics.lineTo(mouseX, mouseY);
                    curSize = 10;
                }
                px = mouseX;
                py = mouseY;
            }
            //--
            var m : Matrix = new Matrix();
            m.translate(mouseX, mouseY);
            tmpOut.fillRect (tmpOut.rect, 0);
            
            output.copyPixels(black, black.rect, origin);


            bmpClouds10.perlinNoise(14, 13, 1, seed, true, true, channels, false, [p1]);
            bmpClouds10.applyFilter(bmpClouds10, bmpClouds10.rect, origin, cf);
            bmpClouds.draw (bmpClouds10, new Matrix (bmpClouds.width / bmpClouds10.width, 0, 0, bmpClouds.height / bmpClouds10.height), null, null, null, true);

            for(var i : int = 0;i < num;i++)
            {
                pixelsBmp = pixels[i];

                tmpOut.draw(pixelsBmp, null, ct, BlendMode.ADD);
                pixelsBmp.draw(cursor);
                pixelsBmp.colorTransform (pixelsBmp.rect, new ColorTransform (0.5, 0.9, 1, 0.999));
                
                
                displace.mapPoint = new Point(-(i % 3) * 20 - i * 2, 0);
                
                pixelsBmp.applyFilter(pixelsBmp, pixelsBmp.rect, origin, displace);
            }
            
            output.copyPixels(tmpOut, tmpOut.rect, origin);
            
            p1.offset(.55, .05);
        }
    }
}
