/**
 * Copyright heckmeck ( http://wonderfl.net/user/heckmeck )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/x6Ie
 */

// forked from Aquioux's Code P.4.3.1.01 (Generative Gestaltung)
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Loader;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import frocessing.color.ColorRGB;
    [SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "#FFFFFF")]
    
    /**
     * Code P_4_3_1_01 --- CASE 1
     * @heckmeck
     */
     
    public class Main extends Sprite {
        private var imgW_:uint;
        private var imgH_:uint;
        private const INTERVAL_X:Number = 4.0;
        private const INTERVAL_Y:Number = 4.0;
        private const SH:uint   = stage.stageHeight;
        private const CX:Number = stage.stageWidth / 2;
        private var mX_:Number;
        private var mY_:Number;
        private var rgb_:ColorRGB;
        private var bmdVector_:Vector.<uint>;
        private var grayVector_:Vector.<uint>;
        private var canvas_:Shape;
        private const DIST_RATIO:uint  = 20;
        private const THICK_RATIO:uint = 0x24;
        private var offsetX_:Number;
        private var offsetY_:Number;

        public function Main() {
            var url:String = "http://assets.wonderfl.net/images/related_images/0/0d/0d28/0d2809088a12918d35bb22df299af02f4ecbe586";
            var loader:Loader = new Loader();
            loader.load(new URLRequest(url), new LoaderContext(true));
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, completeHandler);
        }

        private function completeHandler(event:Event):void {
            init(Bitmap(event.target.loader.content));
            addEventListener(Event.ENTER_FRAME, update);
        }
        
        private function init(bm:Bitmap):void{
            rgb_ = new ColorRGB();
            
            var bmd:BitmapData = bm.bitmapData;
            imgW_ = bmd.width;
            imgH_ = bmd.height;
            offsetX_ = (stage.stageWidth  - imgW_ * INTERVAL_X) / 2;
            offsetY_ = (stage.stageHeight - imgH_ * INTERVAL_Y) / 2;
            
            bmdVector_ = bmd.getVector(bmd.rect);
            bmdVector_.fixed = true;

            var len:uint = bmdVector_.length;
            grayVector_ = new Vector.<uint>();
            for (var i:int = 0; i < len; i++) {
                rgb_.value32 = bmdVector_[i];
                bmdVector_[i] = rgb_.value;
                grayVector_.push(Math.round(rgb_.r * 0.222 + rgb_.g * 0.707 + rgb_.b * 0.071));
            }
            grayVector_.fixed = true;
            

            addChild(bm);

            canvas_ = new Shape();
            //canvas moved right
            canvas_.x = 90;
            addChild(canvas_);
        }
        
        private function update(e:Event):void {
            mX_ = (mouseX - CX) / CX;
            mY_ = mouseY / SH;
            
            var g:Graphics = canvas_.graphics;
            g.clear();
            
            var len:uint = bmdVector_.length;
            for (var i:int = 0; i < len; i++) {
                var c1:uint    = bmdVector_[i];
                var gray1:uint = grayVector_[i];
                    
                var i2:uint = i + 1;
                var amari:uint = i2 % imgW_;
                if (amari == 0) {i2 -= 1;}
                var c2:uint    = bmdVector_[i2];
                var gray2:uint = grayVector_[i2];

                var thickness:Number = (0xFF - gray1) / THICK_RATIO * mY_;

                var d:Number = DIST_RATIO * mX_;
                var d1:Number = d * c1 / 0xFFFFFF;
                var d2:Number = d * c2 / 0xFFFFFF;
                
                var posX:Number = INTERVAL_X * (i % imgW_);
                var posY:Number = INTERVAL_Y * ((i / imgW_) >> 0);
                
                //changed this to the example from case1 at P_4_3_1_01.pde
                g.lineStyle(thickness, c1);
                g.moveTo(posX, posY)
                g.lineTo(posX + 5, posY + 5);
            }
        }
    }
}