/**
 * Copyright talte ( http://wonderfl.net/user/talte )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/x6DQ
 */

package
{
	import flash.display.Sprite
	import flash.events.Event

	// メイン
	public class Main extends Sprite
	{
		function Main()
		{
			// 毎フレーム呼び出し
			this.addEventListener(Event.ENTER_FRAME, this.onEnterFrame)
		}
		
		// 毎フレームの処理
		private function onEnterFrame(event:Event):void
		{
			if(Math.random() > 0.96) // ランダムで出現
			{
				// ブロック作成
				var block:Block = new Block
				
				// スピードが早いほど重なりを手前に
				var i:int
				for (i = 0; i < this.numChildren; i++)
				{
					if(Block(this.getChildAt(i)).speed < block.speed)
					{
						break
					}
				}
				this.addChildAt(block, i) // 表示に加える
				
				// 画面外に出たときに呼び出される
				block.addEventListener(BlockEvent.STAGE_OUT, this.onBlockStageOut)
			}
		}
		
		// ブロックが画面外に出た
		private function onBlockStageOut(event:BlockEvent):void
		{
			this.removeChild(event.block) // 表示からはずす
		}
	}
}

import flash.display.Sprite
import flash.display.Graphics
import flash.events.Event

// ブロック
class Block extends Sprite
{
	public var speed:Number // 動くスピード
	
	function Block()
	{
		this.addEventListener(Event.ADDED_TO_STAGE, this.onLoad) // 初期化
	}
	
	// 初期化
	private function onLoad(event:Event):void
	{
		// 色をランダムに（薄めで背景より濃く）
		var color:uint = 0xbbbbbb + uint(Math.random() * 0x1b << 16) + uint(Math.random() * 0x1b << 8) + uint(Math.random() * 0x1b)
		
		// 大きさとスピード
		var height:int = (Math.random() * 0.2 + 0.08) * stage.stageWidth // 画面幅を参考に高さをランダムで
		var width:int = (Math.random() * 0.24 + 0.1) * height // さらに高さを参考に幅をランダムで
		this.speed = (Math.random() * 0.13 + 0.03) * width // さらに幅を参考にスピードをランダムで
		this.x = -width // 左の画面外
		this.y = stage.stageHeight - height // 下に着地
		
		// 描画
		var g:Graphics = this.graphics
		g.beginFill(color)
		g.drawRect(0, 0, width, height)
		g.endFill()
		
		// 毎フレーム呼び出し
		this.addEventListener(Event.ENTER_FRAME, this.onEnterFrame)
	}
	
	// 毎フレームの処理
	private function onEnterFrame(event:Event):void
	{
		this.x += this.speed // 移動
		if(this.x > stage.stageWidth) // 画面外
		{
			this.dispatchEvent(new BlockEvent(BlockEvent.STAGE_OUT, this)) // 画面外に出たことを登録元に知らせる
			this.removeEventListener(Event.ENTER_FRAME, this.onEnterFrame) // 処理終了
		}
	}
}
	
// ブロック用イベント
class BlockEvent extends Event
{
	public static const STAGE_OUT:String = "stage_out" // 画面外に出たときのイベント
	
	public var _block:Block // 呼び出し元ブロック
	
	function BlockEvent(type:String, block:Block)
	{
		super(type)
		this._block = block
	}
	
	public function get block():Block
	{
		return this._block
	}
}
