/**
 * Copyright FTMSuperfly ( http://wonderfl.net/user/FTMSuperfly )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/x5qE
 */

package 
{
    import flash.display.Sprite;
    import flash.geom.Point;
    
    public class APC extends Sprite 
    {
         
        private var ControlPoints:Array = [];
        private var AttachPoints:Array = [];
        private var diameter:int = 100;
        private var Points:int = 10;
         
        public function APC() 
        {
            var xx:int = stage.stageWidth/2;
            var yy:int = stage.stageHeight / 2;
            var outerDiameter:Number = diameter / Math.cos(Math.PI / Points);
 
            for (var i:int = 0; i < Points; i++)
            {
                var Ap:Point = Point.polar(diameter, i * 2 * Math.PI / Points);
                var Cp:Point = Point.polar(outerDiameter, i * 2 * Math.PI / Points + (Math.PI / Points ));
                Ap.x += xx;
                Ap.y += yy;
                Cp.x += xx;
                Cp.y += yy;
                AttachPoints.push(Ap);
                ControlPoints.push(Cp);
            }
 
            drawStuff();
        }
 
        private function drawStuff():void
        {
            this.graphics.beginFill(0, 0.5);
            this.graphics.moveTo(AttachPoints[0].x, AttachPoints[0].y);
            for (var i:int = 0; i < Points-1; i++)
            {
                this.graphics.curveTo(ControlPoints[i].x, ControlPoints[i].y, AttachPoints[i+1].x, AttachPoints[i+1].y);
            }
            this.graphics.curveTo(ControlPoints[Points-1].x, ControlPoints[Points-1].y, AttachPoints[0].x, AttachPoints[0].y);
            this.graphics.endFill();
        }
        
        
        
        
    }
}