/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/x5XsB
 */

package  {
    import Box2D.Collision.b2AABB;
    import Box2D.Collision.Shapes.b2PolygonDef;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.*;
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.text.*;
    
    /**
     * 床の上に箱を落とすFlash
     */
    [SWF(width="465", height="465", frameRate="30", backgroundColor="0x000000")]
    public class Tsumiki extends Sprite {
        private var DRAW_SCALE:Number = 100;
        private var world:b2World;
        private var boxBegin:Point = new Point();
        private var rect:Sprite = new Sprite();
        private var txt:TextField = new TextField();
        private var s2:Sprite = new Sprite();
        
        public function Tsumiki():void {
            txt.text = DRAW_SCALE.toString();
            txt.x = 0;
            txt.textColor = 0xffffff;
            addChild(txt);
            addChild(s2);
            ////////////////////////////////////////
            // 物理エンジンのセットアップ
            
            // 外枠を定義する
            var worldAABB:b2AABB = new b2AABB();
            worldAABB.lowerBound.Set(-100, -100);
            worldAABB.upperBound.Set(100, 100);
            
            // 重力を下方向に10m/s^2とする
            var gravity:b2Vec2 = new b2Vec2(0, 10);
            
            // 外枠と重力を指定して、物理エンジン全体をセットアップする
            world = new b2World(worldAABB, gravity, true);
            
            ////////////////////////////////////////
            // 床の設置
            // 床は画面の下のほうに設置します
            
            // 床の位置を左から2.5m、上から3mとする
            var floorBodyDef:b2BodyDef = new b2BodyDef();
            floorBodyDef.position.Set(2.5, 3);
            
            // 床の形を、幅4m、厚さ20cmとする
            // 指定するのはその半分の値
            var floorShapeDef:b2PolygonDef = new b2PolygonDef();
            floorShapeDef.SetAsBox(2, 0.1);
            
            // 床を動かない物体として作る
            var floor:b2Body = world.CreateBody(floorBodyDef);
            floor.CreateShape(floorShapeDef);
            
            ////////////////////////////////////////
            // 描画設定
            
            var debugDraw:b2DebugDraw = new b2DebugDraw();
            debugDraw.m_sprite = s2;//this;
            debugDraw.m_drawScale = DRAW_SCALE; // 1mを100ピクセルにする
            debugDraw.m_fillAlpha = 0.3; // 不透明度
            debugDraw.m_lineThickness = 1; // 線の太さ
            debugDraw.m_drawFlags = b2DebugDraw.e_shapeBit;
            world.SetDebugDraw(debugDraw);
            
            // イベントハンドラを登録する
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);//矩形生成開始
            stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);//矩形生成
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            stage.addEventListener(MouseEvent.MOUSE_WHEEL,onWheel);//ズーム
            addChild(rect);
        }
        
        private function onWheel(e:MouseEvent):void{
            DRAW_SCALE *= 1+e.delta/100;
            if(DRAW_SCALE < 0)DRAW_SCALE = 1;
            var debugDraw:b2DebugDraw = new b2DebugDraw();
            //debugDraw.m_sprite = this;
            debugDraw.m_sprite = s2;
            debugDraw.m_drawScale = DRAW_SCALE; // 1mを100ピクセルにする
            debugDraw.m_fillAlpha = 0.3; // 不透明度
            debugDraw.m_lineThickness = DRAW_SCALE/100; // 線の太さ
            debugDraw.m_drawFlags = b2DebugDraw.e_shapeBit;
            world.SetDebugDraw(debugDraw);
            txt.text = DRAW_SCALE.toString();
            
            
        }

        
        private function mouseDownHandler(event:MouseEvent):void {
            // マウスが押された場所を記憶しておく
            boxBegin.x = event.stageX;
            boxBegin.y = event.stageY;
            stage.addEventListener(MouseEvent.MOUSE_MOVE,onMove);
            addChild(rect);
            
           
        }
        //矩形描画
        private function onMove(e:MouseEvent):void{
            rect.graphics.clear();
            rect.graphics.lineStyle(1,0xffffff,0.5);
            rect.graphics.beginFill(0xffffff,0.2);
            rect.graphics.drawRect(boxBegin.x,boxBegin.y,mouseX-boxBegin.x,mouseY-boxBegin.y);
            rect.graphics.endFill();
        }

        //オブジェクト生成
        private function mouseUpHandler(event:MouseEvent):void {
            rect.graphics.clear();
            removeChild(rect);
            
            stage.removeEventListener(MouseEvent.MOUSE_MOVE,onMove);
            // 箱の場所と大きさを計算する
            var x:Number = (((event.stageX + boxBegin.x ) / 2)-s2.x) / DRAW_SCALE ;
            var y:Number = (event.stageY + boxBegin.y) / 2 / DRAW_SCALE ; 
            var halfWidth:Number = Math.abs(event.stageX - boxBegin.x ) / 2 / DRAW_SCALE ;
            var halfHeight:Number = Math.abs(event.stageY - boxBegin.y) / 2 / DRAW_SCALE ;
            
            // 小さすぎる箱ができるのを防ぐ
            if (halfWidth < 0.05 || halfHeight < 0.05) {
                return;
            }
            
            // 箱の場所を設定する
            var bodyDef:b2BodyDef = new b2BodyDef();
            bodyDef.position.Set(x, y);
            
            // 箱の大きさなどを設定する
            var shapeDef:b2PolygonDef= new b2PolygonDef();
            shapeDef.SetAsBox(halfWidth, halfHeight);
            shapeDef.density = 1;     // 密度 [kg/m^2]
            shapeDef.restitution = 0;  // 反発係数、通常は0～1
            
            // 箱を動く物体として作る
            var body:b2Body = world.CreateBody(bodyDef);
            body.CreateShape(shapeDef);
            body.SetMassFromShapes();
        }
        
        private function enterFrameHandler(event:Event):void {
            // Flashはデフォルトで秒間24フレームなので、
            // 物理シミュレーションを1/24秒進める
            world.Step(1 / 24, 10);
        }
    }
}