/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/x4rz
 */

package {
  import flash.display.Shape;
  import flash.display.Sprite;
  import flash.events.Event;
  import flash.utils.getTimer;
  
  [SWF(backgroundColor="#000000", frameRate="45")]
  public class ch35ex7 extends Sprite {
    protected var r:Number; //radius
    protected var shape:Shape;
    
    public function ch35ex7() {
      shape = new Shape();
      shape.x = stage.stageWidth / 2;
      shape.y = stage.stageHeight / 2;
      addChild(shape);
      r = Math.min(stage.stageWidth, stage.stageHeight) * 0.3;
      addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    
    protected function onEnterFrame(event:Event):void {
      var w:Number = int(30 * ((stage.mouseX / stage.stageWidth) - 0.5));
      var r2:Number = 2 * ((stage.mouseY / stage.stageHeight) - 0.5)
      r2 = r * 3 * Math.pow(r2, 3);
      shape.graphics.clear();
      shape.graphics.beginFill(0xff00cc);
      for (var t:Number = 0; t < Math.PI * 2; t += 0.03) {
        var x:Number = r * Math.cos(t) + r2 * Math.cos(t * w);
        var y:Number = r * Math.sin(t) + r2 * Math.sin(t * w);
        if (t == 0) shape.graphics.moveTo(x, y);
        shape.graphics.lineTo(x, y);
      }
      shape.graphics.endFill();
    }
  }
}