/**
 * Copyright aote ( http://wonderfl.net/user/aote )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/x4D3
 */

// forked from paq's [Stardust] BitmapBurster
package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.net.URLRequest;
	import net.wonderfl.utils.SequentialLoader;
	import idv.cjcat.stardust.common.clocks.ImpulseClock;
	import idv.cjcat.stardust.common.emitters.Emitter;
	import idv.cjcat.stardust.common.math.UniformRandom;
	import idv.cjcat.stardust.twoD.bursters.BitmapBurster;
	import idv.cjcat.stardust.twoD.renderers.DisplayObjectRenderer;
	
	/**
	 * 画像は飼い猫
	 * @author paq89
	 */
	[SWF(width = 465, height = 465, backgroundColor = 0xFFFFFF, frameRate = 60)]
	public class Main extends Sprite 
	{
		private var _emitter:ExplosionEmitter;
		private var _burster:BitmapBurster;
		private var _loader:Loader;
		private var _container:Sprite;
		private var _imgs:Array=[];
		
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			graphics.beginFill(0x000000); graphics.drawRect(0, 0, 465, 465);
			
			_container = new Sprite();
			addChild(_container);
                        SequentialLoader.loadImages(["http://assets.wonderfl.net/images/related_images/7/7f/7f95/7f955aa0784491ba885a72efaa6d684bd968ebf9"], _imgs, loaded);
		}
		
		private function loaded():void 
		{
 			_loader = _imgs.pop();
			var bmpd:BitmapData = new BitmapData(_loader.width, _loader.height);
			bmpd.draw(_loader)
			
			_emitter = new ExplosionEmitter(new ImpulseClock());
			var renderer:DisplayObjectRenderer = new DisplayObjectRenderer(_container);
			renderer.addEmitter(_emitter);
			
			_burster = new BitmapBurster(10,10,232.5-bmpd.rect.width*0.5,232.5-bmpd.rect.height*0.5);
			_burster.bitmapData = bmpd;
			_burster.burst(_emitter);
			_emitter.snapshot.takeSnapshot();
			
			addEventListener(Event.ENTER_FRAME, loop);
			stage.addEventListener(MouseEvent.CLICK, restore);
		}
		
		private function restore(e:MouseEvent):void 
		{
			_emitter.snapshotRestore.start();
		}
		
		private function loop(e:Event):void 
		{
			_emitter.step();
			_emitter.explode.x = mouseX;
			_emitter.explode.y = mouseY;
			_emitter.explode.explode();
		}
		
	}
	
}
import idv.cjcat.stardust.common.clocks.Clock;
import idv.cjcat.stardust.common.easing.Sine;
import idv.cjcat.stardust.common.initializers.CollisionRadius;
import idv.cjcat.stardust.common.math.UniformRandom;
import idv.cjcat.stardust.twoD.actions.Accelerate;
import idv.cjcat.stardust.twoD.actions.Collide;
import idv.cjcat.stardust.twoD.actions.Damping;
import idv.cjcat.stardust.twoD.actions.Deflect;
import idv.cjcat.stardust.twoD.actions.Explode;
import idv.cjcat.stardust.twoD.actions.Move;
import idv.cjcat.stardust.twoD.actions.Oriented;
import idv.cjcat.stardust.twoD.actions.Snapshot;
import idv.cjcat.stardust.twoD.actions.SnapshotRestore;
import idv.cjcat.stardust.twoD.actions.SnapshotRestoreFlag;
import idv.cjcat.stardust.twoD.deflectors.BoundingBox;
import idv.cjcat.stardust.twoD.emitters.Emitter2D;

class ExplosionEmitter extends Emitter2D
{
	public var explode:Explode;
	public var snapshot:Snapshot;
	public var snapshotRestore:SnapshotRestore;
	
	public function ExplosionEmitter(clock:Clock)
	{
		super(clock);
		
		var deflect:Deflect = new Deflect();
        deflect.addDeflector(new BoundingBox(0, 0, 465, 465));
		explode = new Explode(0, 0, 3, 40, 640);
		snapshot = new Snapshot();
		snapshotRestore = new SnapshotRestore(new UniformRandom(30, 10));
		snapshotRestore.flags = SnapshotRestoreFlag.POSITION | SnapshotRestoreFlag.ROTATION;
		snapshotRestore.curve = Sine.easeOut;
		addAction(explode);
		addAction(deflect);
		addAction(snapshot);
		addAction(snapshotRestore);
		addAction(new Move());
		addAction(new Damping(0.1));
	}
}