/**
 * Copyright bshh ( http://wonderfl.net/user/bshh )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/x3Bj
 */

package 
{
    import flash.geom.Point;
    import frocessing.display.*;
   
    /**
     * Frocessingのサンプル1
     * くねくね線とランダムな円
     * マウスクリックでリセット
     */
    public class FrocessingSample01 extends F5MovieClip2DBmp
    {
        //描画サイズ
        private var m_stage_width:Number  = 500;
        private var m_stage_height:Number = 500;
       
        //図形描画の座標
        private var m_points/*Point*/:Array;  //座標を入れる
       
        private var m_point_current_index:int = 0;  //何番目の座標まで描画するか
           
        public function FrocessingSample01(){
            super();
        }
       
        //初期化 Stage が呼び込まれたときに自動的に呼ばれる
        public function setup():void {
           
            //描画範囲指定
            size( m_stage_width, m_stage_height );
           
            //背景色指定（引数の数によって色の指定方法が変わる）
            background(0, 1);  // color, alpha
           
            //座標セット
            setPoints();
        }
       
       
        //図形描画の座標をセット
        private function setPoints():void {
           
            m_points = new Array();
   
            var len:int = m_stage_width - random(m_stage_height / 2);
            var point_num:int = len / 10;
           
            var step:int = len / point_num + random(5, 1);
            var start_x:Number = Math.random() * m_stage_width; //ｙ軸スタート位置はランダム
           
            var yure:Number = random(6, 2);  //くねくねサイズ
           
            var pt:Point;
           
            for (var i:int = 0; i <point_num ; i++) {
                pt = new Point(start_x + random(yure, -yure), -step * i );
                m_points.push(pt);
            }
           
            //始点と終点は同じ値を2つ入れる（始点と終点はコントロールポイントになってるっぽいので）
            pt = m_points[0].clone();
            m_points.unshift(pt);
           
            pt = m_points[m_points.length - 1].clone();
            m_points.push(pt);
        }
       
       
        //描画（フレーム毎に繰り返し）
        public function draw():void {
           
            //マウスが押された場合
            if ( isMousePressed ) {
                //背景を塗りなおす（描画のリセット）
                background(0, 1);
            }
           
            //原点の移動
            translate( 0, m_stage_height);
           
            //-----くねくね線-----
           
            //塗りをなしに
            noFill();
           
            //線色の指定（引数の数によって色の指定方法が変わる）
            stroke(255, 255, 255, 0.5);  //R, G, B, alpha
           
            //線幅指定
            strokeWeight(0.1);
           
            var pt:Point;
           
            //頂点を複数持つ図形の描画
            beginShape();
            for (var i:int = 0; i <m_point_current_index ; i++) {
                pt = m_points[i];
                curveVertex(pt.x, pt.y);
            }
            endShape();
           
           
            //-----ランダムな円-----
           
            //線をなしに
            //noStroke();
           
            strokeWeight(1);
           
            //塗り設定
            fill(255, 255, 255, 0.5);
           
            if(m_point_current_index> 0){
                pt = m_points[m_point_current_index - 1];
            }
            else {
                pt = m_points[0];
            }
            //円の描画
            var maru_size:Number = random(15, 1);
            ellipse(pt.x + random(15, -15), pt.y + random(10, -10), maru_size, maru_size);
           
            //描画する座標進める
            m_point_current_index++;
           
            //最後の座標まで行ったら座標再設定
            if (m_point_current_index> m_points.length) {
                m_point_current_index = 0;
                setPoints();
            }
        }
    }
}