/**
 * Copyright yuuganisakase ( http://wonderfl.net/user/yuuganisakase )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/x357
 */

package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.filters.GlowFilter;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.net.URLRequest;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flash.utils.Timer;
	import frocessing.math.PerlinNoise;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.Quadratic;
	import org.libspark.betweenas3.tweens.ITween;
         import net.wonderfl.widget.Wanco;
         import flash.system.LoaderContext;
	[SWF(width=465, height=465, frameRate=30, backgroundColor=0x222222)]
	public class MessageWindow extends Sprite 
	{
		
		// from Alice in wonderland      特に意味なし
		private const script:Array = ["Have some wine.",
								"I don't see any wine.",
								"There isn't any.",
								"Then it wasn't very civil of you to offer it.",
								"It wasn't very civil of you \n to sit down without being invited.",
								"I didn't know it was YOUR table, \n it's laid for a great many \n more than three.",
								"Your hair wants cutting.",
								"You should learn not to make personal remarks, \n it's very rude.",
								"Why is a raven like a writing-desk?",
								"Come, we shall have some fun now! \n I'm glad they've begun asking riddles \n--I believe I can guess that."
								];
		
		private const StageWid:int = 465;
		private const StageHei:int = 465;

		private var window:Sprite;
		private var loader:Loader;
		private var paperBitmapData:BitmapData;
		
		private var unko:Wanco = new Wanco();
		private var text:TextField;
		private var format:TextFormat;
		private var back:Bitmap;
		
		private var clickCount:int= 0;
		private var message:String;
		private var timer:Timer;

		public function MessageWindow():void 
		{
			loader = new Loader();
			loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/e/ee/ee89/ee89c4a10bf3853b48d8a9c30908c7d9622f44c9"), new LoaderContext( true ) );
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, init);
		}
		
		private function init(e:Event = null):void 
		{
			loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, init);
			paperBitmapData = (loader.content as Bitmap).bitmapData;
			
			timer = new Timer(16);
			timer.addEventListener(TimerEvent.TIMER, onTimer);
			
			window = new Sprite();
			back = new Bitmap();
			
			text = new TextField();
			text.alpha = 0.8;
			text.autoSize = TextFieldAutoSize.LEFT;
			text.selectable = false;
			format = new TextFormat();
			format.color = 0x332211;
			format.size = 16;
			text.defaultTextFormat = format;
			window.addChild(back);
			window.addChild(text);
			addChild(window);
			
			makeUnko();
			
			step();

			stage.addEventListener(MouseEvent.CLICK, onClick);
		}
		
		private function makeUnko():void
		{
			//unko.graphics.beginFill(0xffffff,0.5);
			//unko.graphics.drawCircle(0, 0, 30);
			addChildAt(unko,0);
		}
		
		private function createWindow(xx:int, yy:int, wid:int, hei:int):void
		{
			var UpArrow:Boolean = false;
			const padding:int = 40;
			const W:int = wid + padding;
			const H:int = hei + padding;
			
			window.x = xx - W/2 - 50;// Math.random() * 150 + 30;
			window.y = yy-hei-90;// Math.random() * 400 + 30;
			if (window.x + wid +padding > StageWid) window.x -= ((window.x + wid + padding) - StageWid);
			if (window.x < 30) window.x = 30;
			if (window.y + hei +padding > StageHei) window.y -= ((window.y + hei + padding) - StageHei);
			if (window.y < 30) {
				window.y = yy + 60;
				UpArrow = true;
			}
						
			var sh:Shape= new Shape();
			
			var arrowOrigin:Point;
			if (UpArrow) {
				arrowOrigin = new Point(W / 2, 0);
			}else {
				arrowOrigin = new Point(W / 2, H);
			}
			
			var unkoPoint:Point = new Point(unko.x - window.x, unko.y - window.y);
			var length:Number = Point.distance(arrowOrigin, unkoPoint);
			
			// shorten arrow length
			if (length > 90) {
				if (unkoPoint.x > arrowOrigin.x) arrowOrigin.x = unkoPoint.x - 50;
				else arrowOrigin.x = unkoPoint.x +50;
			}
			
			const arrowSize:int = 11;
			if (UpArrow == false) {
				drawPerlinLine(sh, 0, 0, W,0);
				drawPerlinLine(sh, W, 0, W, H);
				drawPerlinLine(sh, W, H, arrowOrigin.x + arrowSize, H);
				drawPerlinLine(sh, arrowOrigin.x + arrowSize, H, unko.x - window.x, unko.y - window.y,20,1,0.4);
				drawPerlinLine(sh, unko.x - window.x, unko.y - window.y, arrowOrigin.x - arrowSize, H,20,1,0.4);
				drawPerlinLine(sh, arrowOrigin.x-arrowSize,H,0,H);
				drawPerlinLine(sh, 0, H, 0, 0);
			}else {
				drawPerlinLine(sh, 0, 0, arrowOrigin.x - arrowSize,0);
				drawPerlinLine(sh, arrowOrigin.x - arrowSize, 0, unko.x - window.x, unko.y - window.y,20,1,0.4);
				drawPerlinLine(sh, unko.x - window.x, unko.y - window.y, arrowOrigin.x + arrowSize,0,20,1,0.4);
				drawPerlinLine(sh, arrowOrigin.x + arrowSize,0,W, 0);
				drawPerlinLine(sh, W,0,W,H);
				drawPerlinLine(sh, W, H, 0, H);
				drawPerlinLine(sh, 0, H, 0, 0);
			}
			
			var data:BitmapData = new BitmapData(StageWid+50, StageHei, true, 0x00000000);
			const mm:int = 90
			data.draw(sh, new Matrix(1,0,0,1,mm,mm));
			data.floodFill(W/2+mm, H/2+mm,0xffff0000);
			data.copyPixels(paperBitmapData,new Rectangle(Math.random()*(paperBitmapData.width-StageWid),Math.random()*(paperBitmapData.height-StageHei),data.width,data.height), new Point(), data, new Point());
			data.applyFilter(data, data.rect, new Point(), new GlowFilter(0x221100, 0.8, 16, 16, 2, 8, true));
			
			back.bitmapData = data;
			back.x = back.y = -mm - padding/2;
		}
		
		private function createTexts(s:String):void
		{
			text.defaultTextFormat = format;
			text.htmlText = s;   // temporary assign full string to measure window size. 
		}
		
		private function onTimer(e:Event):void
		{
			if (timer.currentCount > message.length) {
				
			}else {
				text.htmlText = message.slice(0, timer.currentCount);	
			}
		}
		
		private function drawPerlinLine(shape:Shape, x0:Number, y0:Number, x1:Number, y1:Number, stepSize:int = 50, recursiveCount:int = 1,scale:Number = 0.5):void
		{
			shape.graphics.lineStyle(0.3, 0xff0000,0.1);
			shape.graphics.moveTo(x0,y0);
			
			var p1:Point = new Point(x0, y0);
			var p2:Point = new Point(x1, y1);
			
			var length:Number = Point.distance(p1, p2);
			var angle:Number = Math.atan2(y1 - y0, x1 - x0);
			var num:int = Math.ceil( length / stepSize);	
			var xStepSize:Number = (x1 - x0) / num;
			var yStepSize:Number = (y1 - y0) / num;
			
			var smallPerlin:PerlinNoise = new PerlinNoise();
			smallPerlin.noiseSeed(Math.random() * 10);
			
			var prevPoint:Point = new Point(x0, y0);
			var nextPoint:Point = new Point();
			for (var i:int = 1; i < num+1; i++) 
			{	
				nextPoint.x = x0 + xStepSize * i;
				nextPoint.y = y0 + yStepSize * i;
				var noise:Number = smallPerlin.noise(i);
				nextPoint.x += Math.cos(angle + Math.PI / 2) * (noise - 0.5) * stepSize * scale;
				nextPoint.y += Math.sin(angle + Math.PI / 2) * (noise - 0.5) * stepSize * scale;
				if (i == num) nextPoint = p2.clone();
				
				if (recursiveCount > 0) {
					drawPerlinLine(shape, prevPoint.x, prevPoint.y, nextPoint.x, nextPoint.y, stepSize/(Math.floor(Math.random()*8)+3),recursiveCount-1,scale*2);
				}
				else {
					shape.graphics.lineTo(nextPoint.x, nextPoint.y);
				}
				prevPoint = nextPoint.clone();
			}
		}
		
		private function onClick(e:MouseEvent):void 
		{
			clickCount += 1;
			if (clickCount >= script.length) clickCount = 0;
			step();
		}
		
		private function step():void
		{
			changeUnko();
			message = script[clickCount];
			createTexts(message);
			createWindow(unko.x, unko.y, text.width, text.height);
			text.htmlText = "";
			var t:ITween = BetweenAS3.tween(window, { }, { x:unko.x, y:unko.y, scaleX:0, scaleY:0.2, alpha:0.1 }, 0.2, Quadratic.easeOut);
			BetweenAS3.delay(t, 0.4).play();
			timer.reset();
			t.onComplete = function():void { timer.start(); };
		}
		
		private function changeUnko():void
		{
                            var mm:Number = 50;
			unko.x = Math.random() * (StageWid-mm)+mm;
			unko.y = Math.random() * (StageHei-mm)+mm;
                            if(unko.x < StageWid/2){
                             unko.scaleX = -1;
                            }
                            else {
                                unko.scaleX = 1;
                            }
		}
	}
}  
