/**
 * Copyright h_kamizono ( http://wonderfl.net/user/h_kamizono )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/x30S
 */

// forked from h_kamizono's test

// ref 
// Flash Math & Physics Design ActionScript 3.0による数学・物理学表現[実践編]

/*
Todo
立方体以外に挑戦してみるかも
*/
package {
    import flash.display.Bitmap;
    import flash.filters.GradientGlowFilter;
    import flash.utils.Proxy;
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.geom.Point;
    import flash.filters.BitmapFilterQuality;
    import flash.filters.BitmapFilterType;
    import flash.events.StatusEvent;
    import flash.system.Security;
    import flash.system.SecurityPanel;
    public class Expansion  extends MovieClip {
        private var base:Sprite = new Sprite();
        private var oriPt:Array = new Array();
        private var open:PhysicalPoint = new PhysicalPoint();
        
        private var startTime:uint = new Date().getTime();
        
        public function Expansion () {
            // write as3 code here..
            var gradientGlow:GradientGlowFilter = new GradientGlowFilter();
            gradientGlow.distance = 0;
            gradientGlow.angle = 0;
            gradientGlow.colors = [0x9999FF, 0x9999FF];
            gradientGlow.alphas = [0, 1];
            gradientGlow.ratios = [0, 255];
            gradientGlow.blurX = 20;
            gradientGlow.blurY = 20;
            gradientGlow.strength = 3;
            gradientGlow.quality = BitmapFilterQuality.HIGH;
            gradientGlow.type = BitmapFilterType.OUTER;
            
            base.filters = [gradientGlow];
            base.x = stage.stageWidth/2;
            base.y = stage.stageHeight/2;
            addChild(base);
            
            var size:Number = 100;
            oriPt = [    [new Point3D(-size, size, -size),new Point3D(-size, size, size),new Point3D(size, size, size),new Point3D(size, size, -size)], 
                [new Point3D(-size, size, -size),new Point3D(-size, -size, -size),new Point3D(size, -size, -size),new Point3D(size, size, -size)], 
                [new Point3D(-size, size, -size),new Point3D(-size, -size, -size),new Point3D(-size, -size, size),new Point3D(-size, size, size)], 
                [new Point3D(-size, size, size),new Point3D(-size, -size, size),new Point3D(size, -size, size),new Point3D(size, size, size)], 
                [new Point3D(size, size, size),new Point3D(size, -size, size),new Point3D(size, -size, -size),new Point3D(size, size, -size)], 
                [new Point3D(-size, -size, -size),new Point3D(-size, -size, size),new Point3D(size, -size, size),new Point3D(size, -size, -size)]
            ];
            var timer:Timer = new Timer(33);
            timer.addEventListener(TimerEvent.TIMER, loop);
            timer.start();
        }
               
        private function loop(event:TimerEvent) :void {
            var par:Number = (Math.random()*1000)%91;
            par = 10;
            if (par > open.angle) {
                open.setKakuKasokudo((par - open.angle) * 300);
            } else {
                open.setKakuKasokudo((par - open.angle) * 10);
            }
            var pt:Array = duplicate();
            
            pt[1][1].rotateX(open.angle, pt[1][0].x, pt[1][0].y, pt[1][0].z);
            pt[1][2].rotateX(open.angle, pt[1][0].x, pt[1][0].y, pt[1][0].z);
            
            pt[2][1].rotateZ(-open.angle, pt[2][0].x, pt[2][0].y, pt[2][0].z);
            pt[2][2].rotateZ(-open.angle, pt[2][0].x, pt[2][0].y, pt[2][0].z);
            
            pt[3][1].rotateX(-open.angle, pt[3][0].x, pt[3][0].y, pt[3][0].z);
            pt[3][2].rotateX(-open.angle, pt[3][0].x, pt[3][0].y, pt[3][0].z);
            
            pt[4][1].rotateZ(open.angle, pt[4][0].x, pt[4][0].y, pt[4][0].z);
            pt[4][2].rotateZ(open.angle, pt[4][0].x, pt[4][0].y, pt[4][0].z);
            
            
            pt[5][0].shift(0, pt[1][1].y - oriPt[5][0].y, pt[1][1].z - oriPt[5][0].z);
            pt[5][1].shift(0, pt[1][1].y - oriPt[5][0].y, pt[1][1].z - oriPt[5][0].z);
            pt[5][2].shift(0, pt[1][1].y - oriPt[5][0].y, pt[1][1].z - oriPt[5][0].z);
            pt[5][3].shift(0, pt[1][1].y - oriPt[5][0].y, pt[1][1].z - oriPt[5][0].z);
            
            pt[5][1].rotateX(open.angle*2, pt[5][0].x, pt[5][0].y, pt[5][0].z);
            pt[5][2].rotateX(open.angle*2, pt[5][0].x, pt[5][0].y, pt[5][0].z);
            
            var passedTime:Number = (new Date().getTime() - startTime)/1000*Math.PI*2*0.02;
            rotateX(pt, passedTime, 0, 0, 0);
            rotateY(pt, passedTime, 0, 0, 0);
            rotateZ(pt, passedTime, 0, 0, 0);
            shift(pt, 0, 0, 600);
            var pt2:Array = reflect(pt, 100, 5);
            render(pt2, base);
        }
        
        private function duplicate() :Array {
            var ret:Array = new Array();
            for (var i:Number = 0; i < oriPt.length; ++i) {
                ret.push(new Array());
                for (var j:Number = 0; j < oriPt[i].length; ++j) {
                    ret[ret.length - 1].push(new Point3D(
                        oriPt[i][j].x, oriPt[i][j].y, oriPt[i][j].z));
                }
            }
            return ret;
        }
        
        private function rotateX(pt:Array, val:Number, cx:Number, cy:Number, cz:Number) :void {
            for (var i:Number = 0 ; i < pt.length; ++i) {
                if (pt[i] is Array) {
                    for (var j:Number = 0; j < pt[i].length; ++j) {
                        if (pt[i][j] is Point3D) {
                            pt[i][j].rotateX(val, cx, cy, cz);
                        }
                    }
                }
            }
        }
        
        private function rotateY(pt:Array, val:Number, cx:Number, cy:Number, cz:Number) :void {
            for (var i:Number = 0 ; i < pt.length; ++i) {
                if (pt[i] is Array) {
                    for (var j:Number = 0; j < pt[i].length; ++j) {
                        if (pt[i][j] is Point3D) {
                            pt[i][j].rotateY(val, cx, cy, cz);
                        }
                    }
                }
            }
        }
        
        private function rotateZ(pt:Array, val:Number, cx:Number, cy:Number, cz:Number) :void {
            for (var i:Number = 0 ; i < pt.length; ++i) {
                if (pt[i] is Array) {
                    for (var j:Number = 0; j < pt[i].length; ++j) {
                        if (pt[i][j] is Point3D) {
                            pt[i][j].rotateZ(val, cx, cy, cz);
                        }
                    }
                }
            }
        }
        
        private function shift(pt:Array, dx:Number, dy:Number, dz:Number) :void {
            for (var i:Number = 0; i < pt.length; ++i) {
                if (pt[i] is Array) {
                    for (var j:Number = 0; j < pt[i].length; ++j) {
                        if (pt[i][j] is Point3D) {
                            pt[i][j].shift(dx, dy, dz);
                        }
                    }
                }
            }
        }
        
        private function reflect(pt:Array, sc:Number, bai:Number = 1) :Array {
            var ret:Array = new Array();
            for (var i:Number = 0; i < pt.length; ++i) {
                if (pt[i] is Array) {
                    ret.push(new Array());
                    for (var j:Number = 0; j < pt[i].length; ++j) {
                        if (pt[i][j] is Point3D) {
                            var retX:Number = pt[i][j].x * sc / pt[i][j].z;
                            var retY:Number = pt[i][j].y * sc / pt[i][j].z;
                            ret[ret.length - 1].push(new Point(retX*bai, retY*bai));   
                        }
                    }
                }
            }
            return ret;
        }
        
        private function render(pt:Array, sp:Sprite) :void {
            sp.graphics.clear();
            for (var i:Number = 0; i < pt.length; ++i) {
                if (pt[i] is Array) {
                    for (var j:Number = 0 ; j < pt[i].length; ++j) {
                        if (pt[i][j] is Point) {
                            if (j == 0) {
                                sp.graphics.lineStyle(5, 0x000000, Math.random()*0.6 +0.4);
                                sp.graphics.moveTo(pt[i][j].x, pt[i][j].y);
                            } else {
                                sp.graphics.lineTo(pt[i][j].x, pt[i][j].y);
                            }
                            if (j == 3) {
                                sp.graphics.lineTo(pt[i][0].x, pt[i][0].y);
                            }
                        }
                    }
                }

            }

        }


    }
}

import flash.geom.Point;
import flash.events.TimerEvent;
import flash.utils.Timer;
class PhysicalPoint extends Point {
    private var vx:Number, vy:Number;
    private var ax:Number, ay:Number;
    private var b:Number;
    private var sakkiTime:Number;
    private var timer:Timer;
    
    private var preX:Number, preY:Number;
    
    private var kb:Number;
    public var angle:Number;
    private var preAngle:Number;
    private var kakusokudo:Number;
    private var kakukasokudo:Number;
    
    private var limitter:Number = 0.3;
    
    function PhysicalPoint(xx: Number = 0, yy:Number = 0, an:Number = 0) {
        x = xx; y = yy;
        preX = xx; preY = yy;
        b = 1;
        vx = 0; vy = 0;
        ax = 0; ay = 0;
        
        angle = an;
        preAngle = an;
        kb = 1;
        kakusokudo = 0;
        kakukasokudo = 0;
        
        sakkiTime = new Date().getTime();
        timer = new Timer(33);
        timer.addEventListener(TimerEvent.TIMER, loop);
        timer.start();
        
    }
    
    public function loop(event:TimerEvent) :void {
        var nowTime:Number = new Date().getTime();
        var t:Number = (nowTime - sakkiTime)/1000;
        
        if (t > limitter) t = limitter;
        
        preX = x;
        preY = y;
        
        x += vx*t + 0.5*ax*t*t;
        y += vy*t + 0.5*ay*t*t;
        
        vx += ax*t; vy += ay*t;
        vx *= b;    vy *= b;
        ax = 0;     ay = 0;
        preAngle = angle;
        angle += kakusokudo * t + 0.5*kakukasokudo*t*t;
        kakusokudo += kakusokudo*t;
        
        kakusokudo *= kb;
        kakukasokudo = 0;
        sakkiTime = nowTime;
    }
    
    public function setKasokudo(aax:Number = 0, aay:Number = 0) :void {
        ax += aax;
        ay += aay;
    }
    
    public function setKasokudoByPolar(r:Number=0, dire:Number = 0) :void {
        ax += r*Math.cos(dire);
        ay += r*Math.sin(dire);
    }
    
    public function setKakuKasokudo(aan:Number = 0) :void {
        kakukasokudo += aan;
    }
    
    public function setKakuKasokudo2(dire:Number, val:Number) :void {
        var aan:Number = val * Math.sin(dire - angle);
        setKakuKasokudo(aan);
    }
}

class Point3D {
    public var x:Number = 0;
    public var y:Number = 0;
    public var z:Number = 0;
    
    function Point3D(xx:Number = 0, yy:Number = 0, zz:Number = 0) {
        x = xx; y = yy; z = zz;
    }
    
    public function shift(valX:Number, valY:Number, valZ:Number) :void {
        x+= valX; y += valY; z += valZ;
    }
    
    public function rotateX(val:Number, cx:Number, cy:Number, cz:Number) :void {
        //var tempX1:Number = x - cx;
        var tempY1:Number = y - cy;
        var tempZ1:Number = z - cz;
        
        //var tempX2:Number = tempX1;
        var tempY2:Number = tempY1*Math.cos(val) - tempZ1*Math.sin(val);
        var tempZ2:Number = tempY1*Math.sin(val) + tempZ1*Math.cos(val);
        
        //x = tempX2 + cx; 
        y = tempY2 + cy; z = tempZ2 + cz;
    }
    
    public function rotateY(val:Number, cx:Number, cy:Number, cz:Number) :void {
        var tempX1:Number = x - cx;
        //var tempY1:Number = y - cy;
        var tempZ1:Number = z - cz;
        
        var tempX2:Number = tempX1*Math.cos(val) - tempZ1*Math.sin(val);
        //var tempY2:Number = tempY1*Math.cos(val) - tempZ1*Math.sin(val);
        var tempZ2:Number = tempX1*Math.sin(val) + tempZ1*Math.cos(val);
        
        x = tempX2 + cx; 
        //y = tempY2 + cy; 
        z = tempZ2 + cz;
    }
    
    public function rotateZ(val:Number, cx:Number, cy:Number, cz:Number) :void {
        var tempX1:Number = x - cx;
        var tempY1:Number = y - cy;
        //var tempZ1:Number = z - cz;
        
        var tempX2:Number = tempX1*Math.cos(val) - tempY1*Math.sin(val);
        var tempY2:Number = tempX1*Math.sin(val) - tempY1*Math.cos(val);
        //var tempZ2:Number = tempX1*Math.sin(val) + tempZ1*Math.cos(val);
        
        x = tempX2 + cx; 
        y = tempY2 + cy; 
        //z = tempZ2 + cz;
    }


}

