/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/x1lt
 */

package {
  import com.actionscriptbible.Example;
  
  import flash.display.Sprite;
  import flash.events.Event;
  import flash.geom.Rectangle;
  import flash.net.URLLoader;
  import flash.net.URLRequest;
  import flash.printing.PrintJob;
  import flash.text.TextField;
  import flash.text.TextFieldAutoSize;

  public class ch19ex2 extends Example {
    private var printableContent:Sprite;
    private var textField:TextField;
    private var loader:URLLoader;

    public function ch19ex2() {
      trace("Loading text...");
      loader = new URLLoader();
      loader.load(new URLRequest(
        "http://actionscriptbible.com/files/alice-ch1.txt"));
      loader.addEventListener(Event.COMPLETE, onLoadComplete);

      // Create a multiline text field that auto-sizes.
      textField = new TextField();
      textField.multiline = true;
      textField.wordWrap = true;
      textField.autoSize = TextFieldAutoSize.LEFT;
      
      // Create a sprite container for the text field,
      // and add the text field to it.
      printableContent = new Sprite();
      printableContent.addChild(textField);
    }
    
    private function onLoadComplete(event:Event):void {  
      trace("Done. Printing...");
      
      var printJob:PrintJob = new PrintJob();
      if (!printJob.start()) {
        trace("Printing cancelled!");
        return;
      }
      
      textField.height = printJob.pageHeight;
      textField.width = printJob.pageWidth;
      textField.text = loader.data;
      var pages:int = Math.ceil(textField.textHeight / printJob.pageHeight);
      
      // Loop through each page.
      for(var i:int = 0; i < pages; i++) {
        printJob.addPage(
          printableContent,
          new Rectangle(0, i * printJob.pageHeight,
          printJob.pageWidth, printJob.pageHeight)
        );
      }
  
      printJob.send();
      trace("Print job submitted!");
    }
  }
}