/**
 * Copyright _wonder ( http://wonderfl.net/user/_wonder )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/x14d
 */

// forked from _wonder's Tweener練習
package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import caurina.transitions.Tweener;
    
    public class TweenerTest extends Sprite {
        public function TweenerTest() {
            var ball:Sprite = new Sprite();
            ball.x = 100;
            ball.y = 100;
            
            ball.graphics.beginFill( 0x000000 );
            ball.graphics.drawCircle( 0, 0, 40 );
            ball.graphics.endFill();
            
            addChild( ball );
            
            ball.addEventListener(MouseEvent.CLICK, ballClickHandler);
            
            Tweener.addTween(ball, {
                x: 300,
                scaleX: 0.1,
                scaleY: 0.1,
                alpha: 0,
                time: 2,
                transition: "easeInOutSine",
                onComplete: tweenCompleteHandler,
                onCompleteParams: [ball]
            });
        }
        
        private function tweenCompleteHandler(ball:Sprite){
            Tweener.addTween(ball, {
                y: 300,
                scaleX: 2,
                scaleY: 2,
                alpha: 100,
                time: 1,
                transition: "easeInExpo"
            });
        }
        
        private function ballClickHandler(e:MouseEvent){
            Tweener.removeTweens(e.target);
        }
    }
}