/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/x0bI
 */

// forked from matacat's ff: Formative Particles
// forked from Saqoosha's Formative Particles
package
{
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.text.*;
    
    [SWF(backgroundColor = 0xFFFFFF, frameRate = 100, width = 465, height = 465)]
    
    public class FormativeParticles extends Sprite
    {
        private const SIZE:int = 350;
        private const W:int    = stage.stageWidth;
        private const H:int    = stage.stageHeight;
        
        private var _text:TextField   = new TextField();
        private var _force:BitmapData = new BitmapData(W, H, false, 0x000000);
        private var _temp:BitmapData  = _force.clone();
        private var _blur:BlurFilter  = new BlurFilter(128, 128, 3);
            private var _glow:GlowFilter = new GlowFilter(0xFFFFFFFF);
        private var _mtx:Matrix       = new Matrix();
        private var _p:ParticleField  = new ParticleField(_force);
        
        public function FormativeParticles()
        {
            stage.quality = StageQuality.LOW;
            
            _text.defaultTextFormat = new TextFormat('_sans', 50, 0xFFFFFF);
            _text.width  = W;
            _text.height = H;
            
            addChild(new Bitmap(_p));
            
            addEventListener(Event.ENTER_FRAME, _onEnterFrame);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, _onKeyDown);
        }
        
        private function _onEnterFrame(event:Event):void
        {
            _p.update();
        }
        
        private function _onKeyDown(event:KeyboardEvent):void
        {
            _text.text = String.fromCharCode(event.charCode);
            
            _force.fillRect(_force.rect, 0x000000);
            _force.draw(_text);
            
            var r:Rectangle = _force.getColorBoundsRect(0xFF, 0x00, false);
            _mtx.identity();
            _mtx.translate( -r.x, -r.y);
            
            var w:Number = r.width;
            var h:Number = r.height;
            var a:Number = SIZE / (w > h ? w : h);
            _mtx.scale(a, a);
            _mtx.translate((W - w * a) / 2, (H - h * a) / 2);
            
            _temp.fillRect(_temp.rect, 0x000000);
            _temp.draw(_text, _mtx);
            
            _force.applyFilter(_temp, _temp.rect, _force.rect.topLeft, _blur);
                _force.applyFilter(_temp, _temp.rect, _force.rect.topLeft, _glow);
            _force.draw(_text, _mtx);
            
            _p.changeDimm();
        }
    }
}


import flash.display.*;
import flash.filters.*;
import flash.geom.*;

class ParticleField extends BitmapData
{
    private static const QUANT:int    = 5000;
    private static const FORCE:Number = 2 / 0xFF;
    private static const THRES:Number = 2;
    private static const FRICT:Number = 0.25;
    
    private var _force:BitmapData;
    private var _temp:BitmapData;
    private var _head:Particle;
    private var _blur:BlurFilter     = new BlurFilter(16, 16, 1);
    private var _dimm:ColorTransform = new ColorTransform(0.9, 0.9, 0.9);
    private var _blink:Rectangle     = new Rectangle(0, 0, 3, 3);
    private var _count:int           = 0;
        private var _glow:GlowFilter = new GlowFilter(0xFFFFFF,1,6,6,3,3);

    
    public function ParticleField(forceMap:BitmapData)
    {
        super(forceMap.width, forceMap.height, false, 0x000000);
        
        _force = forceMap;
        _temp  = forceMap.clone();
        
        Particle.area = rect;
        var p:Particle = new Particle(null);
        for (var i:int = 1; i < QUANT; i++) p = new Particle(p);
        _head = p;
    }
    
    public function update():void
    {
        _temp.applyFilter(this, rect, _temp.rect.topLeft, _blur);
//        _temp.applyFilter(this, rect, _temp.rect.topLeft, _glow);
        
        var c1:uint, c2:uint, a:Number;
        var p:Particle = _head;
        do {
            c1 = _force.getPixel(p.x - 1, p.y) & 0xFF;
            c2 = _force.getPixel(p.x + 1, p.y) & 0xFF;
            
            a = (c2 - c1) * FORCE;
            if (p.vx > THRES || p.vx < -THRES) a -= p.vx * FRICT;
            
            p.x += p.vx += a * p.f;
            if (p.x < 0 || p.x >= width) p.x += p.vx *= -1;
            
            c1 = _force.getPixel(p.x, p.y - 1) & 0xFF;
            c2 = _force.getPixel(p.x, p.y + 1) & 0xFF;
            
            a = (c2 - c1) * FORCE;
            if (p.vy > THRES || p.vy < -THRES) a -= p.vy * FRICT;
            
            p.y += p.vy += a * p.f;
            if (p.y < 0 || p.y >= height) p.y += p.vy *= -1;
            
            if (_count == p.t) {
                _blink.x = (p.x >> 0) - 1;
                _blink.y = (p.y >> 0) - 1;
                _temp.fillRect(_blink, 0xFFFFFF);
            } else {
                _temp.setPixel(p.x >> 0, p.y >> 0, 0xCCCCCC);
            }
            
        } while (p = p.next);
        
        _temp.colorTransform(_temp.rect, _dimm);
        copyPixels(_temp, _temp.rect, rect.topLeft);
        
        _count = ++_count % 300;
    }
    
    public function changeDimm():void
    {
        _dimm.redMultiplier   = 0.85 + 0.1 * Math.random();
        _dimm.greenMultiplier = 0.85 + 0.1 * Math.random();
        _dimm.blueMultiplier  = 0.85 + 0.1 * Math.random();
    }
}


class Particle
{
    public static var area:Rectangle;
    
    public var x:Number;
    public var y:Number;
    public var vx:Number;
    public var vy:Number;
    public var f:Number;
    public var t:int;
    public var next:Particle;
    
    public function Particle(next:Particle)
    {
        x  = area.x + area.width * Math.random();
        y  = area.y + area.height * Math.random();
        vx = 1 - 2 * Math.random();
        vy = 1 - 2 * Math.random();
        f  = 0.8 + 0.4 * Math.random();
        t  = 300 * Math.random() >> 0;
        this.next = next;
    }
}
