/**
 * Copyright lagash ( http://wonderfl.net/user/lagash )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/x0QG
 */

//ステージクリックでパーティクルを置きます。MAX６０個。

//定番のブラー＋スクロールに一工夫して、見た目の変化をつけてみようというものです。


package {
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.display.Bitmap;
    import flash.display.Stage;
    import flash.display.BitmapData;
    import flash.display.DisplayObjectContainer;
    import flash.display.LineScaleMode;
    import flash.display.BlendMode;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.geom.Point;
    import flash.geom.ColorTransform;
    import flash.events.Event;
    import flash.utils.ByteArray;
    import flash.filters.BlurFilter;

    public class partest extends Sprite {
		var shape1:Shape;
		var shape2:Shape;
		var tmpBmd:BitmapData;
		var bmp:Bitmap;
		var emptymatrix: Matrix = new Matrix();
		
		
		var flg:Boolean;
		
		static public const _TABLE_SIZE:int = 0x10000;
		static public const _PI:Number = Math.PI;
		static public const _RADIANS:Number;// = _DEGREES * (_PI / 180);
		static public const _TWO_PI:Number = 2 * _PI;
		static public const _TWO_PI_SCALE:Number = _TABLE_SIZE / _TWO_PI;
		static public const _HALF_PI:Number = _PI / 2;
		static public const _table:Vector.<Number> = new function ():Vector.<Number>{
			var table:Vector.<Number> = new Vector.<Number>(_TABLE_SIZE, true);
			for (var i:uint = 0; i < _TABLE_SIZE; i++) {
				table[i] = Math.sin(i / _TWO_PI_SCALE);
			}
			return table;
		};
		static public var stageWidth;
		static public var stageHeight;
		static public var mouse_X;
		static public var mouse_Y;
		var centerX:uint;
		var centerY:uint;

		var count:uint=0;
		
		private var particles:Vector.<particle>=new Vector.<particle>();
		
                public function partest() {
			super();
			addEventListener(Event.ADDED_TO_STAGE, init);
		}

		private function init(e:Event) {
			stage.frameRate = 30;
			stageWidth = stage.stageWidth;
			stageHeight = stage.stageHeight;
			
			shape1 = new Shape();//主線描画用
			shape1.visible = false;
			shape2 = new Shape();//主線描画用
			shape2.visible = false;
			tmpBmd = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00000000);
			
			emptymatrix.identity();
			//emptymatrix.b = emptymatrix.c = 2;
			
			stage.addEventListener(MouseEvent.MOUSE_DOWN, function(e:MouseEvent) { flg = true; } );
			stage.addEventListener(MouseEvent.MOUSE_UP, function(e:MouseEvent) { flg = false; particles[particles.length - 1].cut = true; } );
			stage.addEventListener(Event.ENTER_FRAME, enterframeHandlr);
			
			bmp = new Bitmap(new BitmapData(stage.stageWidth, stage.stageHeight, true,0xff000000), "auto", true);//bitmap処理用
			addChild(bmp);
			addChild(shape1);
			addChild(shape2);
			
		}
		

		private function mouseclickHandlr(e) {
			flg = true;
			enterframeHandlr(e);
			flg = false; 
		}
		
		
		private function enterframeHandlr(e)
		{
			mouse_X = e.currentTarget.mouseX;
			mouse_Y = e.currentTarget.mouseY;
			var flg_2 = 0;
			bmp.bitmapData.lock();
			shape1.graphics.clear();
			shape2.graphics.clear();
			centerX = centerY = 0;

			for (var i = 0; i < particles.length; i++) {
				var tmpObj = particles[i];
				var velo=Math.abs(particles[i].tx) * Math.abs(particles[i].ty);
				if (velo > 6 && i!=0) { mouse_X = tmpObj.xx; mouse_Y = tmpObj.yy; flg_2 = 1; }
				
				//shape1.graphics.lineStyle(velo * 4, 0xeeeeee, velo, false);
				shape2.graphics.lineStyle(1, tmpObj.col, .1, false);
				
				if (i == 0 ) {
					//shape1.graphics.moveTo(tmpObj.obj.xx + tmpObj.obj._x * .5, tmpObj.obj.yy + tmpObj.obj._y * .5);
					shape2.graphics.moveTo(tmpObj.obj.xx + tmpObj.obj._x * .5+tmpObj.obj.tx*5, tmpObj.obj.yy + tmpObj.obj._y * .5+tmpObj.obj.ty*5);
				}
				//shape1.graphics.curveTo(tmpObj.xx + tmpObj._x, tmpObj.yy + tmpObj._y, tmpObj.xx + tmpObj._x * .5, tmpObj.yy + tmpObj._y * .5);
				shape2.graphics.curveTo(tmpObj.xx + tmpObj._x+tmpObj.tx*5, tmpObj.yy + tmpObj._y+tmpObj.ty*5, tmpObj.xx + tmpObj._x * .5+tmpObj.tx*5, tmpObj.yy + tmpObj._y * .5+tmpObj.ty*5);
				shape1.graphics.lineStyle(velo * 4, 0xeeeeee, .2, true);
				shape1.graphics.drawCircle(tmpObj.xx, tmpObj.yy, velo*5);

				tmpBmd.setPixel32(tmpObj.xx, tmpObj.yy, 0x88000000);// particles[i].col);
				
				centerX += tmpObj.xx;
				centerY += tmpObj.yy;
			}
			
                        //スクロール速度・方向は重心と中心の距離・方向で
			centerX /= particles.length;
			centerY /= particles.length;
			
			bmp.bitmapData.scroll((stageWidth / 2 - centerX) / 10, (stageHeight / 2 - centerY) / 10);
			tmpBmd.scroll( -(stageWidth / 2 - centerX) / 5, -(stageHeight / 2 - centerY) / 5);
			
			bmp.bitmapData.draw(shape1,emptymatrix, null, BlendMode.LIGHTEN);
			bmp.bitmapData.draw(shape2,emptymatrix, null, BlendMode.ADD);
			bmp.bitmapData.copyPixels(tmpBmd,new Rectangle(0,0,this.width,this.height),new Point(0,0),tmpBmd,new Point(0,0),true);// , emptymatrix, null, BlendMode.ADD);
			bmp.bitmapData.applyFilter(bmp.bitmapData,new Rectangle(0,0,this.width,this.height),new Point(0,0),new BlurFilter(2,2,1));
			bmp.bitmapData.draw(shape1,emptymatrix, null, BlendMode.OVERLAY);
			//tmpBmd.applyFilter(tmpBmd,new Rectangle(0,0,this.width,this.height),new Point(0,0),new BlurFilter(2,2,1));
			bmp.bitmapData.unlock();
			
                        if(count<30){
                            count++;
                            mouse_X=Math.random()*stage.stageWidth;
                            mouse_Y=stage.stageHeight/2;
                            flg=true;
                            if(count==30)flg=false;
                        }
			
			if (!flg && flg_2==0) return;
			if (particles.length > 0) {
				if (getLineLength(new Rectangle(particles[particles.length - 1].xx, particles[particles.length - 1].yy, mouse_X, mouse_Y)) < 3) { ; return false; }
				
				do{
				var newX = mouse_X + (Math.random() * 100-50) * flg_2;
				var newY = mouse_Y + (Math.random() * 100-50) * flg_2;
				}while (newX<0 || newX>stageWidth || newY<0 || newY>stageHeight);
				
				particles.push(new particle(newX,newY, particles.length, particles[particles.length-1]));
				shape1.graphics.lineStyle(20+flg_2*20, 0xffffff, .2, true);
				shape1.graphics.drawCircle(newX, newY, 40+flg_2*30);
				bmp.bitmapData.draw(shape1,emptymatrix, null, BlendMode.LIGHTEN);
				particles[0].setObj(particles[particles.length-1]);
			} else {
				
				particles.push(new particle(mouse_X,mouse_Y,0));

			}

			if (particles.length > 60) {//これを増やすと点の上限数が増える
				shape1.graphics.lineStyle(30, 0x000000, .8, true);
				shape1.graphics.drawCircle(particles[0].xx, particles[0].yy, 60);
				bmp.bitmapData.draw(shape1,emptymatrix, null, BlendMode.SUBTRACT);
				particles.shift();
			}

		}
	
		function getLineLength(p:Rectangle):Number
		{
			var vx=p.x-p.width;
			var vy=p.y-p.height;
			var vl=Math.sqrt(Math.pow(vx,2)+Math.pow(vy,2));
			return vl;
		}
		

    }
}
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.display.Bitmap;
    import flash.display.Stage;
    import flash.display.BitmapData;
    import flash.display.DisplayObjectContainer;
    import flash.display.LineScaleMode;
    import flash.display.BlendMode;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.geom.Point;
    import flash.geom.ColorTransform;
    import flash.events.Event;
    import flash.utils.ByteArray;
    import flash.filters.BlurFilter;

	class particle extends Sprite{
		
		var col:uint = 0;
		var ox:Number=0;
		var oy:Number=0;
		var ol:Number=0;
		var xx:Number=0;
		var yy:Number=0;
		var _x:Number=0;
		var _y:Number=0;
		var tx:Number=0;
		var ty:Number=0;
		var dx:Number=0;
		var dy:Number=0;
		var dl:Number=0;
		var cnt:Number=0;
		var obj:particle;
       		var cut:Boolean = false;
		
		public function particle(... args):void {
			
			ox= xx = args[0];
			oy= yy = args[1];
			name = args[2];
			obj = args[3];
			
			if (args[3]==undefined) {
				obj = this;
			}
			
			var tmptime = new Date();
			cnt = tmptime.milliseconds * .002 * Math.PI;
			tx = partest._table[((cnt + partest._HALF_PI) * partest._TWO_PI_SCALE) & (partest._TABLE_SIZE - 1)];
			ty = partest._table[(cnt * partest._TWO_PI_SCALE) & (partest._TABLE_SIZE - 1)];
			col = Math.random() * 16777215;
			addEventListener(Event.ENTER_FRAME, enterframeHandlr);
		}
		
		
		private function enterframeHandlr(e:Event) {
			calcVector();
		}
		
		private function calcVector() {
                        //この子は一つ前の点を追う動きをする
                        
			cnt += (cnt < 12.56)?.3: -cnt;
			
			_x = obj.xx - this.xx;
			_y = obj.yy - this.yy;
			
			ol = _x * _x + _y * _y;
			if (ol > 3) {
				
				dx = _x / ol;
				dy = _y / ol;
				
				dx = (!dx)?0:dx;
				dy = (!dy)?0:dy;
				
				dx = (Math.abs(dx)<2)?dx:dx/Math.abs(dx);
				dy = (Math.abs(dy)<2)?dy:dy/Math.abs(dy);
				tx += dx * uint(dx > 0 && tx < 5) + dx * uint(dx<0 && tx>-5);// + partest._table[((cnt + partest._HALF_PI) * partest._TWO_PI_SCALE) & (partest._TABLE_SIZE - 1)];
				ty += dy * uint(dy > 0 && ty < 5) + dy * uint(dy<0 && ty>-5);//+ partest._table[(cnt * partest._TWO_PI_SCALE) & (partest._TABLE_SIZE - 1)];
				tx = (Math.abs(tx)<5)?tx:tx/Math.abs(tx)*5;
				ty = (Math.abs(ty)<5)?ty:ty/Math.abs(ty)*5;
			}
			xx += tx;
			yy += ty;
			if(partest.stageWidth){
				if (xx < 0 || xx > partest.stageWidth) { xx -= tx; tx = -tx*.3; }
				if (yy < 0 || yy > partest.stageHeight) { yy -= ty; ty = -ty*.3; }
			}
			
		}
		
		public function setObj(o):void {
			obj = o;
		}
		
	}
