/**
 * Copyright geko ( http://wonderfl.net/user/geko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wz9N
 */

/*
minimalcompsのWindowを使って
マウス操作でリサイズ可能なResizableWindowを作成。
Window右下にリサイズ用ボタンがあります。
動きのチェックだけなのでボタンのグラフィックは適当。

何故かリサイズボタンだけ先走って移動してしまう・・・。
PCのスペックのせい？
*/
package {
	import flash.display.Sprite;
	
	public class FlashTest extends Sprite {
		public function FlashTest() {
			var window:ResizableWindow = new ResizableWindow(this);
		}
	}
}

import flash.display.DisplayObjectContainer;
import flash.events.MouseEvent;
import com.bit101.components.*;

class ResizableWindow extends Window{
	private var resizeBt:ResizeButton = new ResizeButton();
	private var _oldX:Number;
	private var _oldY:Number;
	
	public function ResizableWindow(parent:DisplayObjectContainer=null, xpos:Number=0, ypos:Number=0, title:String="ResizableWindow"):void{
		super(parent, xpos, ypos, title);
		resizeBt.addEventListener(MouseEvent.MOUSE_DOWN, resizeHandler);
		stage.addEventListener(MouseEvent.MOUSE_UP, resizeHandler);
	}
	
	public override function setSize(width:Number, height:Number):void{
		super.setSize(width,height);
		addChild(resizeBt);
		resizeBt.x = width-15;
		resizeBt.y = height-15;
	}
	private function resizeHandler(event:MouseEvent):void{
		switch(event.type){
			case MouseEvent.MOUSE_DOWN:
				_oldX = mouseX;
				_oldY = mouseY;
				stage.addEventListener(MouseEvent.MOUSE_MOVE,resizeHandler);
			break;
			case MouseEvent.MOUSE_MOVE:
				setSize(Math.max(width+(mouseX-_oldX),100),Math.max(height+(mouseY-_oldY),100));
				_oldX = Math.max(mouseX,94);
				_oldY = Math.max(mouseY,94);
			break;
			case MouseEvent.MOUSE_UP:
				stage.removeEventListener(MouseEvent.MOUSE_MOVE,resizeHandler);
			break;
		}
		event.updateAfterEvent();
	}
}

import flash.display.Sprite;
class ResizeButton extends Sprite{
	public function ResizeButton():void{
		alpha = 0.3;
		this.buttonMode = true;
		this.graphics.beginFill(0,0.01);
		this.graphics.drawRect(0,0,15,15);
		this.graphics.endFill();
		this.graphics.lineStyle(1.38,0x666666);
		this.graphics.moveTo(13,2/15);
		this.graphics.lineTo(2/15,13);
		this.graphics.moveTo(7.5-2/15,13);
		this.graphics.lineTo(13,7.5-2/15);
		
		this.addEventListener(MouseEvent.ROLL_OVER, mouseHandler);
		this.addEventListener(MouseEvent.ROLL_OUT, mouseHandler);
	}
	
	private function mouseHandler(event:MouseEvent):void{
		if(event.type == MouseEvent.ROLL_OVER) alpha = 1;
		else alpha = 0.3;
	}
}