/**
 * Copyright coppieee ( http://wonderfl.net/user/coppieee )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wyeF
 */

/**
 * 枠に今年の抱負書いて、tweetボンタンでtwitterに投稿！
 * しばらくしたらタイムラインに表示されるよ！
 * 30秒に1回更新。
 * 
 * twitterで「http://bit.ly/houhu2010」のキーワードで検索してる。
 * @author http://twitter.com/coppieee
 */
package 
{
	import com.bit101.components.InputText;
	import com.bit101.components.Label;
	import com.bit101.components.PushButton;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.DisplayObject;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.filters.BitmapFilter;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.net.navigateToURL;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFieldType;
	import flash.utils.escapeMultiByte;
	import flash.utils.Timer;
	import frocessing.color.ColorHSV;
	
	public class Main extends Sprite 
	{
		public function Main()
		{
			function rightPos(target:DisplayObject):Number {
				return target.x + target.width + 10;
			}
			
			var leftLabel:TextField = new TextField();
			leftLabel.autoSize = TextFieldAutoSize.LEFT;
			leftLabel.x =  0;
			leftLabel.y = 400;
			leftLabel.text = "今年の抱負は「";
			addChild(leftLabel);
			var input:TextField = new TextField();
			input.type = TextFieldType.INPUT;
			input.multiline = false;
			input.width = 200;
			input.height = 20;
			input.autoSize = TextFieldAutoSize.NONE;
			input.x = rightPos(leftLabel);
			input.y = 400;
			input.width = 200;
			input.border = true;
			addChild(input);
			var rightLabel:TextField = new TextField();
			rightLabel.autoSize = TextFieldAutoSize.LEFT;
			rightLabel.x = rightPos(input);
			rightLabel.y = 400;
			rightLabel.text = "」!";
			addChild(rightLabel);
			
			var tweetButton:PushButton = new PushButton(this, rightPos(rightLabel), 400, "tweet!");
			tweetButton.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void {
				navigateToURL(new URLRequest("http://twitter.com/home/?status=" +
					escapeMultiByte("今年の抱負は「" + input.text + "」! ") + "http://bit.ly/houhu2010"
				));
			});
			
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			var loadTimer:Timer = new Timer(30000);
			loadTimer.addEventListener(TimerEvent.TIMER, onLoadTimer );
			loadTimer.start();
			
			var createTimer:Timer = new Timer(2000);
			createTimer.addEventListener(TimerEvent.TIMER, onCreateTimer);
			createTimer.start();
			
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			
			_canvas = new BitmapData(462, 400, false, 0xFFFFFF);
			addChild(new Bitmap(_canvas));
			
			//var testButton:PushButton = new PushButton(this);
			//testButton.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void {
				//loadTextAndPush(20);
			//});
			
			_texts = [new TwitterText("～2010年の抱負～")];
			loadTextAndPush(100);
		}
		private var _texts:Array = [];
		private var _index:int = 0;
		private function onLoadTimer(e:TimerEvent):void {
			loadTextAndPush(20);
		}
		private var _textFields:Array = [];
		private var _canvas:BitmapData;
		private function onCreateTimer(e:TimerEvent):void {
			
			var tf:TextField = new TextField();
			//tf.htmlText = _texts[_index];
			tf.text = _texts[_index].text;
			tf.autoSize = TextFieldAutoSize.LEFT;
			var scale:Number =  Math.min(5,462/tf.width);
			tf.scaleX = scale;
			tf.scaleY = scale;
			tf.textColor = new ColorHSV(360 * Math.random()).value;
			tf.y = -tf.height / 2;
			tf.x = -tf.width / 2;
			
			var sprite:Sprite = new Sprite();
			sprite.addChild(tf);
			sprite.rotation = 30;
			var m:Matrix = new Matrix();
			m.translate(462/2, 350);
			
			_canvas.draw(sprite,m,null,null,null,true);
			
			if (_index + 1 < _texts.length) {
				_index ++;
			}else {
				_index = 0;
			}
		}
		
		private function onEnterFrame(e:Event):void {
			_canvas.scroll(0, -1);
		}
		private function loadTextAndPush(count:int):void {
			loadTexts(function(xs:Array):void {
				if (xs.length > 0) {
					var x:TwitterText = xs[0];
					for (var i:int = 0; i < _texts.length; i++ )
					{
						var t:TwitterText = _texts[i];
						if (t.published == x.published) {
							_texts.splice(i);
							break;
						}
					};
				}
				_texts.push.apply(null, xs);
			},count);
		}
		private function loadTexts(listener:Function,count:int):void {
			var textNum:int = count;
			var textLoader:URLLoader = new URLLoader(new URLRequest("http://search.twitter.com/search.atom?q="+"http%3A%2F%2Fbit.ly%2Fhouhu2010"+"&rpp=" + textNum));
			//var textLoader:URLLoader = new URLLoader(new URLRequest("http://search.twitter.com/search.atom?q="+escapeMultiByte("「")+"&rpp=" + textNum));
			textLoader.addEventListener(Event.COMPLETE, function(e:Event):void {
					default xml namespace = new Namespace("http://www.w3.org/2005/Atom");
					var htmlText:XML = XML(textLoader.data);
					var entry:XMLList = htmlText.entry;
					var xs:Array = [];
					for each(var c:XML in  entry)
					{
						//var text:String = "<img src='"+c.link.(@type =="image/png").@href+"' />"+
							//"<p>"+scan(c.title.toString(),/「(.+)」/)[0] + "</p>";
						var text:String = scan(c.title.toString(),/「(.+)」/)[0];
						if (text == null || text == "") {
							continue;
						}
						var tt:TwitterText = new TwitterText(text);
						tt.published = c.published;
						if(text != null){
							xs.push(tt);
						}
					}
					listener(xs);
			});
		}
	}
}
/**
 * @see http://takumakei.blogspot.com/2009/05/actionscriptrubystringscan.html
 */ 
//package com.blogspot.takumakei.utils
//{
	//public
    function scan(str:String, re:RegExp):Array
    {
        if(!re.global){
            var flags:String = 'g';
            
            if(re.dotall)
                flags += 's';
            if(re.multiline)
                flags += 'm';
            if(re.ignoreCase)
                flags += 'i';
            if(re.extended)
                flags += 'x';

            re = new RegExp(re.source, flags);                    
        }

        var r:Array = [];
        var m:Array = re.exec(str);
        while(null != m){
            if(1 == m.length)
                r.push(m[0]);
            else
                r.push(m.slice(1, m.length));
            m = re.exec(str);
        }
        return r;
    }
//}
class TwitterText {
	public var text:String;
	public var published:String;
	public function TwitterText(text:String) {
		this.text = text;
	}
	public function toString():String {
		return text;
	}
}