/**
 * Copyright alpicola ( http://wonderfl.net/user/alpicola )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wxlK
 */

// wonderfl から外部画像の読み込みを行うのに便利な Proxy を作りました
// http://5ivestar.org/proxy/
// どうぞご利用ください
// 詳細 => http://5ivestar.org/blog/2008/12/wonderfl-webproxy/

package {
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.display.Shape;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.events.Event;
	import flash.geom.Matrix;
	import flash.geom.Rectangle;
	import flash.net.URLRequest;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.system.Security;
	import caurina.transitions.Tweener;

	[SWF(backgroundColor="#ffffff", frameRate="30")] 

	public class BubbleTypo extends Sprite {

		private var loader:Loader;
		private var loading:TextField;
		private var container:Sprite;
		private var bitmap:BitmapData;
		private var circles:Array = [];
		private var n:int = 0;

		public function BubbleTypo() {
			stage.align = "TL";
			stage.scaleMode = "noScale";

			Security.loadPolicyFile("http://5ivestar.org/proxy/crossdomain.xml");
			loader = new Loader();
			loader.contentLoaderInfo.addEventListener("complete", loadingComplete);
			loader.load(new URLRequest("http://5ivestar.org/proxy/http://www.google.com/logos/Logo_60wht.gif"));
			loading = new TextField();
			loading.defaultTextFormat = new TextFormat("_sans", 24);
			loading.text = "Now Loading...";
			loading.autoSize = "left";
			loading.x = (stage.stageWidth - loading.width) / 2;
			loading.y = (stage.stageHeight - loading.height) / 2;
			addChild(loading);
		}

		public function loadingComplete(e:Event):void {
			removeChild(loading);
			var bmp:BitmapData = new BitmapData(loader.width, loader.height, false, 0xffffff);
			bmp.draw(loader);

			var bound:Rectangle = bmp.getColorBoundsRect(0xFFFFFFFF, 0xFFFFFFFF, false);
			var r:int = bound.right;
			var b:int = bound.bottom;
			for (var xx:int = bound.x; xx < r; xx++) {
				for (var yy:int = bound.y; yy < b; yy++) {
					var c:uint = bmp.getPixel(xx, yy);
					if (c == 0xffffff) continue;
					circles.push({x: xx * 5, y: yy * 5, color: c});
				}
			}

			bitmap = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00000000);
			addChild(new Bitmap(bitmap));

			container = new Sprite();
			var scale:Number = Math.min(stage.stageWidth / loader.width, stage.stageHeight / loader.height) / 5;
			container.scaleX = scale;
			container.scaleY = scale;
			addChild(container);

			addEventListener(Event.ENTER_FRAME, loop);

		}

		public function loop(e:Event):void {
			n++;
			n %= 300;

			var length:int = circles.length;
			for (var i:int = 0; i + n < length; i += 300) {
				var circle:Object = circles[i + n];
				var xx:Number = circle.x;
				var yy:Number = circle.y;
				var c:uint = circle.color;

				var s:Shape = new Shape();
				var t1:Number = Math.random();
				var t2:Number = Math.random();
				var t3:Number = Math.random();
				var t4:Number = Math.random();
				s.graphics.lineStyle(t1 * 3, c, 0.5);
				s.graphics.drawCircle(0, 0, Math.pow(t2 + 0.2, 2) / (t1 * 3 + 1) * 25);
				s.x = xx + (t2 - 0.75) * 400;
				s.y = (loader.height + 100) * 5;
				container.addChild(s);

				Tweener.addTween(s, {
					x: xx + (t3 - 0.5) / (t4 * 2 + 0.1) * 30,
					y: yy + (t4 - 0.5) / (t3 * 2 + 0.1) * 30,
					time: 4,
					transition: "easeInOutCirc",
					onCompleteParams: [s],
					onComplete: function(s:Shape):void {
						var m:Matrix = new Matrix();
						m.translate(s.x, s.y);
						m.scale(container.scaleX, container.scaleY);
						bitmap.draw(s, m, null, "layer");
						container.removeChild(s);
						s = null;
					}
				});
			}
		}

	}
}
