/**
 * Copyright spaztik ( http://wonderfl.net/user/spaztik )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wxWC
 */

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import com.bit101.components.Panel;
    import com.bit101.components.Label;
    
    public class ColorPicker extends Sprite {
        private var panel:Panel;
        private var label:Label;
        private var picker:Sprite;
        private var colorBar:ColorBar;
        
        public function ColorPicker() {
            panel = new Panel(this, 20, 10);
            panel.setSize(65, 16);
            panel.color = 0xCCCCCC;
            label = new Label(panel, 2, 0);
            
            colorBar = addChild(new ColorBar(0, 50, 250, 600)) as ColorBar;
            
            //
            colorBar.addEventListener(MouseEvent.MOUSE_OVER, function mouseOver(event:MouseEvent):void{
                stage.addEventListener(MouseEvent.MOUSE_MOVE, change);
            });
            colorBar.addEventListener(MouseEvent.MOUSE_OUT, function mouseOut(event:MouseEvent):void{
                stage.removeEventListener(MouseEvent.MOUSE_MOVE, change);
            });

        }
        
        private function change(event:MouseEvent):void{
            var _color:uint = colorBar.getColor(colorBar.mouseX, colorBar.mouseY);
            var _colorStr:String = _color.toString(16).toUpperCase()
            while(_colorStr.length < 6) _colorStr = "0"+_colorStr;
            label.text = "0x"+_colorStr;
            
            graphics.clear();
            graphics.lineStyle(1, 0xCCCCCC);
            graphics.beginFill(uint(_color));
            graphics.drawRect(2, 10, 16, 16);
            graphics.endFill();
        }

    }
}


import flash.display.BitmapData;
import flash.display.Shape;
import flash.display.Sprite;
import flash.geom.Matrix;

//カラーバー
class ColorBar extends Sprite{
    //*************************
    //         変数定義
    //*************************
    private var _bg:Shape;
    private var _color:Shape;
    private var _width:Number = 100;
    private var _height:Number = 100;
    public override function set width(val:Number):void{ _width = val; draw(); }
    public override function get width():Number{ return _width; }
    public override function set height(val:Number):void{ _height = val; draw();}
    public override function get height():Number{ return _height; }


    //*************************
    //       コンストラクタ
    //*************************
    public function ColorBar(x:Number = 0, y:Number = 0, width:Number = 100, height:Number = 100){
        //パラメータの設定
        this.x = x; this.y = y; _width = width; _height = height;
        
        //表示オブジェクトの設定
        _bg = addChild(new Shape) as Shape;
        _color = addChild(new Shape) as Shape;
        //_color.blendMode = "overlay";
        
        draw();
    }
    
    
    //*************************
    //          描画
    //*************************
    public function draw():void{
        var mtrx:Matrix = new Matrix();
        
        //白黒の縦グラデーション

        
        //カラフルな横グラデーション
        mtrx.createGradientBox(_width, _height, Math.PI/2);
        _color.graphics.clear();
        _color.graphics.beginGradientFill("linear", [0xFF0000, 0xFFFF00, 0x00FF00, 0x00FFFF, 0x0000FF, 0xFF00FF, 0xFF0000], [1, 1, 1, 1, 1, 1, 1], [0, 0xFF*1/6, 0xFF*2/6, 0xFF*3/6, 0xFF*4/6, 0xFF*5/6, 0xFF], mtrx);
        _color.graphics.drawRect(0, 0, _width, _height);
        _color.graphics.endFill();
    }
    
    //*************************
    //          
    //*************************
    public function getColor(x:Number = 0, y:Number = 0):uint{
        var _bmd:BitmapData = new BitmapData(_width, _height, false, 0xFFFFFF);
        var _color:uint;
        _bmd.draw(this);
        _color = _bmd.getPixel(x, y);
        _bmd.dispose();
        return _color;
    }
}