/**
 * Copyright komatsu ( http://wonderfl.net/user/komatsu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wx7w
 */

/*
外部XMLファイルを読むにあたって、「5iVESTAR.ORG」様のプロキシを使わせてもらいました。
Wonderfl が楽しい　December 28th, 2008
http://5ivestar.org/blog/2008/12/wonderfl-webproxy/

svgファイルは、Illustratorで別名保存で作成しました。

frocessingを使用した。ベクターデータの読み込みは、Adobeのデベロッパーセンターを参考にしました。

FlashでSVG形式のベクターグラフィックを利用する
http://www.adobe.com/jp/devnet/flash/articles/spark_project_svg.html
*/

package {
	import flash.net.*;
    import flash.display.Sprite;
    import flash.events.*
    import flash.system.*;
    import frocessing.shape.FShapeSVG;
    import caurina.transitions.Tweener;
    
    public class LoadSVG extends Sprite {
    		private var cData:Date = new Date();//XMLのキャッシュ対策
    		private var svgFileURL:String = "http://activefactor.jp/wonderfl/dog.svg";
		private var URL:String = "http://5ivestar.org/proxy/"+ svgFileURL +"?cData="+cData.getTime();
		
        public function LoadSVG() {
        		Security.loadPolicyFile("http://5ivestar.org/proxy/crossdomain.xml");//crossdomainポリシーファイルの読み込み
        		var loader:URLLoader = new URLLoader();
        		loader.addEventListener(Event.COMPLETE, loadComp);
        		loader.load(new URLRequest(URL));
        }
        
        private function loadComp(e:Event):void{
        		var svgXml:XML = new XML(e.target.data);
            var shapedata:FShapeSVG = new FShapeSVG(svgXml);
            var centerSp:Sprite = shapedata.toSprite();
            //絵の基準を犬の足元にずらす
            centerSp.x = -centerSp.width/2-10;
            centerSp.y = -centerSp.height;
            var sp:Sprite = new Sprite();
            //初期位置の調整
            sp.addChild(centerSp);
            sp.x = sp.width*2;
            sp.y = stage.stageHeight;
            
            sp.addChild(centerSp);
            addChild( sp );
            
            //アニメーション設定
            sp.alpha = 0;
            sp.blendMode = "layer";//ベクターの重なりを綺麗に見せるため、ブレンドモードをレイヤーに
           Tweener.addTween(sp , {alpha:1, time:1,transition:"easeIn"}); 
           Tweener.addTween(sp , {scaleX:4 , scaleY:4 , delay:1 , time:1,transition:"easeOutElastic"});
           Tweener.addTween(sp , {rotation:90 , delay:3 , time:2,transition:"easeOutBounce"});
        }       
    }
}
