/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wwun
 */

package {
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            
          buildNode();  
          stage.addEventListener(Event.ENTER_FRAME, onEnter);  
        }//ctor
        
        
         public var mw:int = 16;
         public var mh:int = 16;
         
         public var cw:Number = 32;
         public var ch:Number = 32;
        
          public var cx:Number = 230;   
          public var cy:Number = 230;    
            
          public var ang:Number = 0;  
          public var vx:Number = 0;
          public var vy:Number = 0;
          
          public var gx:Number = 0;
          public var gy:Number = 0;   
        
          public var gt:int = 0;

          public var vecPath:Vector.<xNode>;

          public var curNode:int = 0;
          public var targx:Number = 0;
          public var targy:Number = 0;
        
        public function onEnter(e:Event):void
        {
           graphics.clear();
           graphics.lineStyle(2, 0);

            var mx:Number; var my:Number;
            mx = stage.mouseX; my = stage.mouseY;
            
           var a:xNode;
           var i:int; var k:int;
           for(i=0;i<mh;i+=1)
           {
             for(k=0;k<mw;k+=1)
             {
                a = getNode(k,i);
                if (a == null) { continue; }
                if (a.baseCost >= 999)
                {
                  graphics.beginFill(0,1);
                   graphics.drawRect(k*cw,i*ch,cw,ch); 
                  graphics.endFill();
                continue;    
                }//endif
                // graphics.drawRect(k*cw,i*ch,cw,ch); 
             }//nextk  
           }//nexti 
            
                       
           graphics.drawCircle(cx,cy,8);
           graphics.moveTo(cx,cy);
           graphics.lineTo(cx+Math.cos(ang)*8,cy+Math.sin(ang)*8);
           
           
           gt += 1;
          // if (gt%30 == 0)
          // { gx=mx; gy=my; }
           
           if (vecPath != null && vecPath.length>curNode)
           {
             a = vecPath[curNode];
             gx = a.cx;
             gy = a.cy;
             graphics.drawCircle(gx,gy,16);
             if (getMag(cx-gx,cy-gy) < 8) { curNode += 1; } 
             if (curNode >= vecPath.length){ vecPath=null;}   
           }

          
          if (getMag(mx-targx, my-targy)>64){ vecPath=null;}
          
          // if (gt%30 == 0 || vecPath == null)
           if (vecPath == null || vecPath.length <= curNode)
           {
               curNode = 0;
               targx=mx;
               targy=my;
            var b:xNode;
            a = getClose(mx,my);
            b = getClose(cx,cy);
            findPath(b, a);
            vecPath = getPath();               
           }
          
           
           var ta:Number;
           ta = Math.atan2(gy-cy, gx-cx);
           ang = Math.atan2(my-cy, mx-cx);
           ang = ta;
           
           var ms:Number;
           ms=2;
           if (getMag(cx-gx,cy-gy)<ms){ms=0;}
           vx = Math.cos(ta)*ms;
           vy = Math.sin(ta)*ms;
           
           cx+=vx; cy+=vy;
           
           
           
           
          var num:int;
          num = vecPath.length;
          for(i=0;i<num;i+=1)
          {
            a = vecPath[i];
            if (i==0){graphics.moveTo(a.cx,a.cy); }
            graphics.lineTo(a.cx,a.cy);  
          }//nexti
            
            
        }//onenter
        
        
        
         public function getMag(ax:Number,ay:Number):Number
        { return Math.sqrt(ax*ax+ay*ay); }
        
         public var vecNode:Vector.<xNode> = new Vector.<xNode>(0,false);

        public function getNode(ax:int, ay:int):xNode
        { if (ax<0||ax>=mw||ay<0||ay>=mh){return null;} return vecNode[ax+(ay*mw)];  }

        public function buildNode():void
        {
          var k:int; var i:int; var num:int; 
          var a:xNode; var b:xNode;
 
          num = mw*mh;
          vecNode = new Vector.<xNode>(num,false);   
          for (i=0;i<num;i+=1) { vecNode[i] = new xNode(); }  
            
           for(i=0;i<mh;i+=1)
           {
             for(k=0;k<mw;k+=1)
             {
              a = getNode(k,i);
              a.cx = k*cw + cw *0.5;
              a.cy = i*ch + ch *0.5;
              a.baseCost = Math.random() <0.2 ? 9999:0;
              
              b = getNode(k+1, i);  if (b!=null){a.vecNext.push(b);}
              b = getNode(k-1, i);  if (b!=null){a.vecNext.push(b);}
              b = getNode(k, i+1);  if (b!=null){a.vecNext.push(b);}
              b = getNode(k, i-1);  if (b!=null){a.vecNext.push(b);}
                 
             }//nextk  
           }//nexti 
              
        }//buildnode
        
        public function getClose(ax:Number, ay:Number):xNode
        {
         var d:Number; var mag:Number;
         var ret:xNode;
         var num:int; var i:int;
         var a:xNode;
         if (vecNode.length<=0){return null; }         
         ret = vecNode[0];
         mag = getMag(ret.cx-ax, ret.cy-ay);
         
         num = vecNode.length;
         for (i=0;i<num;i+=1)
         {
           a = vecNode[i];
           d = getMag(a.cx-ax,a.cy-ay);
           if (d>=mag) {continue;}
           mag=d;ret=a;   
         }//nexti   
          return ret;  
        }//getclose
        
        public var maxOpen:int = 1024;
        public var vecOpen:Vector.<xNode> = new Vector.<xNode>(1024, false);
        public var curFrame:int =0;
        public var lastNode:xNode = null;
        
        public function findPath(from:xNode, to:xNode):void
        {
          var i:int; var num:int; var k:int; var nk:int;  
          var ot:int; var mcost:Number;  
          var a:xNode; var b:xNode;

          if (from ==null || to ==null){ lastNode=null; return;}
          
          lastNode=null;
          curFrame+=1;
          ot = 1;  
          vecOpen[0]= from;
          from.cost=0;
          from.parent=null;
          from.frame=curFrame;  
            
          for(i=0;i<4096;i+=1)
          {
            if (ot<=0){ return; }              
              
                mcost = 999999999; 
                a = vecOpen[0];
                for (k = 0; k < ot; k+=1)
                {
                    b = vecOpen[k];
                    if (b.cost < mcost)
                    {  mcost = b.cost;  a = b; nk = k;  }
                }//nextk
                
                vecOpen[nk] = vecOpen[ot - 1];
                ot -= 1;
                if (a == to) { lastNode = to;  return; }
            
                num=a.vecNext.length;
                for(k=0;k<num;k+=1)
                {
                  b = a.vecNext[k];
                  if (b.frame==curFrame){continue;}
                  if (b.baseCost >999){continue;}
                  b.frame=curFrame;
                  b.cost = getMag(a.cx-b.cx, a.cy-b.cy)  + a.cost + b.baseCost; 
                  b.parent = a; 
                  vecOpen[ot] =b;ot+=1; if (ot>=maxOpen){ot=maxOpen-1;}
                }//nextk
          }//nexti  
        }//findpath
        
        public function getPath():Vector.<xNode>
        {
           var a:xNode; var k:int;
           var ret:Vector.<xNode>;
           ret = new Vector.<xNode>(0,false);
           a = lastNode; k = 0;
           while(a != null)
           {
             //  graphics.drawCircle(a.cx,a.cy,16);
               ret.push(a);
               a = a.parent;              
               k+=1;if (k>=1024){return null;}
           } //wend          
           return ret.reverse(); 
        }//getpath  
        
        
        
        
    }//classend
}




internal class xNode
{
  public var cx:Number = 0;
  public var cy:Number = 0;
  public var frame:int = 0;  
  public var cost:Number = 0;
  public var baseCost:Number = 0;
  public var parent:xNode = null;
  public var vecNext:Vector.<xNode> = new Vector.<xNode>(0,false);
    
}//xnode


 