/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wwMa
 */

// forked from Blue_fox_and_red_grape's Hello Away3D!
package {
    import flash.geom.Vector3D;
    import flash.events.Event;
    import flash.display.Sprite;
    
    import away3d.cameras.*;
    import away3d.containers.*;
    import away3d.materials.*;
    import away3d.primitives.*;
    
    public class HelloAway3D extends Sprite {

        private var SW:Number, SH:Number, SD:Number; 
        private var mX:Number, mY:Number, mD:Number; 
        public  var mousePos:Vector3D;
        private var _point3D:Vector3D;       
        private var view3D:View3D;
        private var cam3D:Camera3D;
        private var target:Sprite;
        
        public function HelloAway3D() 
        {
            SW = stage.stageWidth;
            SH = stage.stageHeight;
            SD = 1000;
            
            _point3D = new Vector3D;
            cam3D = new Camera3D;
            
            view3D = new View3D;
            view3D.x = SW/2;
            view3D.y = SH/2;
            addChild( view3D );
            
            var trident:Trident = new Trident( 100, true );
            trident.scaleX = .5;
            trident.scaleY = .5;
            view3D.scene.addChild( trident );
            
            var box01:Cube = new Cube;
            var box02:Cube = new Cube;
            var box03:Cube = new Cube;

            box01.x = Math.random()*SW; box01.y = Math.random()*SH; box01.z = Math.random()*SD;
            box02.x = Math.random()*SW; box02.y = Math.random()*SH; box02.z = Math.random()*SD;
            box03.x = Math.random()*SW; box03.y = Math.random()*SH; box03.z = Math.random()*SD;
 
            view3D.scene.addChild( box01 );
            view3D.scene.addChild( box02 );
            view3D.scene.addChild( box03 );
            
            addEventListener( Event.ENTER_FRAME, UPDATER );
            addEventListener( Event.ENTER_FRAME, RealTime );
        }
        
        
        public function RealTime():void
        { 
            mX = mouseX;
            mY = mouseY;
            mousePos = new Vector3D( mX,mY,0 );
            function getMousePos( mousePos:Vector3D ):Vector3D
            {
                mousePos = new Vector3D( mX,mY,0 );    
                return mousePos;
            }

        } 
        
        
        private function UPDATER( e:Event ):void
        { 
            view3D.camera.x =  mouseX - SW/2;
            view3D.camera.y =  mouseY - SH/2;
            view3D.camera.lookAt( _point3D );
            view3D.render();
        }
        
    }
}