/**
 * Copyright onedayitwillmake ( http://wonderfl.net/user/onedayitwillmake )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ww7M
 */

// forked from onedayitwillmake's Obey Colors
// forked from onedayitwillmake's Obey Triangle
// forke// forked from Saqoosha's Rainbow
// forked from siba2260's 残像
// write as3 code here..
package {
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BlendMode;
	import flash.display.Graphics;
	import flash.display.PixelSnapping;
	import flash.display.Sprite;
	import flash.events.Event; 
	import flash.events.MouseEvent;
	import flash.filters.ColorMatrixFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Point;
	
	import frocessing.color.ColorHSV;
	import frocessing.color.ColorRGB;
	
	[SWF(width="465", height="465", backgroundColor="0x000000", frameRate="60")]
	
	public class Rainbow extends Sprite {
		
		private static const ZERO_POINT:Point = new Point(0, 0);
		
		private static const NUM_OBJECTS:int = 6;
		private static const FORCE:Number = 500.0;  
		private static const COLOR_SPEED:Number = 0.05;
		
		private var _center:Sprite;
		private var _images:Array;
		private var _tmp:BitmapData; 
		
		private var _mousePressed:Boolean = false;
		private var _prevTime:int = 0;
		private var _colorOffset:Number = 0;
		private var _mousePt:Point = new Point();
		
		private var afterBitmapData	:BitmapData = new BitmapData(465, 465, false, 0x00FFFFFF);
		private var afterImage		:Bitmap = new Bitmap(afterBitmapData, PixelSnapping.AUTO,  false);
		private var _canvas			:Sprite = new Sprite();
		public function Rainbow()
		{
			addChild(_canvas);
			addChild(afterImage);
			afterImage.x = 0
			afterImage.y = 0
			createImage();
			
			stage.quality = "low";
		}
		
/**
var color:int = Math.random() * 0x0099FF;
			if (Math.random() > 0.6) {
				color = 0xFFFFFF;
			}
			this.graphics.beginFill(color, 0.1);
			this.graphics.drawCircle(this.m_x, this.m_y, this.m_r * this.m_cnt);
			this.graphics.endFill();

			var matrix:Matrix = new Matrix(1,0,0,1,0,0);
			var color_t:ColorTransform = new ColorTransform(1,1,1,1,0,0,0,0);

			this.m_bitmap_data.draw(this, matrix, color_t);
			
			this.graphics.clear();
			
			this.m_cnt++;
			
			if (this.m_cnt > this.m_cnt_max) {
				this.m_cnt = 1
				this.m_x = Math.random() * 500;
				this.m_y = Math.random() * 500;
				this.m_r = Math.random() * 10 + 5;
			}
*/

		private function createImage():void
		 {
			
			var original:BitmapData = new BitmapData(120, 120, true, 0x00000000);
			var circleSprite:Sprite = new Sprite();
 
			for(var i:int = 0; i < 20; i++)
			{
				circleSprite.graphics.beginFill(0xffffff, 0.05);
				circleSprite.graphics.drawCircle(50, 50, 2 * i);
				circleSprite.graphics.endFill();   
			}  

			original.draw(circleSprite);
			
			_center = new Sprite();//addChild(new Sprite()) as Sprite;
			_center.x = stage.stageWidth / 2;
			_center.y = stage.stageHeight / 2;

			var rs:Number = 0, gs:Number = 0, bs:Number = 0;
			var c:ColorRGB;
			for (i = 0; i < NUM_OBJECTS; i++) {
				c = new ColorHSV(i / NUM_OBJECTS * 360, 1, 1).toRGB();
				rs += c.r;
				gs += c.g;
				bs += c.b;
			}
			
			_images = [];
			for (i = 0; i < NUM_OBJECTS; i++)
			{
				var a:Number = Math.PI * 2 * i / NUM_OBJECTS;
				c = new ColorHSV(i / NUM_OBJECTS * 360, 1, 1).toRGB();
				var img:ColoredImage = _center.addChild(new ColoredImage(original, c.r / rs, c.g / gs, c.b / bs)) as ColoredImage;
				var px:Number = Math.cos(a) * 60;
				var py:Number = Math.sin(a) * 60;  
				img.init(px, py);
				_images.push(img);
				var f:Number = Math.random() * 100
				img.addForce(Math.cos(a) *f, Math.sin(a) * f);
			}
			
			addEventListener(Event.ENTER_FRAME, _update);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, _onMouseDown);
			stage.addEventListener(MouseEvent.MOUSE_UP, _onMouseUp);
		}
		
		private function _onMouseDown(e:MouseEvent):void {
			_mousePressed = true;
		}
		
		private function _onMouseUp(e:MouseEvent):void {
			_mousePressed = false;
		}
		
		private function _update(e:Event):void
		{
			_mousePt.x = _center.mouseX;
			_mousePt.y = _center.mouseY
			var img:ColoredImage;
			for each (img in _images)
			{
				var dist:Number = Math.max(Point.distance(_mousePt, img.initPos), 3);
				var lc:Point = img.initPos.subtract(_mousePt);
				var a:Number = Math.atan2(lc.y, lc.x);
				var f:Number = 1 / dist * FORCE * (_mousePressed ? 3 : 1);
				img.addForce(Math.cos(a) * f, Math.sin(a) * f);
				img.update();
			}
			
			afterBitmapData.colorTransform(afterBitmapData.rect, 
						new ColorTransform(1, 1, 1, 1, 0, 0, 0, -4));
			
			
			var mat:Matrix = new Matrix();
			mat.translate(_center.x, _center.y);
			afterBitmapData.draw(_center, mat);
		}
	}
}



import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.BlendMode;
import flash.display.Graphics;
import flash.display.Sprite;
import flash.filters.ColorMatrixFilter;
import flash.geom.Point;

import frocessing.color.ColorRGB;

class ColoredImage extends Sprite {
	
	public static var ACC_PARAM:Number = 0.1;
	public static var VELOCITY_PARAM:Number = 0.7
	
	private var _ix:Number;
	private var _iy:Number;
	private var _vx:Number = 0;
	private var _vy:Number = 0;
	private var _ax:Number = 0;
	private var _ay:Number = 0; 
	
	private var _img:Bitmap;
	
	public function ColoredImage(image:BitmapData, r:Number, g:Number, b:Number) {
		_img = addChild(new Bitmap(image)) as Bitmap;
		_img.x = -_img.width / 2;
		_img.y = -_img.height / 2;
		_img.filters = [
			new ColorMatrixFilter([
				r, 0, 0, 0, 0,
				0, g, 0, 0, 0,
				0, 0, b, 0, 0,
				0, 0, 0,0.25, 0
			])
		];
		_img.blendMode = BlendMode.ADD;
	}
	
	public function init(ix:Number, iy:Number):void {
		x = _ix = ix;
		y = _iy = iy;
		_img.x -= ix;
		_img.y -= iy;
	}
	
	public function addForce(ax:Number, ay:Number):void {
		_ax += ax + Math.random() * 8-4
		_ay += ay + Math.random() * 8-4
	}
	
	public function update():void {
		_ax += (_ix - x) * ACC_PARAM;
		_ay += (_iy - y) * ACC_PARAM;
		_vx = (_vx + _ax) * VELOCITY_PARAM;
		_vy = (_vy + _ay) * VELOCITY_PARAM;
		x += _vx;
		y += _vy;
		_ax = _ay = 0;
	}
	
	public function get ix():Number {
		return _ix;
	}
	
	public function get iy():Number {
		return _iy;
	}
	
	public function get initPos():Point {
		return new Point(_ix, _iy);
	}
}