/**
 * Copyright asfgu ( http://wonderfl.net/user/asfgu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wvfw
 */

/*
　試験的な召喚プログラム
　円を描く事によって円を召喚するプログラムです。
　画面上に存在する８つの小さな円を通る事によって円を形成します。
　マウスを←クリックしたまま、一筆書きで円を書いてください。
　通過した円は消滅します。
　実は、８つの円を通ればいいので、実際は円でなくても、
　８つの円さえ消せれば円を召喚出来てしまう。
*/
package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    
    [SWF(width="500", height="500")] 
    
    public class Main extends Sprite {
    		
    		private var circle:MakeCirc;

    		public function Main() {
    			circle = new MakeCirc();
    			stage.addChild(circle);
		}
    }
}

import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.events.TimerEvent;
import flash.geom.Point;
import flash.utils.Timer;

class MakeCirc extends Sprite {
	
	private var circ1:Sprite;
	private var circ2:Sprite;
	private var circ3:Sprite;
	private var circ4:Sprite;
	private var circ5:Sprite;
	private var circ6:Sprite;
	private var circ7:Sprite;
	private var circ8:Sprite;
	private var circr:Sprite = new Sprite();
	private var base:Sprite;
	private var flgr:Sprite;
	private var draw:Sprite;
	
	private var alph:Number  = 1;
	
	private var prev:Point = new Point();
	
	private var flashTimer:Timer;
	
	public function MakeCirc(){
		init();
    	}
    	
    	public function init():void{
    		var x:int =  0;
    		
    		flgr = new Sprite();
		flgr.graphics.beginFill(0xFFFFFF);
		flgr.graphics.drawRect(0, 0, 500, 500);
		flgr.graphics.endFill();
		addChild(flgr);
			
		base = new Sprite();
		base.graphics.beginFill(0x0000);
		base.graphics.drawRect(0, 0, 500, 500);
		base.graphics.endFill();
		addChild(base);
		
    		base.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
    		base.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
    		
    		flashTimer = new Timer(100);
    		flashTimer.addEventListener(TimerEvent.TIMER, flash);
    		
    		circ1 = new Sprite();
		drawCirc(20, 240, circ1);
   		
   		circ2 = new Sprite();
		drawCirc(87, 87, circ2);
   			
   		circ3 = new Sprite();
		drawCirc(250, 20, circ3);
   			
   		circ4 = new Sprite();
		drawCirc(413, 87, circ4);
   			
   		circ5 = new Sprite();
		drawCirc(480, 240, circ5);
   		
   		circ6 = new Sprite();
		drawCirc(413, 403, circ6);
   		
   		circ7 = new Sprite();
		drawCirc(250, 480, circ7);
   		
   		circ8 = new Sprite();
		drawCirc(87, 403, circ8);	
    	}
    	
    	private function flash(event:TimerEvent):void{
    		if(contains(flgr)){
    			removeChild(flgr);
    			base.graphics.beginFill(0xFF0000);
			base.graphics.drawCircle(250, 250, 240);
			base.graphics.endFill();
    		}
    		
    		if(alph > 0){
    			flgr.alpha = alph;	
    			alph = alph - 0.1;	
    		}
    		else{
    			flgr.alpha = alph;
    			flashTimer.stop();
    		}
    		
    		flgr.graphics.beginFill(0xFFFFFF);
		flgr.graphics.drawRect(0, 0, 500, 500);
		flgr.graphics.endFill();
		addChild(flgr);
    	}
    	
    	private function reload():void{
    		base.removeEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
    		base.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
    		removeChild(base);
    		init();
    	}
    	
    	private function drawCirc(x:int, y:int, cir:Sprite):void{
    		cir.graphics.beginFill(0xFF0000);
		cir.graphics.drawCircle(x, y, 40);
		cir.graphics.endFill();
   		base.addChild(cir);
    	}
    	
    	private function onMouseMove(event:MouseEvent):void{
		draw.graphics.lineStyle(8.0, 0xFFFFFF);
		draw.graphics.moveTo(prev.x, prev.y);
		draw.graphics.lineTo(mouseX, mouseY);
 
		prev.x = mouseX;
		prev.y = mouseY;
	}
	
    	private function onMouseUp(event:MouseEvent):void{
    		base.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
		circ1.removeEventListener(MouseEvent.ROLL_OVER, onMouseRollover1);
		circ2.removeEventListener(MouseEvent.ROLL_OVER, onMouseRollover2);
		circ3.removeEventListener(MouseEvent.ROLL_OVER, onMouseRollover3);
		circ4.removeEventListener(MouseEvent.ROLL_OVER, onMouseRollover4);
		circ5.removeEventListener(MouseEvent.ROLL_OVER, onMouseRollover5);
		circ6.removeEventListener(MouseEvent.ROLL_OVER, onMouseRollover6);
		circ7.removeEventListener(MouseEvent.ROLL_OVER, onMouseRollover7);
		circ8.removeEventListener(MouseEvent.ROLL_OVER, onMouseRollover8);
		base.removeChild(draw);
		
		if(base.numChildren == 0){		
			base.addChild(circr);
			flashTimer.start();
			removeChild(flgr);
		}
		else{
			reload();
		}
	}
		
    	private function onMouseDown(event:MouseEvent):void{
    		base.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
    		circ1.addEventListener(MouseEvent.ROLL_OVER, onMouseRollover1);
    		circ2.addEventListener(MouseEvent.ROLL_OVER, onMouseRollover2);
    		circ3.addEventListener(MouseEvent.ROLL_OVER, onMouseRollover3);
    		circ4.addEventListener(MouseEvent.ROLL_OVER, onMouseRollover4);
		circ5.addEventListener(MouseEvent.ROLL_OVER, onMouseRollover5);
		circ6.addEventListener(MouseEvent.ROLL_OVER, onMouseRollover6);
		circ7.addEventListener(MouseEvent.ROLL_OVER, onMouseRollover7);
		circ8.addEventListener(MouseEvent.ROLL_OVER, onMouseRollover8);
		
		draw = new Sprite();
		base.addChild(draw);
    		prev.x = mouseX;
		prev.y = mouseY;
    	}
    	
    	private function onMouseRollover1(event:MouseEvent):void{	
	    	circ1.removeEventListener(MouseEvent.ROLL_OVER, onMouseRollover1);
	   	base.removeChild(circ1);
	}
	private function onMouseRollover2(event:MouseEvent):void{	
		circ2.removeEventListener(MouseEvent.ROLL_OVER, onMouseRollover2);
	   	base.removeChild(circ2);	
	}	
	private function onMouseRollover3(event:MouseEvent):void{	
		circ3.removeEventListener(MouseEvent.ROLL_OVER, onMouseRollover3);
	   	base.removeChild(circ3);	
	}
	private function onMouseRollover4(event:MouseEvent):void{	
		circ4.removeEventListener(MouseEvent.ROLL_OVER, onMouseRollover4);
	   	base.removeChild(circ4);	
	}	
	private function onMouseRollover5(event:MouseEvent):void{	
		circ5.removeEventListener(MouseEvent.ROLL_OVER, onMouseRollover5);
	   	base.removeChild(circ5);	
	}
	private function onMouseRollover6(event:MouseEvent):void{	
		circ6.removeEventListener(MouseEvent.ROLL_OVER, onMouseRollover6);
	   	base.removeChild(circ6);	
	}
	private function onMouseRollover7(event:MouseEvent):void{	
		circ7.removeEventListener(MouseEvent.ROLL_OVER, onMouseRollover7);
	   	base.removeChild(circ7);	
	}
	private function onMouseRollover8(event:MouseEvent):void{	
		circ8.removeEventListener(MouseEvent.ROLL_OVER, onMouseRollover8);
	   	base.removeChild(circ8);	
	}				
}

