/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wve5
 */






package 
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.ui.*
    import flash.filters.BlurFilter
    import flash.filters.GlowFilter
    import com.greensock.*
    import com.greensock.easing.*  
    import net.hires.debug.Stats
      
    [SWF(width="470", height="470", frameRate="60", backgroundColor="#ffffff")]
    
    
    public class Sketch extends Sprite 
    {
        public  const SW:Number  = stage.stageWidth
        public  const SH:Number  = stage.stageHeight
        public  var canvas:Bitmap;
        public  var originalBD:BitmapData;
        public  var rgbBD:BitmapData;
        public  var rBD:BitmapData;
        public  var gBD:BitmapData;
        public  var bBD:BitmapData;        
        public  var rDig:Number;
        public  var gDig:Number;
        public  var bDig:Number;
        private var blurr:BlurFilter  = new BlurFilter( 10,10,3 )
        private var gloww:GlowFilter = new GlowFilter( 0xCCCCCC,10,10,3 )

        public function Sketch() 
        {
            addEventListener(Event.ADDED_TO_STAGE, initialize);
            addEventListener(Event.REMOVED_FROM_STAGE, uninitialize);
            addEventListener(Event.ENTER_FRAME, enterframe);
        }
        private function initialize(e:Event):void 
        {
            rgbBD = new BitmapData(stage.stageWidth, stage.stageHeight, true);
            originalBD = new BitmapData(stage.stageWidth, stage.stageHeight, true);
            rBD = new BitmapData(stage.stageWidth, stage.stageHeight, true);
            gBD = new BitmapData(stage.stageWidth, stage.stageHeight, true);
            bBD = new BitmapData(stage.stageWidth, stage.stageHeight, true);
            rDig = 0;
            gDig = 0;
            bDig = 0;

            var s:Sprite = new Sprite();
            var radius:int = 100;
            s.graphics.beginFill(0x000000);
            s.graphics.drawCircle(0, 0, radius);
            s.graphics.drawCircle(0, 0, radius - radius / 2);
            s.graphics.endFill();
            s.x = stage.stageWidth / 2;
            s.y = stage.stageHeight / 2;
            addChild(s);
            originalBD.draw(this);
            removeChild(s);
            rgbBD.copyPixels(originalBD, originalBD.rect, new Point(0, 0));
            canvas = new Bitmap(rgbBD, PixelSnapping.AUTO, true);
            addChild(canvas);
        }
        private function uninitialize(e:Event):void 
        {
        }
        private function enterframe(e:Event):void 
        {
            rgbBD.copyPixels(originalBD, originalBD.rect, new Point(0, 0));
            var p:Point = new Point();
            var r:Rectangle = new Rectangle(rgbBD.rect.x, rgbBD.rect.y, rgbBD.rect.width, rgbBD.rect.height);
            var radius:uint = 15;
            // RED
            rDig += 11;
            rBD.copyPixels(rgbBD, r, p);
            rBD.scroll(Math.cos(Math.PI / 180 * rDig) * radius, Math.sin(Math.PI  /180 * rDig) * radius);
            // GREEN
            gDig += 13;
            gBD.copyPixels(rgbBD, r, p);
            gBD.scroll(Math.cos(Math.PI / 180 * gDig) * radius, Math.sin(Math.PI / 180 * gDig) * radius);
            // BLUE
            bDig += 17;
            bBD.copyPixels(rgbBD, r, p);
            bBD.scroll(Math.cos(Math.PI / 180 * bDig) * radius, Math.sin(Math.PI / 180 * bDig) * radius);
            rgbBD.copyChannel(rBD, r, p, BitmapDataChannel.RED, BitmapDataChannel.RED);
            rgbBD.copyChannel(gBD, r, p, BitmapDataChannel.GREEN, BitmapDataChannel.GREEN);
            rgbBD.copyChannel(bBD, r, p, BitmapDataChannel.BLUE, BitmapDataChannel.BLUE);
            
            this.filters = [ blurr ]
            this.blendMode = "add"
        }
    }
}