/**
 * Copyright milkmidi ( http://wonderfl.net/user/milkmidi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wv0l
 */

/*    
    Copyright (c) 2010 milkmidi    
    All rights reserved.
    http://milkmidi.com
    http://milkmidi.blogspot.com
*/
package {	
	import com.bit101.components.PushButton;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.utils.Dictionary;		
	import org.papervision3d.cameras.CameraType;
	import org.papervision3d.core.math.Number3D;	
	import org.papervision3d.core.utils.Mouse3D;
	import org.papervision3d.events.FileLoadEvent;
	import org.papervision3d.events.InteractiveScene3DEvent;
	import org.papervision3d.materials.*;		
	import org.papervision3d.materials.utils.MaterialsList;	
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.parsers.DAE;	
	import org.papervision3d.objects.primitives.*;	
	import org.papervision3d.view.BasicView;
	import org.papervision3d.view.layer.ViewportLayer;
	[SWF(width = "465", height = "465", frameRate = "41", backgroundColor = "#000000")]		
	public class DragPV3DObject extends BasicView {			
		private var currentDAE  :DisplayObject3D = null;		
		private var mouse3D:Mouse3D;
		private var _offset:Number3D;
		public function DragPV3DObject(){
			super(0, 0, true, true, CameraType.TARGET);																
			camera.y = 300;				
			initObject();
			init3DObjects();
			startRendering();			
		}			
		private function initObject():void{			
			new PushButton(this , 0, 0, "addModel" , addDAEClickHandler);
		}		
		private function addDAEClickHandler(e:MouseEvent):void{
			addDAE();
		}
		private function init3DObjects():void {		
			viewport.interactive = true;			
			mouse3D = viewport.interactiveSceneManager.mouse3D;
			Mouse3D.enabled = true;
			
			addDAE();
			var _wireMat:ColorMaterial = new ColorMaterial();
			_wireMat.interactive = true;
			var _plane:Plane = new Plane(_wireMat, 3000, 3000, 4, 4);			
			_plane.rotationX = 90;
			scene.addChild(_plane);
		}
		private function addDAE():void {										
			var _dae:Sphere = new Sphere(new ColorMaterial(Math.random()*0xffffff));							
			scene.addChild(_dae);
			var _layer:ViewportLayer = _dae.createViewportLayer(viewport, false);	
			_layer.addEventListener(MouseEvent.MOUSE_DOWN , layerMouseDownHandler);
		}		
		private function layerMouseDownHandler(e:MouseEvent):void {			
			currentDAE = ViewportLayer(e.currentTarget).displayObject3D;
			stage.addEventListener(MouseEvent.MOUSE_UP , stageMouseUpHandler);
			_offset = new Number3D( currentDAE.x - mouse3D.x , currentDAE.y - mouse3D.y , currentDAE.z - mouse3D.z );
		}		
		private function stageMouseUpHandler(e:MouseEvent):void {
			stage.removeEventListener(MouseEvent.MOUSE_UP , stageMouseUpHandler);
			currentDAE = null;
		}
		override protected function onRenderTick(event:Event = null):void {
			if (currentDAE != null) {							
				currentDAE.x = mouse3D.x + _offset.x;
				currentDAE.z = mouse3D.z + _offset.z;						
			}			
			camera.x = (-viewport.mouseX * 3) / 2;
            camera.y = viewport.mouseY * 3;	
			super.onRenderTick(event);
		}		
	}
}

