/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wuzG
 */

// forked from siouxcitizen's Bitmap練習03：芝生・砂・水のBitmap画像貼りつけ練習
//
//配列データ指定によるBitmap画像貼りつけ練習
//
//そもそもBitmapの理解がなってないっぽいので基本的なことから練習中です、その４
//配列データで指定された情報を読み取って、Bitmap画像を3DPlaneオブジェクトにはりつけるように変更しました
//
package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.display.Loader;
    import flash.system.LoaderContext;
    import flash.display.Bitmap;
    import flash.display.BitmapData; 
    import org.papervision3d.view.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.materials.*;
    public class Main extends BasicView
    {
        private var count:int = 0;    // 読み込んだ画像数
        private var images:Array;    // 読み込んだ画像
        private var bitmapDataList:Array;    // 読み込んだ画像のBitmapData
        private var bmp:Bitmap;
        private var bmd:BitmapData;
        private const MAP_DATA:Array = 
            [[ 2, 2, 2, 2, 2, 2, 2, 2, 2],
             [ 2, 1, 1, 1, 1, 1, 1, 1, 2],
             [ 2, 1, 1, 1, 1, 1, 1, 1, 2],
             [ 2, 1, 1, 0, 0, 0, 1, 1, 2],
             [ 2, 1, 1, 0, 2, 0, 1, 1, 2],
             [ 2, 1, 1, 0, 0, 0, 1, 1, 2],
             [ 2, 1, 1, 1, 1, 1, 1, 1, 2],
             [ 2, 1, 1, 1, 1, 1, 1, 1, 2],
             [ 2, 2, 2, 2, 2, 2, 2, 2, 2]]; //0:芝生Bitmap指定、1:砂Bitmap指定、2:水Bitmap指定
        private const IMAGE_URL:Array =
        [
            "http://assets.wonderfl.net/images/related_images/5/55/558c/558cd91da870c2bc32c54502d98d2d447833e1fd",
            "http://assets.wonderfl.net/images/related_images/0/02/0210/02104ec89c3ba9dd49dc3e636d3e97a8d55674f8",
            "http://assets.wonderfl.net/images/related_images/f/f6/f696/f696b4e7bc2541a9812b81fe89a27a1c00fbe447"
        ];
 
        public function Main()
        {
            images = new Array(IMAGE_URL.length);
 
            for (var i:int = 0; i < IMAGE_URL.length; i++)
            {
                var loader:Loader = new Loader();
                loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete);
                loader.load(new URLRequest(IMAGE_URL[i]), new LoaderContext(true));
                loader.name = i.toString();
            }
        }
 
        private function onComplete(e:Event):void
        {
            bmp = new Bitmap();
            bmd = new BitmapData(e.currentTarget.loader.width, e.currentTarget.loader.height, true, 0x000000)
            bmd.draw(e.currentTarget.loader);
            bmp.bitmapData = bmd;
            images[e.currentTarget.loader.name] = bmp;           
            if (++count == IMAGE_URL.length) display();
        }
 
        private function display():void
        {
            for (var j:int = 0; j < MAP_DATA.length; j++) {
                var horizontalMapData:Array = MAP_DATA[j];
                for (var i:int = 0; i < horizontalMapData.length; i++) {
                    var mapData:int = horizontalMapData[i]
                    var bmp:Bitmap = images[mapData];
                    var material:BitmapMaterial = new BitmapMaterial(bmp.bitmapData, true);

                    var plane:Plane = new Plane(material, 500, 500, 1, 1);
                    plane.rotationX = 90;
                    plane.z = -2000 + 500*j;
                    plane.x = -2000 + 500*i;
                    scene.addChild(plane); //sceneに追加
                }
            }

            //カメラ設定
            camera.y = 2800;
            camera.z = 7000;
            camera.zoom = 80;
            //レンダリング開始
            startRendering();
            //loop処理
            addEventListener(Event.ENTER_FRAME, loop);
        }

        private function loop(e:Event):void{
        }
    }
}
 