/**
 * Copyright smallflowergame ( http://wonderfl.net/user/smallflowergame )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wuqN
 */

// forked from millstones's particleみたいなもの
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    import flash.utils.Timer;
    
    //KTween
    import net.kawa.tween.KTween;
    import net.kawa.tween.easing.*;
    import net.kawa.tween.KTJob;
    
    //PV3D
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.special.Letter3DMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.core.geom.renderables.Pixel3D;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.typography.Font3D;
    import org.papervision3d.typography.fonts.HelveticaBold;
    import org.papervision3d.typography.Text3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.core.geom.Lines3D;
    import org.papervision3d.materials.special.LineMaterial;
    
    [SWF(backgroundColor=0x000000, width=640, height = 360, frameRate=30)]
    
    public class Main extends Sprite {
        //別に使わないけど一応
        private var _frameCount     :uint;
        
        //PV3D関係の色々
        private var _viewport       :Viewport3D;
        private var _scene          :Scene3D;
        private var _camera         :Camera3D;
        private var _renderer       :BasicRenderEngine;
        
        //パーティクルで使う文字とカラー配列
        private const cParticleString :String = "1234567890*";
        private const cWarm:Array = [0xff130f,0xff4e0f,0xff7b0f,0xffa70f,0xffd20f,0xfff40f];
        private const cCold:Array = [0x660fff,0x300fff,0x0f2aff,0x0f68ff,0x0f9fff,0x0fc8ff];
        
        public function Main() {
            init();
        }
        private function init():void {
            //PV3D関係の色々をイニシャライズ
            _viewport = new Viewport3D(640,360);
            _scene = new Scene3D();
            _camera = new Camera3D();
            _renderer = new BasicRenderEngine();
            
            //斜に構える
            _camera.x = -1000;
            _camera.y = 100;
            _camera.z = -700;
            _camera.rotationX = 10;
            _camera.rotationY = 30;
            
            //パーティクル生成タイマー
            var particleTimer:Timer = new Timer(150);
            particleTimer.addEventListener(TimerEvent.TIMER, makeParticle );
            particleTimer.start();
            
            addChild(_viewport);
            addEventListener(Event.ENTER_FRAME, action);
        }
        
        //パーティクル作る
        private function makeParticle(e:TimerEvent):void {
            var job:KTJob;
            //文字
            var lm:Letter3DMaterial = new Letter3DMaterial(0xffffff);
            lm.doubleSided = true;
            var font:HelveticaBold = new HelveticaBold();
            var text:Text3D = new Text3D((cParticleString.charAt(Math.floor(Math.random() * cParticleString.length))), font, lm);
            text.useOwnContainer = true;
            text.scale = 0.3;
            var blur:BlurFilter = new BlurFilter(0, 0, 1);
            text.filters.push(blur);
            text.filters.push(new GlowFilter(0xffffff,1,2,2));
            job = KTween.to(text, 3+Math.random() , { x:-1500,y:Math.random()*100-50,z:Math.random()*100-50,alpha:0.0,scale :2},Quad.easeIn, disposeParticles);
            job.onCloseParams = [text];
            KTween.to(blur, 3 +Math.random() , { blurX : 8,blurY : 8},Linear.easeOut).round = true;
            KTween.to(text, 3 +Math.random(), { rotationX : Math.random()*720-360,rotationY : Math.random()*720-360,rotationZ : Math.random()*720-360},Linear.easeOut).round = true;
            _scene.addChild(text);
            
            //バックファイア的な暖色系
            var color:uint = cWarm[Math.floor(Math.random() * cWarm.length)];
            var cm:ColorMaterial = new ColorMaterial(color , Math.random());
            cm.doubleSided = true;
            var dot:Plane = new Plane(cm,10,10);
            dot.useOwnContainer = true;
            job = KTween.to(dot, 5 , { x:-1900,alpha:0.0},Quad.easeIn, disposeParticles);
            job.onCloseParams = [dot];
            _scene.addChild(dot);
            
            //霧散する寒色系。一回で3枚
            for (var i:int = 0; i < 4; i++ ) {
                color = cCold[Math.floor(Math.random()*cCold.length)];
                cm = new ColorMaterial(color , Math.random());
                cm.doubleSided = true;
                var plane:Plane = new Plane(cm,10+Math.random()*5,10+Math.random()*5);
                plane.useOwnContainer = true;
                plane.filters.push(new GlowFilter(color,.8));
                job = KTween.to(plane, 4 + Math.random() , { x:-1900,y:Math.random()*400-200,z:Math.random()*400-200,alpha:0.0},Quad.easeIn, disposeParticles);
                job.onCloseParams = [plane];
                KTween.to(plane, 4 + Math.random(), { 
                    rotationX : Math.random() * 720 - 360,
                    rotationY : Math.random() * 720 - 360,
                    rotationZ : Math.random() * 720 - 360},Linear.easeOut).round = true;
                _scene.addChild(plane);
            }
        }
        //Tween終わったら破棄
        private function disposeParticles(particle:DisplayObject3D):void{
            _scene.removeChild(particle);
        }
        
        private function action(e:Event):void {
            _renderer.renderScene(_scene, _camera, _viewport);
            _frameCount++;
        }
    }
}