/**
 * Copyright fakestar0826 ( http://wonderfl.net/user/fakestar0826 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wuBB
 */

// forked from fakestar0826's DraggingSegment
// forked from fakestar0826's ReachingSegment
// forked from fakestar0826's SingleSegment
package {
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite 
    {
        private var segments:Array;
        private var numSeg:int = 100;
        
        public function FlashTest() {
            // write as3 code here..
            segments = [];
            
            for(var i:int = 0;i < numSeg;i++)
            {
                var seg:Segment = new Segment(10, 20);
                addChild(seg);
                segments.push(seg);
            }
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void
        {
            drag(segments[0], mouseX, mouseY);
            for(var i:int = 1;i < numSeg;i++)
            {
                var seg:Segment = segments[i];
                var seg1:Segment = segments[i - 1];
                drag(seg, seg1.x, seg1.y);
            }
        }
        
        private function drag(seg:Segment, xpos:Number, ypos:Number):void
        {
            var dx:Number = xpos - seg.x;
            var dy:Number = ypos - seg.y;
            var angle:Number = Math.atan2(dy, dx);
            seg.rotation = angle * 180 / Math.PI;
            
            var w:Number = seg.getPin().x - seg.x;
            var h:Number = seg.getPin().y - seg.y;
            seg.x = xpos - w;
            seg.y = ypos - h;
            
        }


    }
}
import flash.geom.Point;
import flash.display.Sprite;

class Segment extends Sprite
{
    private var color:uint;
    private var segmentWidth:Number;
    private var segmentHeight:Number;
    
    public var vx:Number = 0;
    public var vy:Number = 0;
    
    public function Segment(segmentWidth:Number, segmentHeight:Number, color:uint = 0xFFFFFF)
    {
        this.segmentWidth = segmentWidth;
        this.segmentHeight = segmentHeight;
        this.color = color;
        
        graphics.lineStyle(0);
        graphics.beginFill(color);
        graphics.drawRoundRect(-segmentHeight / 2, -segmentHeight / 2, segmentWidth + segmentHeight, segmentHeight, segmentHeight, segmentHeight);
        graphics.endFill();
        
        graphics.drawCircle(0, 0, 2);
        graphics.drawCircle(segmentWidth, 0, 2);
    }
    
    public function getPin():Point
    {
        var angle:Number = rotation * Math.PI / 180;
        var xPos:Number = x + Math.cos(angle) * segmentWidth;
        var yPos:Number = y + Math.sin(angle) * segmentWidth;
        
        return new Point(xPos, yPos);
    }


}
