/**
 * Copyright Seiya.Kai ( http://wonderfl.net/user/Seiya.Kai )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wtva
 */

package
{
    import flash.display.Sprite;
    
    [SWF(width="800",height="800",frameRate="60")]
    
    public class Main06 extends Sprite
    {
        public function Main06()
        {
            var sm:SpriteMovie = new SpriteMovie();
            sm.x = 20;
            sm.y = 20;
            addChild(sm);
            
            var sm_2:Sprite;
            var sm_3:Sprite;
            
            for (var i:int = 0; i < 5; i++) 
            {
                for (var j:int = 0; j < 5; j++) 
                {
                    sm_2 = new SpriteMatrix(sm,50,50,i*-50,j*-50,false);
                    sm_2.x = 400 + i * 55;
                    sm_2.y = 10 + j * 55;
                    addChild(sm_2);
                    
                    sm_3 = new SpriteMatrix(sm,50,50,i*-50,j*-50,true);
                    sm_3.x = 200 + i * 55;
                    sm_3.y = 400 + j * 55;
                    addChild(sm_3);
                    
                }
            }
            
        }
    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.Matrix;

class SpriteMovie extends Sprite
{
    private var c:Sprite = new Sprite();
    private var r:Sprite = new Sprite();
    private var vx:Number = 5, vy:Number = 4;
    private var circleSize:Number = 60;
    private var rectSize:Number = 250;
    
    public function SpriteMovie(){
        r.graphics.beginFill(0x0099FF);
        r.graphics.lineStyle(5, 0x0000FF);
        r.graphics.drawRect(0, 0, rectSize, rectSize);
        r.graphics.endFill();
        
        c.graphics.beginFill(0xFFFF00);
        c.graphics.drawCircle(0, 0, circleSize);
        c.graphics.endFill();
        
        addChild(r);
        addChild(c);
        c.x = 100;
        c.y = 100;
        
        c.addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    
    private function onEnterFrame(e:Event):void{
        
        c.x += vx;
        c.y += vy;
        
        if(c.x < circleSize) 
        {
            vx *= -0.9;
            c.x = circleSize; 
        }
        if(c.x > rectSize-circleSize)
        {
            vx *= -0.9; 
            c.x = rectSize-circleSize;
        }
        if(c.y < circleSize)  
        { 
            vy *= -0.9; 
            c.y = circleSize; 
        }
        if(c.y > rectSize-circleSize){
            vy *= -0.9;
            c.y = rectSize-circleSize; 
        }
    }
}

class SpriteMatrix extends Sprite
{
    private var image:Bitmap = new Bitmap();
    private var bmp:BitmapData;
    private var dx:int,dy:int;
    private var s:Sprite;
    private var option:Boolean;
    
    public function SpriteMatrix(s:Sprite,bmpWidth:int,bmpHeight:int,dx:int,dy:int,option:Boolean=false)
    {
        bmp = new BitmapData(bmpWidth,bmpHeight,true,0x00FF00);
        
        this.dx = dx;
        this.dy = dy;
        this.option = option;
        
        image.bitmapData = bmp;
        addChild(image);
        this.s = s;
        
        addEventListener(Event.ENTER_FRAME,onEnterFrame);
        addEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
        addEventListener(MouseEvent.MOUSE_UP,onMouseUp);
    }
    
    private function onEnterFrame(e:Event):void
    {
        if(option)
        {
            x += Math.round(Math.random()*2) - 1;
            y += Math.round(Math.random()*2) - 1;
        }
        
        var mat:Matrix = new Matrix();
        mat.translate(dx,dy);
        bmp.draw(s,mat);
    }
    
    private function onMouseDown(e:MouseEvent):void
    {
        startDrag();    
    }
    
    private function onMouseUp(e:MouseEvent):void
    {
        stopDrag();
    }
}