/**
 * Copyright makc3d ( http://wonderfl.net/user/makc3d )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wtXv
 */

// easier version for those who complained :)
package {
	import com.bit101.components.HBox;
	import com.bit101.components.Label;
	import com.bit101.components.ProgressBar;
	import com.bit101.components.VSlider;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.LoaderInfo;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.ProgressEvent;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.utils.ByteArray;
	import flash.utils.setTimeout;
    import flash.text.TextField;
    import net.wonderfl.utils.WonderflAPI;
	/**
	 * I have seen this game years ago somewhere,
	 * it was limited to european cities and thus easier to play :)
	 * 
	 * The idea is to click as close to the city as you can.
	 */
	[SWF(width=465,height=465,backgroundColor=0x7F)]
	public class GeoDarts extends Sprite {
		private var mapImage:BitmapData;
		private var map:Sprite;
		private var cityList:Vector.<City>;
		private var progress:ProgressBar;
		private var prompt:Label, promptMini:Label;
		private var zoom:VSlider;
		private var n:int, m:int;
		private var red:CitySprite, green:CitySprite;
		private var spot:City;
		private var score:int;
		public function GeoDarts () {
			(progress = new ProgressBar (this, 100, 300)).width = 265;
			// load map and cities data
			// vector data can be found at http://wonderfl.net/c/1D8L
			// city list can be found at http://www.world-gazetteer.com/
			var loader:URLLoader = new URLLoader;
			loader.dataFormat = "binary";
			loader.addEventListener (ProgressEvent.PROGRESS, onDataProgress);
			loader.addEventListener (Event.COMPLETE, onDataLoaded);
			loader.load (new URLRequest (/*"7235-110718-288983.gif"*/"http://assets.wonderfl.net/images/related_images/7/74/74a7/74a7456bffa7ed1d7096f2e23c1cbaa29dafc7d1"));
		}

		private function onDataProgress (e:ProgressEvent):void {
			progress.value = e.bytesLoaded / e.bytesTotal;
		}

		private function onDataLoaded (e:Event):void {
			removeChild (progress);

			map = new Sprite; addChild (map);
			mapImage = new BitmapData (200, 100, false, 0x7F);
			map.graphics.beginBitmapFill (mapImage, new Matrix (1.8, 0, 0, 1.8), true, true);

			var data:ByteArray = ByteArray (URLLoader (e.target).data);

			data.position = 7235;
			var lines:Array = data.readUTFBytes (110718).split ("\n");
			var x0:Number = -1e6;
			var y0:Number = -1e6;
			for each (var line:String in lines) {
				var a:Array = line.match (/\s*([\-\d\.]+)\s+([\-\d\.]+)\s*/);
				if (a) {
					var x1:Number = 180 + parseFloat (a[1]);
					var y1:Number =  90 - parseFloat (a[2]);
					// no penguins allowed
					if (y1 > 150) continue;
					var d:Number = (x0 - x1) * (x0 - x1) + (y0 - y1) * (y0 - y1);
					if (d > 30) {
						map.graphics.moveTo (x1, y1);
					} else {
						map.graphics.lineTo (x1, y1);
					}
					x0 = x1;
					y0 = y1;
				}
			}

			var kml:XML = new XML (data.readUTFBytes (288983));
			var ns:Namespace = kml.namespaceDeclarations () [0];
			var placemarks:XMLList = kml.ns::Document.ns::Placemark;
			cityList = new Vector.<City>;
			for each (var placemark:XML in placemarks) {
				var city:City = new City;
				city.name = replaceStupidCharacters (placemark.ns::name);
				a = String (placemark.ns::description).match (/population:\s(\d+)<br>division:\s([^<]+)</);
				city.population = a [1];
				city.country = a [2];
				a = String (placemark.ns::Point.ns::coordinates).split (",");
				city.lat = parseFloat (a [0]);
				city.lon = parseFloat (a [1]);
				// city threshold upped to 3M
				if (parseInt (city.population) > 3e6) cityList.push (city);
			}

			data.position = 0;
			var loader:Loader = new Loader;
			loader.contentLoaderInfo.addEventListener (Event.COMPLETE, onImageLoaded);
			loader.loadBytes (data);
		}

		private function onImageLoaded (e:Event):void {
			var info:LoaderInfo = LoaderInfo (e.target);
			mapImage.draw (info.content);

			addChild (red = new CitySprite (0xFF0000)).visible = false;
			addChild (green = new CitySprite (0xFF00)).visible = false;

			zoom = new VSlider (this, 20, 20);
			zoom.y = 465 - zoom.height - zoom.y;

			promptMini = new Label (this, 40, 432);
			promptMini.textField.textColor = 0xFFFFFF;

			prompt = new Label (this, 34, promptMini.y - 55);
			prompt.scaleX = 4; prompt.scaleY = 4;
			prompt.textField.textColor = 0xFFFFFF;

			n = 10; pickCity (); spot = new City; score = 0;

			stage.addEventListener (MouseEvent.MOUSE_MOVE, render);
			map.addEventListener (MouseEvent.CLICK, onMapClick);

			render ();
		}

		private function render (e:MouseEvent = null):void {
			var s:Number = (465 / 180) * (1 + 0.03 * zoom.value);
			map.scaleX = s;
			map.scaleY = s;
			map.x = (465 - 360 * s) * mouseX / 465;
			map.y = (465 - 180 * s) * mouseY / 465;
			showCitySpriteAt (red, spot);
			showCitySpriteAt (green, cityList [m]);
		}

		private function onMapClick (e:MouseEvent):void {
			if (red.visible) return;

			spot.lat = e.localX - 180;
			spot.lon = 90 - e.localY;

			render ();

			red.visible = true;
			green.visible = true;

			// round distance down to 50 km precision
			var ms:Number = distSphere (spot.lat, spot.lon, cityList [m].lat, cityList [m].lon);
			var kms50:int = ms / 5e4;

			score += kms50 * 50;

			prompt.text = (kms50 * 50) + "km!";
			promptMini.text = cityList [m].name + ", " + cityList [m].country +
				", population: " + cityList [m].population + " people";

			if (n > 0) {
				setTimeout (nextIteration, 4000);
			} else {
				setTimeout (gameOver, 4000);
			}
		}

		private function nextIteration ():void {
			red.visible = false;
			green.visible = false;
			pickCity ();
			render ();
		}

		private function gameOver ():void {
			stage.removeEventListener (MouseEvent.MOUSE_MOVE, render);
			map.removeEventListener (MouseEvent.CLICK, onMapClick);
			removeChild (map);
			removeChild (red);
			removeChild (green);
			removeChild (prompt);
			removeChild (promptMini);
			removeChild (zoom);

            var obj: Object = loaderInfo.parameters;
            var window: ScoreWindow = makeScoreWindow(new WonderflAPI(obj), score, "Your result", 1, "I got 10 cities with %SCORE% km error!");
            addChild(window);
		}

		private function pickCity ():void {
			do {
				m = Math.round (Math.random () * (cityList.length - 1));
			} while (cityList [m].used);
			cityList [m].used = true;

			prompt.text = n + ". " + cityList [m].name + ", " + cityList [m].country;
			promptMini.text = "Click on the map as close to the city as you can!";

			n--;
		}

		private function showCitySpriteAt (sprite:CitySprite, city:City):void {
			var pt:Point = map.localToGlobal (new Point (180 + city.lat, 90 - city.lon));
			sprite.x = pt.x;
			sprite.y = pt.y;
		}

		private function replaceStupidCharacters (s:String):String {
			// minicomponents font only has ascii :(
			var from:String = "ĀảáāãâçěéŏăĠōóøòöİīíłŌŞşŢţŬūŭų̨̨̨̨̨̨̨̨̨̨̨̱̱̱̱̱̱̱̱̱̱̱̱̈";
			var to:String   = "AaaaaaceeeeGoooooIiilOSsTtUuuu''";
			for (var i:int = 0; i < from.length; i++) {
				var j:int = s.indexOf (from.charAt (i));
				if (j > -1) {
					s = s.substr (0, j) + to.charAt (i) + s.substr (j + 1);
				}
			}
			return s;
		}

		private function distSphere (lat1:Number, lon1:Number, lat2:Number, lon2:Number):Number {
			var a:Number = 6378137, b:Number = 6356752.3142,  f:Number = 1 / 298.257223563;  // WGS-84 ellipsoid params
			var r:Number = 0.5 * (a + b);

			var phi:Number /* -PI...+PI */ = toRad (lat1);
			var tet:Number /* 0...+PI */ = 0.5 * Math.PI - toRad (lon1);

			var x1:Number = Math.sin (tet) * Math.cos (phi);
			var y1:Number = Math.sin (tet) * Math.sin (phi);
			var z1:Number = Math.cos (tet);

			phi = toRad (lat2);
			tet = 0.5 * Math.PI - toRad (lon2);

			var x2:Number = Math.sin (tet) * Math.cos (phi);
			var y2:Number = Math.sin (tet) * Math.sin (phi);
			var z2:Number = Math.cos (tet);

			var dot:Number = x1 * x2 + y1 * y2 + z1 * z2;
			var ang:Number = Math.abs (Math.acos (dot));

			return ang * r;
		}

		private function toRad (v:Number):Number {
			return v * Math.PI / 180;
		}
        
        /**
         * Wonderfl の Score API 用
         * ランキング表示から Tweet までをひとまとめにしたSWF素材
         * @param    api                : WonderflAPI
         * @param    score            : 取得スコア
         * @param    title            : (省略時: "GAME SCORE")ランキングのタイトル
         * @param    denominator        : (省略時: 1) 表示スコアに小数点が付く場合に使用する。
         *                 スコアが 1234 のとき、 100 に指定すると 12.34
         * @param    tweet            : (省略時はTweet無し) Twitter 連携をする時に文字列を指定すると
         *                それでつぶやかれる。%SCORE% という文字列が中にあるとそこがスコアと置き換わる。
         * @param    scoreTitle        : (省略時: SCORE)　スコアが何を意味するのか。例) LAP TIME
         * @param    addScoreAfter    : 表示スコアの後ろにつける単位などに、
         *                 例) [sec] と指定すると 12.34 [sec] のように表示される
         * @param    scoreLength        : (省略時: 99) スコア送信後に取得するランキング件数
         * @param    scoreDescend    : (省略時: 0) 降順昇順のフラグ
         *                 (1: 点数が高い順、0: 点数が低い順)
         * @param    modal            : (省略時: true) モーダル処理を入れるかどうか。
         */
        public function makeScoreWindow(
            api: WonderflAPI, score: int, title: String, denominator: int = 1, 
            tweet: String = null, scoreTitle: String = "SCORE", addScoreAfter: String = "",
            scoreLength: uint = 99, scoreDescend: uint = 0, modal: Boolean = true
        ): ScoreWindow
        {
            _api = api, _score = score, _title = title, _denominator = denominator, _tweet = tweet, _scoreTitle = scoreTitle, _addScoreAfter = addScoreAfter, _scoreLength = scoreLength, _scoreDescend = scoreDescend;
            return new ScoreWindow(modal);
        }
        
    }

}


class City {
	public var name:String;
	public var population:String;
	public var country:String;
	public var lat:Number = 0;
	public var lon:Number = 0;
	public var used:Boolean;
}

import com.bit101.components.Label;
import flash.display.Sprite;
class CitySprite extends Sprite {
	public var label:Label;
	public function CitySprite (color:uint) {
		graphics.beginFill (color);
		graphics.drawCircle (0, 0, 5);
		label = new Label (this);
	}
}

import com.adobe.serialization.json.JSON;
import com.bit101.components.InputText;
import com.bit101.components.Label;
import com.bit101.components.PushButton;
import com.bit101.components.Style;
import com.bit101.components.VScrollBar;
import flash.display.DisplayObject;
import flash.display.Graphics;
import flash.display.Loader;
import flash.display.Shape;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.MouseEvent;
import flash.filters.DropShadowFilter;
import flash.net.navigateToURL;
import flash.net.URLLoader;
import flash.net.URLRequest;
import flash.utils.escapeMultiByte;
import net.wonderfl.data.APIScoreData;
import net.wonderfl.data.ScoreData;
import net.wonderfl.data.WonderflAPIData;
import net.wonderfl.utils.WonderflAPI;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.easing.Quad;
import org.libspark.betweenas3.tweens.IObjectTween;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.tweens.ITweenGroup;
var _api: WonderflAPI, _score: int, _title: String, _denominator: int, _tweet: String, _scoreTitle: String, _addScoreAfter: String, _scoreLength: uint, _scoreDescend: uint;

/**
 * 閉じられた時に出力されます。
 */
[Event(name="close", type="flash.events.Event")]
class ScoreWindow extends Sprite
{
    function ScoreWindow( modal: Boolean = true )
    {
        this.modal = modal;
        if (_tweet) _tweet = _tweet.replace(/%SCORE%/g, (_score / _denominator));
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init);
    }
    private var modal: Boolean;
    private var modalSp: Sprite;
    
    private function init(e: Event = null): void 
    {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        var window: _ScoreWindow = new _ScoreWindow();
        window.closeHandler = onClose;
        window.x = stage.stageWidth  - window.width  >> 1;
        window.y = stage.stageHeight - window.height >> 1;
        if (modal) 
        {
            addChild(modalSp = new Sprite());
            var g: Graphics = modalSp.graphics;
            g.beginFill(0xCCCCCC, 0.5);
            g.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
        }
        addChild(window);
        stage.addEventListener(Event.RESIZE, onResize);
    }
    
    private function onResize(e:Event):void 
    {
        if (modal)
        {
            var g: Graphics = modalSp.graphics;
            g.clear();
            g.beginFill(0x333333, 0.3);
            g.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
        }
        var i: int;
        for (i = 0; i < numChildren; i++) 
        {
            var d: DisplayObject = getChildAt(i);
            d.x = stage.stageWidth  - d.width  >> 1;
            d.y = stage.stageHeight - d.height >> 1;
        }
    }
    
    private function onClose():void 
    {
        while (numChildren > 0) removeChildAt(0);
        stage.removeEventListener(Event.RESIZE, onResize);
        parent.removeChild(this);
        dispatchEvent(new Event(Event.CLOSE));
    }
}

class _ScoreWindow extends Sprite
{
    private var iconLoader: Loader, input: InputText, registBtn: PushButton, closeBtn: PushButton, tweetBtn: PushButton;
    private var tween: IObjectTween;
    public var closeHandler: Function;
    
    function _ScoreWindow()
    {
        alpha = 0;
        var bg: Shape = new Shape();
        var g: Graphics = bg.graphics;
        g.beginFill(0x777777);
        g.drawRoundRectComplex(0, 0,  280, 180, 5, 5, 5, 5);
        g.beginFill(0xFFFFFF);
        g.drawRoundRectComplex(1, 1,  278,  20, 5, 5, 0, 0);
        g.drawRoundRectComplex(1, 22, 278, 157, 0, 0, 5, 5);
        bg.filters = [new DropShadowFilter(2, 45, 0, 1, 16, 16)];
        addChild(bg);
        BackupStyle.styleSet();
        new Label(this, 5, 3, _title);
        iconLoader = new Loader();
        iconLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, onCompLoadIcon);
        iconLoader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, onIOErrorIcon);
        iconLoader.visible = false;
        iconLoader.x = 10, iconLoader.y = 60;
        addChild(iconLoader);
        new Label(this, 75,  65, _scoreTitle + " :");
        new Label(this, 75,  85, "PLAYER :");
        new Label(this, 150, 65, (_score / _denominator) + " " + _addScoreAfter);
        input = new InputText(this, 150, 85, _api.viewerDisplayName);
        iconLoader.load(new URLRequest(_api.viewerIconURL));
        if (_tweet) tweetBtn = new PushButton(this, 10, 150, "TWEET", onClickTweet);
        registBtn = new PushButton(this, _tweet ? 100 : 35, 150, "REGISTER", onClickRegist);
        closeBtn = new PushButton(this, _tweet ? 190 : 145, 150, "CANCEL", onClickCancel);
        if (tweetBtn) tweetBtn.width = registBtn.width = closeBtn.width = 80;
        else registBtn.width = closeBtn.width = 100;
        tween = BetweenAS3.to(this, { alpha: 1 }, 1);
        tween.play();
        BackupStyle.styleBack();
    }
    
    private function onIOErrorIcon(e:IOErrorEvent):void 
    {
        iconLoader.contentLoaderInfo.removeEventListener(Event.COMPLETE, onCompLoadIcon);
        iconLoader.contentLoaderInfo.removeEventListener(IOErrorEvent.IO_ERROR, onIOErrorIcon);
    }
    
    private function onCompLoadIcon(e:Event):void 
    {
        iconLoader.contentLoaderInfo.removeEventListener(Event.COMPLETE, onCompLoadIcon);
        iconLoader.contentLoaderInfo.removeEventListener(IOErrorEvent.IO_ERROR, onIOErrorIcon);
        iconLoader.scaleX = iconLoader.scaleY = 0.5;
        iconLoader.visible = true;
    }
    
    private function onClickCancel(e: Event):void 
    {
        if (tween.isPlaying) tween.stop();
        tween = BetweenAS3.to(this, { alpha: 0 } );
        tween.onComplete = close;
        tween.play();
        btnDisable();
    }
    
    private function btnDisable(): void
    {
        if (tweetBtn) tweetBtn.enabled = false;
        registBtn.enabled = closeBtn.enabled = false;
    }
    
    private function close(): void
    {
        while (numChildren > 0) removeChildAt(0);
        input = null;
        if (tweetBtn) tweetBtn.removeEventListener(MouseEvent.CLICK, onClickTweet);
        registBtn.addEventListener(MouseEvent.CLICK, onClickRegist);
        closeBtn.addEventListener(MouseEvent.CLICK, onClickCancel);
        tweetBtn = registBtn = closeBtn = null;
        var f: Function = closeHandler;
        closeHandler = null;
        iconLoader.contentLoaderInfo.removeEventListener(Event.COMPLETE, onCompLoadIcon);
        iconLoader.contentLoaderInfo.removeEventListener(IOErrorEvent.IO_ERROR, onIOErrorIcon);
        iconLoader.unloadAndStop();
        iconLoader = null;
        if (f != null) f();
        if (parent) parent.removeChild(this);
    }
    
    private function onClickRegist(e: Event):void 
    {
        if (input.text == "") return;
        btnDisable();
        var window: RankingWindow = new RankingWindow(input.text);
        window.x = stage.stageWidth  - window.width  >> 1;
        window.y = stage.stageHeight - window.height >> 1;
        window.closeHandler = closeHandler;
        closeHandler = null;
        parent.addChild(window);
        tween.stop();
        tween = BetweenAS3.to(this, { alpha: 0 } );
        tween.onComplete = close;
        tween.play();
    }
    
    private function onClickTweet(e: Event):void 
    {
        navigateToURL(new URLRequest("http://twitter.com/share?" + 
            "text=" + escapeMultiByte(_tweet) + "&url=" + escapeMultiByte("http://wonderfl.net/c/" + _api.appID)
        ));
    }
}
class RankingWindow extends Sprite
{
    private var _name: String;
    private var loader: URLLoader;
    private var bg: Shape, closeBtn:PushButton, loadingLabel:Label;
    private var tween: ITween;
    private var scoreData: APIScoreData;
    private var list: ScoreList;
    private var tweetBtn:PushButton;
    public var closeHandler: Function;
    function RankingWindow(name: String)
    {
        _name = name, alpha = 0;
        
        BackupStyle.styleSet();
        bg = new Shape();
        var g: Graphics = bg.graphics;
        g.beginFill(0x777777);
        g.drawRoundRectComplex(0, 0,  260, 340, 5, 5, 5, 5);
        g.beginFill(0xFFFFFF);
        g.drawRoundRectComplex(1, 1,  258, 20,  5, 5, 0, 0);
        g.drawRoundRectComplex(1, 22, 258, 317, 0, 0, 5, 5);
        g.beginFill(0x777777);
        g.drawRect(6, 27, 248, 282);
        g.beginFill(0xFFFFFF);
        g.drawRect(7, 28, 246, 280);
        bg.filters = [new DropShadowFilter(2, 45, 0, 1, 16, 16, 1)];
        addChild(bg);
        new Label(this, 5, 3, _title + " RANKING");
        if (_tweet) tweetBtn = new PushButton(this, 25, 314, "TWEET", onClickTweet);
        closeBtn = new PushButton(this, _tweet ? 135 : 80, 314, "CLOSE", onClickClose);
        loadingLabel = new Label(this, 100, 160, "NOW LOADING...");
        BackupStyle.styleBack();
        
        tween = BetweenAS3.to(this, { alpha: 1 } );
        tween.onComplete = check;
        tween.play();
        addEventListener(Event.ENTER_FRAME, loadingLoop);
        loader = new URLLoader();
        loader.addEventListener(Event.COMPLETE, onCompSaveScore);
        var urlReq: URLRequest = _api.apiScorePost(_score, _name);
        urlReq.url = WonderflAPI.API_SCORE_SET.replace("%ID%", _api.appID);
        loader.load(urlReq);
    }
    
    private function onClickTweet(e: Event):void 
    {
        navigateToURL(new URLRequest("http://twitter.com/share?" + 
            "text=" + escapeMultiByte(_tweet) + "&url=" + escapeMultiByte("http://wonderfl.net/c/" + _api.appID)
        ));
    }
    
    private function onClickClose(e: Event):void 
    {
        removeEventListener(Event.ENTER_FRAME, loadingLoop);
        closeBtn.removeEventListener(MouseEvent.CLICK, onClickClose);
        try { loader.close(); }
        catch (err: Error) { }
        
        if (tween && tween.isPlaying) tween.stop();
        tween = BetweenAS3.to(this, { alpha: 0 } );
        tween.onComplete = close;
        tween.play();
    }
    
    private function close():void 
    {
        while (numChildren > 0) removeChildAt(0);
        var f: Function = closeHandler;
        closeHandler = null;
        list.clear();
        if (loader) 
        {
            loader.removeEventListener(Event.COMPLETE, onCompLoadScore);
            loader.removeEventListener(Event.COMPLETE, onCompSaveScore);
        }
        bg = null, closeBtn = null, loadingLabel = null, list = null;
        if (f != null) f();
    }
    
    private function check():void 
    {
        if (scoreData && alpha == 1) 
        {
            removeEventListener(Event.ENTER_FRAME, loadingLoop);
            removeChild(loadingLabel);
            addChild(list = new ScoreList(7, 28, 246, 280));
            list.add(scoreData.scores, _name, _score)
        }
    }
    
    private function loadingLoop(e:Event):void 
    {
        loadingLabel.visible = !loadingLabel.visible;
    }
    
    private function onCompSaveScore(e:Event):void 
    {
        loader.removeEventListener(Event.COMPLETE, onCompSaveScore);
        var res: WonderflAPIData = new WonderflAPIData(JSON.decode(loader.data));
        if (res.isOK)
        {
            loader = new URLLoader();
            loader.addEventListener(Event.COMPLETE, onCompLoadScore);
            loader.load(_api.apiScoreGet(_scoreLength, _scoreDescend));
        }
        else 
        {
            removeEventListener(Event.ENTER_FRAME, loadingLoop);
            loadingLabel.visible = true;
            loadingLabel.text = "Score Save Error : " + res.stat + " : " + res.message;
        }
    }
    
    private function onCompLoadScore(e:Event):void 
    {
        loader.removeEventListener(Event.COMPLETE, onCompLoadScore);
        scoreData = new APIScoreData(JSON.decode(loader.data));
        if (scoreData.isOK)
        {
            check();
        }
        else 
        {
            removeEventListener(Event.ENTER_FRAME, loadingLoop);
            loadingLabel.visible = true;
            loadingLabel.text = "Score Load Error" + scoreData.stat + " : " + scoreData.message;
            scoreData = null;
            if (tweetBtn) tweetBtn.removeEventListener(MouseEvent.CLICK, onClickTweet); 
            tweetBtn = null;
        }
    }
}
class ScoreList extends Sprite
{
    private var container: Sprite;
    private var containerMask: Shape;
    private var scrollBar: VScrollBar;
    private var scoreLength: int;
    private var myScoreLCIndex: int;
    private var listChildren: Vector.<ListChild>;
    private var myScoreLC: ListChild;
    private var scrollValue: int;
    private var isClear: Boolean;
    private var highLightEffect:Shape;
    private var targetY: int;
    private var tween:ITweenGroup;
    private var w: int, h: int;
    function ScoreList(x: int, y: int, w: int, h: int)
    {
        this.x = x, this.y = y, this.w = w - 10, this.h = h;
        addChild(container = new Sprite());
        addChild(containerMask = new Shape());
        container.mask = containerMask;
        var g: Graphics = containerMask.graphics;
        g.beginFill(0xFFFFFF), g.drawRect(0, 0, this.w, h);
        scrollBar = new VScrollBar(this, this.w, 0);
        scrollBar.height = h;
    }
    
    public function add(scores: Vector.<ScoreData>, name: String, score: int): void 
    {
        scoreLength = scores.length, myScoreLCIndex = -1;
        listChildren = new Vector.<ListChild>(scoreLength, true);
        for ( var i: int = 0; i < scoreLength; i++ )
        {
            var s: ScoreData = scores[i];
            if (s.name == name && s.score == score) myScoreLCIndex = i;
            var listChild: ListChild = listChildren[i] = new ListChild(w, 21, i + 1, s.name, String(s.score / _denominator) + " " + _addScoreAfter);
            listChild.y = 20 * (i - (myScoreLCIndex < 0 ? 0 : 1));
            if (myScoreLCIndex == i) myScoreLC = listChild;
            else container.addChild(listChild);
        }
        var setScrollBar: Function = function(): void
        {
            scrollBar.setThumbPercent(13 / (scoreLength - 1));
            var max: int = scoreLength - 1 - 13;
            if (max < 0) max = 0;
            var now: int = myScoreLCIndex - 13;
            if (now < 0) now = 0;
            scrollBar.setSliderParams(0, max, now);
            scrollValue = now;
            scrollBar.addEventListener(Event.CHANGE, onChangeScroll);
            tween = null;
            if (isClear) clear();
        }
        if (myScoreLC) 
        {
            highLightEffect = new Shape();
            var g: Graphics = highLightEffect.graphics;
            g.beginFill(0x80FFFF);
            g.drawRect(- w >> 1, - 10, w, 21);
            myScoreLC.scaleX = myScoreLC.scaleY = 1.5;
            myScoreLC.alpha = 0;
            myScoreLC.x = w  - myScoreLC.width  >> 1;
            highLightEffect.x = w >> 1;
            if (myScoreLCIndex > 13) 
            {
                // 画面をスクロール
                myScoreLC.y = (targetY = 13 * 20) + (20 - myScoreLC.height >> 1);
                container.y = (13 - myScoreLCIndex) * 20;
            }
            else 
            {
                myScoreLC.y = (targetY = myScoreLCIndex * 20) + (20 - myScoreLC.height >> 1);
            }
            highLightEffect.y = targetY + 10;
            addChild(myScoreLC);
            var arr: Array = [];
            if (myScoreLCIndex != scoreLength - 1)
            {
                for (i = myScoreLCIndex + 1; i < scoreLength; i++ )
                {
                    arr.push(BetweenAS3.to(listChildren[i], { y: listChildren[i].y + 20 }, 0.5, Quad.easeInOut));
                }
            }
            arr.push(BetweenAS3.to(myScoreLC, { x: 0, y: targetY, scaleX: 1, scaleY:1 }, 0.5, Quad.easeOut));
            tween = BetweenAS3.serial(
                BetweenAS3.to(myScoreLC, { alpha: 1 }, 0.5),
                BetweenAS3.parallelTweens(arr),
                BetweenAS3.addChild(highLightEffect, this),
                BetweenAS3.to(highLightEffect, { alpha: 0, scaleX: 1.3, scaleY: 1.3 }, 0.5, Quad.easeOut),
                BetweenAS3.parallel(
                    BetweenAS3.removeFromParent(highLightEffect), BetweenAS3.removeFromParent(myScoreLC)
                )
            );
            tween.onComplete = function(): void
            {
                tween.onComplete = null;
                tween = null;
                myScoreLC.y = myScoreLCIndex * 20;
                container.addChildAt(myScoreLC, myScoreLCIndex);
                setScrollBar();
            }
            tween.play();
        }
        else 
        {
            setScrollBar();
        }
    }
    
    public function clear():void 
    {
        if (tween)
        {
            isClear = true;
        }
        else 
        {
            while (numChildren > 0) removeChildAt(0);
            while (container.numChildren > 0) container.removeChildAt(0);
            for (var i: int = 0; i < scoreLength; i ++ ) listChildren[i].clear();
            container.mask = null;
            container = null;
            containerMask = null;
            scrollBar = null;
            myScoreLC = null;
            highLightEffect = null;
        }
    }
    
    private function onChangeScroll(e:Event):void 
    {
        if (scrollValue == scrollBar.value) return;
        scrollValue = scrollBar.value;
        container.y = - scrollValue * 20;
    }
}
class ListChild extends Sprite
{
    private var indexLabel: Label;
    private var label: Label;
    private var scoreLabel: Label;
    function ListChild(w: int, h: int, index: int, userName: String, score: String)
    {
        BackupStyle.styleSet();
        var g: Graphics = graphics;
        g.beginFill(0xCCCCCC);
        g.drawRect(0, 0, w, h);
        g.drawRect(1, 1, w - 2, h - 2);
        g.beginFill(0xFFFFFF);
        g.drawRect(1, 1, w - 2, h - 2);
        indexLabel = new Label(this, 5, 0, String(index));
        label = new Label(this, 25, 0, userName);
        scoreLabel = new Label(this, 0, 0, score);
        scoreLabel.draw();
        scoreLabel.x = w - scoreLabel.width - 5;
        BackupStyle.styleBack();
    }
    
    public function clear():void 
    {
        graphics.clear();
        while (numChildren > 0) removeChildAt(0);
        indexLabel = null;
        label = null;
        scoreLabel = null;
    }
}
class BackupStyle
{
    public static var BACKGROUND: uint = 0xCCCCCC;
    public static var BUTTON_FACE: uint = 0xFFFFFF;
    public static var INPUT_TEXT: uint = 0x333333;
    public static var LABEL_TEXT: uint = 0x666666;
    public static var DROPSHADOW: uint = 0x000000;
    public static var PANEL: uint = 0xF3F3F3;
    public static var PROGRESS_BAR: uint = 0xFFFFFF;
    
    public static var embedFonts: Boolean = true;
    public static var fontName: String = "PF Ronda Seven";
    public static var fontSize: Number = 8;
    
    private static var b: Object;
    
    public static function styleSet(): void
    {
        b = {
            BACKGROUND:        Style.BACKGROUND,    BUTTON_FACE:    Style.BUTTON_FACE, 
            INPUT_TEXT:        Style.INPUT_TEXT,    LABEL_TEXT:        Style.LABEL_TEXT, 
            DROPSHADOW:        Style.DROPSHADOW,    PANEL:            Style.PANEL, 
            PROGRESS_BAR:    Style.PROGRESS_BAR,    embedFonts:        Style.embedFonts, 
            fontName:        Style.fontName,        fontSize:        Style.fontSize
        };
        Style.BACKGROUND = BACKGROUND,         Style.BUTTON_FACE = BUTTON_FACE;
        Style.INPUT_TEXT = INPUT_TEXT,         Style.LABEL_TEXT = LABEL_TEXT;
        Style.DROPSHADOW = DROPSHADOW,         Style.PANEL = PANEL;
        Style.PROGRESS_BAR = PROGRESS_BAR,     Style.embedFonts = embedFonts;
        Style.fontName = fontName,             Style.fontSize = fontSize;
    }
    
    public static function styleBack(): void
    {
        Style.BACKGROUND = b["BACKGROUND"], Style.BUTTON_FACE = b["BUTTON_FACE"];
        Style.INPUT_TEXT = b["INPUT_TEXT"], Style.LABEL_TEXT = b["LABEL_TEXT"];
        Style.DROPSHADOW = b["DROPSHADOW"], Style.PANEL = b["PANEL"];
        Style.PROGRESS_BAR = b["PROGRESS_BAR"], Style.embedFonts = b["embedFonts"];
        Style.fontName = b["fontName"], Style.fontSize = b["fontSize"];
    }
}