/**
 * Copyright bongiovi015 ( http://wonderfl.net/user/bongiovi015 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wt7H
 */

package {
    import caurina.transitions.Tweener;
    
    import flash.display.GradientType;
    import flash.display.Shader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.net.URLLoader;
    import flash.net.URLLoaderDataFormat;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    
    import frocessing.color.ColorHSL;
    
    [SWF(width=465, height=465, frameRate=30, backgroundColor=0x333333)]
    public class Arcs extends Sprite {
        public static const SHADER_URL : String = "http://www.bongiovi.tw/wonderfl/bmp3.pbj";
        private var W:int;
        private var H:int;
        private var MAX:int = 10;;
        private var loaderShader : URLLoader = new URLLoader;
        private var _shader:Shader;
        private var _curves:Array;
        
        public function Arcs() {
            W = stage.stageWidth;
            H = stage.stageHeight;
            _initBg();
            loaderShader.addEventListener(Event.COMPLETE, shaderLoaded);
            loaderShader.dataFormat = URLLoaderDataFormat.BINARY;
            loaderShader.load(new URLRequest(SHADER_URL));    
            
            _curves = [];
        }
        
        
        private function shaderLoaded(event:Event):void {
            _shader = new Shader(ByteArray(loaderShader.data));
            
            addEventListener(Event.ENTER_FRAME, _loop);
        }        
        
        
        private function _loop(event:Event):void {
            if(_curves.length < MAX && Math.random() > .9) addArc();
            
            for each ( var c:Arc in _curves) {
                c.render();
                if(c.alpha == 0) {
                    _curves.splice(_curves.indexOf(c), 1);
                }
            }
        }        
        
        private function addArc():void {
            var c:Arc = new Arc(_shader);
            c.color = new ColorHSL(Math.random() * 360, .5, .5).value;
            c.radius = 30 + Math.random() * 200;
            c.radius = Math.floor(c.radius/10) * 10;
            c.range = 10;
            c.angle = Math.random() * Math.PI * 2;
            Tweener.addTween(c, {time:3, range:90 + Math.random() * 45, radius:c.radius + 20 + Math.random() * 20, transition:"easeOutCubic"});
            Tweener.addTween(c, {delay:2, time:2+Math.random(), alpha:0, transition:"easeOutCubic"});
            _curves.push(c);
            addChild(c);
            c.x = W/2;
            c.y = H/2;
        }        
        
        private function _initBg():void {
            var mtx:Matrix = new Matrix();
            mtx.createGradientBox(W, H);
            graphics.beginGradientFill(GradientType.RADIAL, [0x333333, 0x111111], [1, 1], [0, 255], mtx);
            graphics.drawRect(0, 0, W, H);
        }
        
        
        public static function getRandomElement(ary:Array) : * {    return ary[Math.floor(Math.random()*ary.length)];    }
        
    }
    
}




    import flash.display.Shader;
    import flash.display.Shape;
    import flash.filters.ShaderFilter;
    
    
    class Arc extends Shape {
        
        public var range:Number = 0;
        public var angle:Number = 0;
        public var radius:Number = 0;
        public var color:uint;
        private var _shader:Shader;
        private var _filter:ShaderFilter;
        private var _speed:Number;
        
        public function Arc(shader:Shader) {
            _shader = shader;
            _filter = new ShaderFilter(_shader);
            _speed = .01 + Math.random() * .02;
            if(Math.random() > .5) _speed = -_speed;
            var delay:Number = 3 + Math.random() * 3;
            var duration:Number = 3 + Math.random() * 3;
        }
        
        
        public function render() : void {
            graphics.clear();
            graphics.lineStyle(2, color, 1);
            graphics.drawCircle(0, 0, radius);
            
            _shader.data.center.value = [radius/2, radius/2];
            _shader.data.angle.value = [angle];
            _shader.data.range.value = [range];
            
            filters = [_filter];
            
            angle += _speed;
        }
        
    }
    
/*

<languageVersion : 1.0;>

kernel bmp2
<   namespace : "Your Namespace";
    vendor : "Your Vendor";
    version : 1;
>
{
    input image4 src;
    output pixel4 dst;
    
    parameter float2 center
    <
        minValue:float2(0.0, 0.0);
        maxValue:float2(2000.0, 2000.0);
        defaultValue:float2(300.0, 200.0);
    >;  
    
    
    parameter float angle
    <
        minValue:0.0;
        maxValue:10.0;
        defaultValue:0.0;
    >; 
    
    
    parameter float range
    <
        minValue:0.0;
        maxValue:360.0;
        defaultValue:90.0;
    >;   
    

    void
    evaluatePixel()
    {
        float2 pos = outCoord();
        float2 vCenter = float2(cos(angle), sin(angle));
        float2 vRelative = pos - center;
        float _x = length(vCenter);
        float _y = length(vRelative);
        float theta = acos( dot(vRelative, vCenter) / (_x * _y));
        float offset = clamp(theta/radians(range), 0.0, 1.0);
        dst = sampleNearest(src,pos);
        dst *= (1.0 - sin(offset*3.14*.5));
    }
}


*/