/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wsfp
 */

package {
  import com.actionscriptbible.Example;
  
  import flash.events.*;
  import flash.external.ExternalInterface;
  import flash.globalization.LocaleID;
  public class ch41ex1 extends Example {
    public function ch41ex1() {
      trace("Browser's locale--------------------");
      try {
        trace(getLocaleFromBrowser());
      } catch (error:Error) {
        trace(error.toString());
      }
      trace("HTTP Accept-Languages locales-------");
      (new GetLocalesFromRequest()).addEventListener(Event.COMPLETE, onReady);
    }
    protected function getLocaleFromBrowser():String {
      if (ExternalInterface.available) {
        return ExternalInterface.call("\
          function() {\
            var ret = null;\
            if (navigator) {\
              if (!ret) ret = navigator['language'];\
              if (!ret) ret = navigator['browserLanguage'];\
              if (!ret) ret = navigator['systemLanguage'];\
              if (!ret) ret = navigator['userLanguage'];\
          }\
          return ret;\
        }");
      }
      return null;
    }
    protected function onReady(event:Event):void {
      var response:GetLocalesFromRequest = GetLocalesFromRequest(event.target);
      for each (var pair:LocalePriorityPair in response.locales) {
        trace(pair.locale, "\t( preference =", pair.priority.toFixed(1), ")");
      }
      createLocaleID(response.bestLocale);
    }
    protected function createLocaleID(localeName:String):void {
      var locale:LocaleID = new LocaleID(localeName);
      trace("Locale information-------------------");
      trace("lang =", locale.getLanguage(), "\nregion =", locale.getRegion(), 
        "\nscript =", locale.getScript(), "\nrtl? =", locale.isRightToLeft());
    }
  }
}
import flash.events.*;
import flash.net.*;
class GetLocalesFromRequest extends EventDispatcher {
  public var rawHeader:String;
  public var locales:Vector.<LocalePriorityPair>;
  public var bestLocale:String;
  public function GetLocalesFromRequest():void {
    var l:URLLoader = new URLLoader(new URLRequest(
      "http://actionscriptbible.com/files/accept-languages.php"));
    l.addEventListener(Event.COMPLETE, onLoad)
  }
  protected function onLoad(event:Event):void {
    rawHeader = URLLoader(event.target).data;
    locales = new Vector.<LocalePriorityPair>();
    var re:RegExp = /([\w\-\,]+);q=([\d\.]+)\,?/gs;
    if (re.test(rawHeader)) {
      re.lastIndex = 0;
      var match:Object;
      while (match = re.exec(rawHeader)) {
        var samePriorityLocales:Array = match[1].split(",");
        var priority:Number = parseFloat(match[2]);
        for each (var localeName:String in samePriorityLocales) {
          if (!bestLocale) bestLocale = localeName;
          locales.push(new LocalePriorityPair(localeName, priority));
        }
      } 
    } else if (rawHeader.length > 0) {
        bestLocale = rawHeader;
        locales.push(new LocalePriorityPair(bestLocale, 1));
    }
    dispatchEvent(new Event(Event.COMPLETE));
  }
}  
class LocalePriorityPair {
  public function LocalePriorityPair(l:String, p:Number) {
    locale = l; priority =p;
  }
  public var locale:String;
  public var priority:Number;
}