/**
 * Copyright vlad.el.rojo ( http://wonderfl.net/user/vlad.el.rojo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wrqP
 */

// Nadia
package {
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.PixelSnapping;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.filters.ColorMatrixFilter;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.utils.Dictionary;
    
    import net.hires.debug.Stats;
    
    import frocessing.color.ColorHSV;

    [SWF(width=465, height=465, backgroundColor=0x0, frameRate=120)]

    public class LluviaNadia extends Sprite {
        
        private static const GRAVITY:Number = 20;
        private static const DRAG:Number = 0.7;
        
        private static const ZERO_POINT:Point = new Point(0, 0);
        
        private var _canvas:BitmapData;
        private var _glow:BitmapData;
        private var _glowMtx:Matrix;
        private var _forceMap:BitmapData;
//     
        private var _snow:Dictionary;
        private var _color:ColorMatrixFilter = new ColorMatrixFilter([
            1, 0, 0, 0, -5,
            0, 1, 0, 0, -5,
            0, 0, 1, 0, -5,
            0, 0, 0, 1, 0
        ]);
        private var _hsv:ColorHSV = new ColorHSV();
        private var _blur:BlurFilter = new BlurFilter(1.5, 1.5, 1);
        
        public function LluviaNadia() {
            this._canvas = new BitmapData(465, 465, false, 0x0); // 
            this.addChild(new Bitmap(this._canvas)) as  Bitmap;  // 
            
        
            var tf:TextField = new TextField();
            tf.defaultTextFormat = new TextFormat('Verdana', 64, 0xffffff, true); 
            tf.autoSize = TextFieldAutoSize.LEFT;
            tf.text = '    Nadia \n Regalo de \n dios.';
            tf.x = (465 - tf.width) / 2;
            tf.y = (465 - tf.height) / 2;
            this._forceMap = new BitmapData(465, 465, false, 0x0);
            this._forceMap.draw(tf, tf.transform.matrix);
            this._forceMap.applyFilter(this._forceMap, this._forceMap.rect, new Point(0, 0), new BlurFilter(8, 8));
            
//            
            this._snow = new Dictionary();
            
            //this.addChild(new Stats());

            this.addEventListener(Event.ENTER_FRAME, this.update); // 
        }
        
        // 
        public function emitParticle(ex:Number, ey:Number, s:Number = 1, c:int = 0x00bfff, vx:Number = 0, vy:Number = 0):SnowParticle {
            var p:SnowParticle = new SnowParticle(); // 
            // 
            p.x = ex;
            p.y = ey;
            p.vx = vx;
            p.vy = vy;
            p.s = s;
            p.c = c;
//      
            this._snow[p] = true;
            return p;
        }
        
        // 
        public function update(e:Event):void {
            this._canvas.lock(); //
            this._canvas.applyFilter(this._canvas, this._canvas.rect, ZERO_POINT, this._color);
            this._canvas.applyFilter(this._canvas, this._canvas.rect, ZERO_POINT, this._blur);

            var d:Number;
            var gravity:Number = GRAVITY / 100; // 
//            w
            for (var key:* in this._snow) {
                var p:SnowParticle = SnowParticle(key);
//               
                p.vy += gravity * p.s; //
                p.vx *= 0.99; //
                p.vy *= 0.99; // 
                d = 1 - (this._forceMap.getPixel(p.x, p.y) / 0xffffff) * DRAG; //
                p.vx *= d; // 
                var vy:Number = p.vy;
                p.vy *= d; // 
                if ((vy - p.vy) > 1 && Math.random() < 0.3) {
                    //
                    //
                    this.emitParticle(p.x, p.y - 2, 1, p.c, (Math.random() - 0.5) * 6, -(Math.random() * 2 + 1));
                    this.emitParticle(p.x, p.y - 2, 1, p.c, (Math.random() - 0.5) * 6, -(Math.random() * 2 + 1));
                    this.emitParticle(p.x, p.y - 2, 1, p.c, (Math.random() - 0.5) * 6, -(Math.random() * 2 + 1));
                }
                var px:int = p.x;
                var py:int = p.y;
                p.x += p.vx; // 
                p.y += p.vy;
//               
                _drawLine(p.x, p.y, px, py, p.c, 1);
                if (p.y > this.stage.stageHeight) { // 
//                    
                    delete this._snow[p];
                }
            }
            this._canvas.unlock(); // 

            for (var i:int = 0; i < 4; i++) {
                _hsv.h = Math.random() * 20 + 180;
                this.emitParticle(Math.random() * this.stage.stageWidth, -20, Math.random() + 0.5, _hsv.value);
            }
        }

        private function _drawLine(x0:int, y0:int, x1:int, y1:int, color:int, alpha:Number):void {
            var steep:Boolean = Math.abs(y1 - y0) > Math.abs(x1 - x0);
            var tmp:int;
            if (steep) {
                tmp = x0;
                x0 = y0;
                y0 = tmp;
                tmp = x1;
                x1 = y1;
                y1 = tmp;
            }
            if (x0 > x1) {
                tmp = x0;
                x0 = x1;
                x1 = tmp;
                tmp = y0;
                y0 = y1;
                y1 = tmp;
            }
            var deltax:int = x1 - x0;
            var deltay:int = Math.abs(y1 - y0);
            var error:int = deltax / 2;
            var ystep:int;
            var y:int = y0;
            if (y0 < y1) {
                ystep = 1;
            } else {
                ystep = -1;
            }
            for (var x:int = x0; x <= x1; x++) {
                if (steep) {
                    this._canvas.setPixel32(y, x, color | ((alpha * 0xff) << 24));
                } else {
                    this._canvas.setPixel32(x, y, color | ((alpha * 0xff) << 24));
                }
                error = error - deltay;
                if (error < 0) {
                    y = y + ystep;
                    error = error + deltax;
                }
            }
        }
    }
}


class SnowParticle {
    
    public var x:Number;
    public var y:Number;
    public var vx:Number;
    public var vy:Number;
    public var s:Number;
    public var c:int;
    
    public function SnowParticle() {
        this.x = 0;
        this.y = 0;
        this.vx = 0;
        this.vy = 0;
        this.s = 1;
        this.c = 0xffffff;
    }
}