/**
 * Copyright fakestar0826 ( http://wonderfl.net/user/fakestar0826 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wrCD
 */

package {
    import flash.geom.Matrix;
    import flash.utils.Proxy;
    import flash.geom.Point;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        private var rect:Rect;
        private var mark1:Circle;
        private var mark2:Circle;
        private var mark3:Circle;
        private var mark4:Circle;
        
        public function FlashTest() {
            // write as3 code here..
            rect = new Rect(100, 100);
            rect.x = 200; rect.y = 200;
            addChild(rect);
            mark1 = makeCircle();
            mark2 = makeCircle();
            mark3 = makeCircle();
            mark4 = makeCircle();
            mark1.x = 250; mark1.y = 150;
            mark2.x = 150; mark2.y = 150;
            mark3.x = 150; mark3.y = 250;
            mark4.x = 250; mark4.y = 250;
            addChild(mark1);
            addChild(mark2);
            addChild(mark3);
            addChild(mark4);
            
            
        }
        
        private function onEnterFrame(e:Event):void
        {
            var point1:Point = new Point(mark1.x, mark1.y);
            var point2:Point = new Point(mark2.x, mark2.y);
            var point3:Point = new Point(mark3.x, mark3.y);
            
            transformX(rect, point1, point2, point3);
        }
        
        private function transformX(r:Rect, p1:Point, p2:Point, p3:Point):void
        {
            var matrix:Matrix = new Matrix();
            r.transform.matrix = matrix;
            var nW:Number = r.width;
            var nH:Number = r.height;
            var p2_1:Point = p1.subtract(p2);
            var p2_3:Point = p3.subtract(p2);
            
            matrix.a = (p2_1.x) / nW;
            matrix.b = (p2_1.y) / nW;
            matrix.c = (p2_3.x) / nH;
            matrix.d = (p2_3.y) / nH;
            matrix.tx = p2.x + 50;
            matrix.ty = p2.y + 50;
            r.transform.matrix = matrix;
        }

        private function makeCircle():Circle
        {
            var mark:Circle = new Circle();
            mark.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            mark.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            
            return mark;
        }
        
        private function onMouseDown(e:MouseEvent):void
        {
            e.currentTarget.startDrag();
            this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onMouseUp(e:MouseEvent):void
        {
            e.currentTarget.stopDrag();
            this.removeEventListener(Event.ENTER_FRAME, onEnterFrame);
        }

    }
}
import flash.display.Sprite;

class Rect extends Sprite
{
    public function Rect(w:int = 50, h:int = 50, c:uint = 0xFF0000)
    {
        this.graphics.beginFill(c);
        this.graphics.drawRect(-w / 2, -h / 2, w, h);
        this.graphics.endFill();
    }

}

class Circle extends Sprite
{
    public function Circle(r:int = 10, c:uint = 0x00FF00)
    {
        this.buttonMode = true;
        this.graphics.beginFill(c);
        this.graphics.drawCircle(0, 0, r);
        this.graphics.endFill();
    }

}
