/**
 * Copyright hycro ( http://wonderfl.net/user/hycro )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wqz5
 */

// forked from hycro's Project Euler #001
package {
    import flash.display.Sprite;
    import flash.text.TextField;
    
    public class ProjectEuler extends Sprite {
		private var _textField:TextField;
       
        public function ProjectEuler() {
        		initialize();
        		writeAnswer(new Problem002);
        }
        
        private function writeAnswer(problem:AbstructProblem):void {
        		var answer:String = problem.getAnswer();
        		 _textField.appendText(answer);
        }
        
        private function initialize():void {
        	    _textField = new TextField();
            _textField.width = stage.stageWidth;
            _textField.height = stage.stageHeight;
            addChild(_textField);
        }
    }
}

class AbstructProblem {
	final public function getAnswer():String {
		var answer:String;
		try {
			answer = solve().toString();
		} catch (err:Error) {
			answer = err.name + " : " + err.message;
		}
		return answer;
	}
	
	protected function solve():Number {
		throw new Error("unsolved");
	}
}

class Problem002 extends AbstructProblem {
	override protected function solve():Number {
		var answer:Number = 0;
		var sequence:Vector.<uint> = fibonacci(4000000);
		for each (var term:uint in sequence) {
			if (term % 2 == 0) {
				answer += term;
			}
		}
		return answer;
	}
	
	private function fibonacci(maxTerm:uint):Vector.<uint> {
		var sequence:Vector.<uint> = new Vector.<uint>();
		sequence[0] = 0;
		sequence[1] = 1;
		var i:uint = 2;
		
		while ((sequence[i-1] + sequence[i-2]) <= maxTerm) {
			sequence[i] = sequence[i-1] + sequence[i-2];
			i++;
		}
		
		return sequence;
	}
}
