/**
 * Copyright psyark ( http://wonderfl.net/user/psyark )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wql4
 */

package {
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	
	[SWF(width=465,height=465,frameRate=60,backgroundColor=0x000000)]
	/**
	 * このクラスでは、あらかじめ計算された値をコードに埋め込むことで
	 * テクスチャ付きの立方体を表示します。
	 */
	public class Test11 extends Sprite {
		private var viewport:Shape;
		private var vertices:Vector.<Number>;
		private var uvtData:Vector.<Number>;
		private var worldMatrix:Matrix3D;
		private var viewMatrix:Matrix3D;
		private var projection:PerspectiveProjection;
		private var texture:BitmapData;
		
		public function Test11() {
			// 描画対象となるShapeを作成し、表示リストに追加します。
			viewport = new Shape();
			viewport.x = stage.stageWidth  * 0.5;
			viewport.y = stage.stageHeight * 0.5;
			addChild(viewport);
			
			createMesh();
			
			worldMatrix = new Matrix3D();
			viewMatrix = new Matrix3D();
			viewMatrix.appendTranslation(0, 0, 200);
			projection = new PerspectiveProjection();
			projection.fieldOfView = 60;
			
			texture = new BitmapData(512, 512, false);
			texture.perlinNoise(100, 100, 5, 0, true, true, 7);
			
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}
		
		/**
		 * 3D形状を作成します
		 */
		private function createMesh():void {
			vertices = new Vector.<Number>();
			uvtData = new Vector.<Number>();
			
			// 前面
			vertices.push(-50, -50, -50); // 0
			vertices.push(-50, +50, -50); // 2
			vertices.push(+50, -50, -50); // 1
			vertices.push(+50, -50, -50); // 1
			vertices.push(-50, +50, -50); // 2
			vertices.push(+50, +50, -50); // 3
			uvtData.push(0, 0, 0);
			uvtData.push(0, 1, 0);
			uvtData.push(1, 0, 0);
			uvtData.push(1, 0, 0);
			uvtData.push(0, 1, 0);
			uvtData.push(1, 1, 0);
			// 上面
			vertices.push(-50, -50, +50); // 4
			vertices.push(-50, -50, -50); // 0
			vertices.push(+50, -50, +50); // 5
			vertices.push(+50, -50, +50); // 5
			vertices.push(-50, -50, -50); // 0
			vertices.push(+50, -50, -50); // 1
			uvtData.push(0, 0, 0);
			uvtData.push(0, 1, 0);
			uvtData.push(1, 0, 0);
			uvtData.push(1, 0, 0);
			uvtData.push(0, 1, 0);
			uvtData.push(1, 1, 0);
			// 右側面
			vertices.push(+50, -50, +50); // 5
			vertices.push(+50, -50, -50); // 1
			vertices.push(+50, +50, +50); // 7
			vertices.push(+50, +50, +50); // 7
			vertices.push(+50, -50, -50); // 1
			vertices.push(+50, +50, -50); // 3
			uvtData.push(0, 0, 0);
			uvtData.push(0, 1, 0);
			uvtData.push(1, 0, 0);
			uvtData.push(1, 0, 0);
			uvtData.push(0, 1, 0);
			uvtData.push(1, 1, 0);
			// 底面
			vertices.push(+50, +50, +50); // 7
			vertices.push(+50, +50, -50); // 3
			vertices.push(-50, +50, +50); // 6
			vertices.push(-50, +50, +50); // 6
			vertices.push(+50, +50, -50); // 3
			vertices.push(-50, +50, -50); // 2
			uvtData.push(0, 0, 0);
			uvtData.push(0, 1, 0);
			uvtData.push(1, 0, 0);
			uvtData.push(1, 0, 0);
			uvtData.push(0, 1, 0);
			uvtData.push(1, 1, 0);
			// 左側面
			vertices.push(-50, +50, +50); // 6
			vertices.push(-50, +50, -50); // 2
			vertices.push(-50, -50, +50); // 4
			vertices.push(-50, -50, +50); // 4
			vertices.push(-50, +50, -50); // 2
			vertices.push(-50, -50, -50); // 0
			uvtData.push(0, 0, 0);
			uvtData.push(0, 1, 0);
			uvtData.push(1, 0, 0);
			uvtData.push(1, 0, 0);
			uvtData.push(0, 1, 0);
			uvtData.push(1, 1, 0);
			// 背面
			vertices.push(+50, -50, +50); // 5
			vertices.push(+50, +50, +50); // 7
			vertices.push(-50, -50, +50); // 4
			vertices.push(-50, -50, +50); // 4
			vertices.push(+50, +50, +50); // 7
			vertices.push(-50, +50, +50); // 6
			uvtData.push(0, 0, 0);
			uvtData.push(0, 1, 0);
			uvtData.push(1, 0, 0);
			uvtData.push(1, 0, 0);
			uvtData.push(0, 1, 0);
			uvtData.push(1, 1, 0);
		}
		
		/**
		 * フレームごとの処理
		 */
		private function enterFrameHandler(event:Event):void {
			update();
			render();
		}
		
		/**
		 * 更新
		 */
		private function update():void {
			worldMatrix.appendRotation(0.4, Vector3D.X_AXIS);
			worldMatrix.appendRotation(1, Vector3D.Y_AXIS);
		}
		
		/**
		 * 描画
		 */
		private function render():void {
			// World行列、View行列、Projection行列を結合して一つの行列にする
			var m:Matrix3D = new Matrix3D();
			m.append(worldMatrix);
			m.append(viewMatrix);
			m.append(projection.toMatrix3D());
			
			// 上記の行列を使って頂点座標を投影する
			var projected:Vector.<Number> = new Vector.<Number>();
			Utils3D.projectVectors(m, vertices, projected, uvtData);
			
			viewport.graphics.clear();
			viewport.graphics.lineStyle(-1, 0xFFFFFF);
			viewport.graphics.beginBitmapFill(texture, null, false, true);
			viewport.graphics.drawTriangles(projected, null, uvtData, TriangleCulling.POSITIVE);
			viewport.graphics.endFill();
		}
	}
}