/**
 * Copyright raa ( http://wonderfl.net/user/raa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wqcW
 */

// forked from toburau's Cave
// Cave
// プレイヤーは赤い四角。
// 自動的に右へ移動
// クリックするたびに上昇、下降が切りかわる
// 壁にぶつからないように右端までたどりつくとクリア
//
// ABAさんのBallBlast(http://wonderfl.net/c/euqw)を参考にしています。
//
package
{
    import flash.display.Sprite;
    import flash.events.Event;

    [SWF(frameRate="30", width="465", height="465", backgroundColor="0x000000")]

    public class cave extends Sprite
    {
        public function cave()
        {
            main = this;
            initialize();
            addEventListener(Event.ENTER_FRAME, update);
        }
    }
}

import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.geom.Rectangle;
import flash.geom.Vector3D;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;

const SCREEN_WIDTH:int = 465;
const SCREEN_HEIGHT:int = 465;

var main:Sprite;
var buffer:BitmapData = new BitmapData(SCREEN_WIDTH, SCREEN_HEIGHT, false, 0);
var isMouseClicked:Boolean;
var mousePos:Vector3D = new Vector3D;
var rect:Rectangle = new Rectangle;
var messageField:TextField = new TextField;
var mode:int = 0;
var map_pos:Array = new Array(SCREEN_WIDTH);
var map_range:int = 100;

function initialize():void
{
    main.addChild(new Bitmap(buffer));
    main.stage.addEventListener(MouseEvent.CLICK, function(e:Event):void { isMouseClicked = true; } );
    messageField = createTextField(0, 0, SCREEN_WIDTH, 36, 0x66ff66);
    main.addChild(messageField);
    startTitle();
}

function update(event:Event):void
{
    mousePos.x = main.stage.mouseX - SCREEN_WIDTH / 2;
    mousePos.y = main.stage.mouseY - SCREEN_HEIGHT / 2;
    if(isMouseClicked)
    {
        isMouseClicked = false;
    if(mode == 0)
    {
        startGame();
        mode = 1;
    }
    else if(mode == 1)
    {
        messageField.text = "";
        mode = 2;
    }
    else if(mode == 2)
    {
            player.reverse();
    }
    else if(mode == 3)
    {
        map_range = 100;
        startTitle();
        mode = 0;
    }
    else if(mode == 4)
    {
        map_range -= 10;
        if(map_range < 10) map_range = 10;
        startGame();
        mode = 1;
    }
    }
    buffer.lock();
    buffer.fillRect(buffer.rect, 0);

    if(mode != 0)
    {
    drawMap();
    }
    
    if(mode == 2)
    {
    if (player.update() == 1)
    {
        gameOver();
        mode = 3;
    }
    else if(player.update() == 2)
    {
        stageClear();
        mode = 4;
    }
    player.draw();
    }

    buffer.unlock();
}

// 矩形描画 座標系は画面中央が(0,0) 座標は矩形の中心を指定
function drawBox(x:Number, y:Number, w:int, h:int, color:int):void
{
    rect.x = x - w / 2 + SCREEN_WIDTH / 2;
    rect.y = y - h / 2 + SCREEN_HEIGHT / 2;
    rect.width = w;
    rect.height = h;
    buffer.fillRect(rect, color);
}

// 矩形描画 座標系は左上が(0,0) 座標は矩形の左上を指定
function drawBox2(x:Number, y:Number, w:int, h:int, color:int):void
{
    rect.x = x;
    rect.y = y;
    rect.width = w;
    rect.height = h;
    buffer.fillRect(rect, color);
}

function createTextField(x:int, y:int, width:int, size:int, color:int,
                         align:String = TextFormatAlign.LEFT):TextField
{
    var fm:TextFormat = new TextFormat;
    fm.font = "_typewriter"; fm.bold = true;
    fm.size = size; fm.color = color;
    fm.align = align;
    var fi:TextField = new TextField;
    fi.defaultTextFormat = fm;
    fi.x = x; fi.y = y; fi.width = width;
    fi.selectable = false;
    return fi;
}

function startTitle():void
{
    messageField.x = SCREEN_WIDTH - 320;
    messageField.y = SCREEN_HEIGHT / 2 - 40;
    messageField.text = "Cave";
}

function startGame():void
{
    messageField.x = SCREEN_WIDTH - 360;
    messageField.y = SCREEN_HEIGHT / 2 - 40;
    messageField.text = "Click to Start";

    var pos:int = 0;
    for(var i:int=0; i<SCREEN_WIDTH; ++i)
    {
    if(Math.round(Math.random()*100) < 50)
    {
        pos += 5;
    }
    else
    {
        pos -= 5;
    }
    if( pos > SCREEN_HEIGHT/2 ) { pos = SCREEN_HEIGHT/2; }
    else if( pos < -SCREEN_HEIGHT/2 ) { pos = -SCREEN_HEIGHT/2; }
    map_pos[i] = pos;
    }
    player.reset();
}

function gameOver():void
{
    messageField.x = SCREEN_WIDTH - 320;
    messageField.y = SCREEN_HEIGHT / 2 - 40;
    messageField.text = "Game Over";
}

function stageClear():void
{
    messageField.x = SCREEN_WIDTH - 320;
    messageField.y = SCREEN_HEIGHT / 2 - 40;
    messageField.text = "Stage Clear";
}

function drawMap():void
{
    for(var i:int=0; i<SCREEN_WIDTH; ++i)
    {
    drawBox2(
        i, 0,
        1, SCREEN_HEIGHT/2 + map_pos[i] - map_range,
        0x808080);
    drawBox2(
        i, SCREEN_HEIGHT/2 + map_pos[i] + map_range,
        1, SCREEN_HEIGHT/2 - map_pos[i] - map_range,
        0x808080);
    }
}

// Player
var player:Player = new Player;
class Player
{
    private const SIZE:Number = 10;
    private var pos:Vector3D = new Vector3D;
    private var vel:Vector3D = new Vector3D;
    private var isUp:Boolean;
    private var speed:Number = 1;
    
    public function Player()
    {
    reset();
    }

    public function reset():void
    {
        pos.x = -SCREEN_WIDTH/2;
        pos.y = 0;
        vel.x = vel.y = 0;
        isUp = true;
    }

    public function reverse():void
    {
        isUp = !isUp;
    }
    
    public function update():int
    {
        pos.x += speed;
        if(isUp) pos.y -= speed;
        else pos.y += speed;

    // 当たり判定
    var x:int = pos.x + SCREEN_WIDTH/2;
    if( (pos.y < (map_pos[x] - map_range + SIZE/2)) ||
        (pos.y > (map_pos[x] + map_range - SIZE/2)) )
    {
        return 1;
    }
    else if(x >= SCREEN_WIDTH)
    {
        return 2;
    }
    else
    {
        return 0;
    }
    }
    
    public function draw():void
    {
        drawBox(pos.x, pos.y, SIZE, SIZE, 0xff0000);
    }
}
