/**
 * Copyright motikawa_rgm ( http://wonderfl.net/user/motikawa_rgm )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/wpyS
 */

package 
{
    import com.adobe.images.PNGEncoder;
    import com.bit101.components.NumericStepper;
    import com.bit101.components.PushButton;
    import com.bit101.components.RadioButton;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.net.FileReference;
    import flash.utils.ByteArray;
    /*
     * http://sixwish.jp/Flartoolkit/Marker/idMarker/
     * これのFLASH版が必要になってつくったので、公開してみる。
     * 
     * http://flash.tarotaro.org/ar/FLARIdMarkerSample.html　ここでIDが表示されるはずです。
     * 
     * http://sourceforge.jp/projects/nyartoolkit/svn/view/NyARToolkit/trunk/Data/NyARIdMarkerFormat.odt?root=nyartoolkit&view=log
     * の仕様書に基づき作成しました。
     * 
     * 
     * ありがとうございます！！
     */
    [SWF( width=465, height=465, frameRate=30, backgroundColor=0xffffff )]
    public class Test extends Sprite
    {
        private var _fl:FileReference;
        private var _marker:Bitmap;
        private var _ns:NumericStepper;
        private var _currentLabel:int = 0;
        public function Test() 
        {
            init();
        }
        private function init():void
        {
            var pb:PushButton = new PushButton(this, 350, 405, "save", onButtonClick),
                rb1:RadioButton = new RadioButton(this, 100, 80, "Model2(5 * 5)", true, onChange),
                rb2:RadioButton = new RadioButton(this, 220, 80, "Model3(7 * 7)", false, onChange);
            
            _ns = new NumericStepper(this, 100, 410, onChange);
            _ns.minimum = 0;
            _ns.maximum = NyIDMarkerMaker.MAX_VALUE_MODEL2;
            _ns.width = 200;
            _ns.value = 0;
            pb.width = 50;
            _marker = addChild(new Bitmap()) as Bitmap;
            _marker.x = _marker.y = 100;
            onChange();
        }
        private function onButtonClick(event:MouseEvent):void
        {
            if (!_marker.bitmapData) return;
            
            var byte:ByteArray = PNGEncoder.encode(_marker.bitmapData);
            _fl = new FileReference();
            _fl.save(byte,"id_marker.png");
        }
        private function onChange(event:Event = null):void
        {
            if (event && event.currentTarget is RadioButton)
            {
                if ((event.currentTarget as RadioButton).label == "Model2(5 * 5)") _currentLabel = 0;
                else _currentLabel = 1;
                _ns.maximum = (_currentLabel == 0) ? NyIDMarkerMaker.MAX_VALUE_MODEL2 : NyIDMarkerMaker.MAX_VALUE_MODEL3;
            }
            draw();
        }
        private function draw():void
        {
            if(_marker.bitmapData) _marker.bitmapData.dispose();
            if (_currentLabel == 0) _marker.bitmapData = NyIDMarkerMaker.makeNyIDMarkerModel2(_ns.value);
            else _marker.bitmapData = NyIDMarkerMaker.makeNyIDMarkerModel3(_ns.value);
        }
        
    }
}
import flash.display.BitmapData;
import flash.geom.Rectangle;

class NyIDMarkerMaker 
{
    
    public static const MAX_VALUE_MODEL3:int = 33554431;
    public static const MAX_VALUE_MODEL2:int = 511;
    public static const SIZE:int = 300;
    private static const ZEROS:String = "100000000";
    private static const DEFAULT_PATTERN_MODEL3:Array = [7, 21, 35, 43, 45, 47];
    private static const DEFAULT_PATTERN_MODEL2:Array = [5, 15, 21, 23];
    private static const CHECK_DOT_PATTERN_MODEL3:Array = [13, 20, 27, 34, 41];
    private static const CHECK_DOT_PATTERN_MODEL2:Array = [9, 14, 19];
    private static const DATA_DOT_MODEL3_PACKET4:Array = [15, 22, 29, 36, 37, 38, 39, 40];
    private static const DATA_DOT_MODEL3_PACKET3:Array = [33, 26, 19, 12, 11, 10,  9,  8];
    private static const DATA_DOT_MODEL3_PACKET2:Array = [23, 30, 31, 32, 25, 18, 17, 16];
    private static const DATA_DOT_MODEL3_PACKET1:Array = [24];
    private static const DATA_DOT_MODEL2_PACKET2:Array = [11, 16, 17, 18, 13, 8, 7, 6];
    private static const DATA_DOT_MODEL2_PACKET1:Array = [12];
                                                   
    private static var _rect:Rectangle = new Rectangle();
    /**
     * Model3のマーカーを作成
     * @param    num　NyID
     * @return　作成したBitmapData
     */
    public static function makeNyIDMarkerModel3(num:int):BitmapData
    {
        var offset:int = SIZE * .15,
            dotWidth:int = SIZE * .7 / 7,
            bmd:BitmapData = makeTemplateModel3(SIZE, offset, dotWidth);
            
        num = (num > MAX_VALUE_MODEL3) ? 0 : (num < 0) ? 0 :num;
        setDataDotModel3(bmd, num, offset, dotWidth);
        return bmd;
    }
    /**
     * Model2のマーカーを作成
     * @param    num　NyID
     * @return　作成したBitmapData
     */
    public static function makeNyIDMarkerModel2(num:int):BitmapData
    {
        var offset:int = SIZE * .15,
            dotWidth:int = SIZE * .7 / 5,
            bmd:BitmapData = makeTemplateModel2(SIZE, offset, dotWidth);
            
        num = (num > MAX_VALUE_MODEL2) ? 0 : (num < 0) ? 0 :num;
        setDataDotModel2(bmd, num, offset, dotWidth);
        return bmd;
    }
    /**
     * Model2のテンプレートの作成
     * @param    size　画像サイズ
     * @param    offset　黒淵のサイズ
     * @param    dotWidth　ドット幅
     * @return　　作成したBitmapData
     */
    private static function makeTemplateModel2(size:int, offset:int, dotWidth:int):BitmapData
    {
        var bmd:BitmapData = new BitmapData(size, size, false, 0x000000),
            i:int;
        bmd.fillRect(new Rectangle(offset, offset, size * .7, size * .7), 0xffffff);
        for each(i in DEFAULT_PATTERN_MODEL2) drawDot(bmd, i, offset, dotWidth, 5);
        return bmd;
    }
    /**
     * 
     * Model2のテンプレートの作成
     * @param    size　画像サイズ
     * @param    offset　黒淵のサイズ
     * @param    dotWidth　ドット幅
     * @return　　作成したBitmapData
     */
    private static function makeTemplateModel3(size:int,offset:int,dotWidth:int):BitmapData
    {
        var bmd:BitmapData = new BitmapData(size, size, false, 0x000000),
            i:int;
            
        bmd.fillRect(new Rectangle(offset, offset, size * .7, size * .7), 0xffffff);
        for each(i in DEFAULT_PATTERN_MODEL3) drawDot(bmd, i, offset, dotWidth);
        
        return bmd;
    }
    /**
     * Model3試用のデータドット　および　チェックドットを生成
     * @param    bitmapData　ベースになるBitmapData
     * @param    num　NyID
     * @param    offset　黒淵のサイズ
     * @param    dotWidth　ドット幅
     */
    private static function setDataDotModel3(bitmapData:BitmapData, num:int, offset:int, dotWidth:int):void
    {
        var seg1:uint,
            seg2:uint,
            seg3:uint,
            seg4:uint,
            seg1_arr:Array,
            seg2_arr:Array,
            seg3_arr:Array,
            seg4_arr:Array,
            len:int = 8,
            i:int = 0;
            
        seg1 |= num >> 24 & 0xff;
        seg2 |= num >> 16 & 0xff;
        seg3 |= num >> 8 & 0xff;
        seg4 |= num & 0xff;
        
        setCheckDotModel3(bitmapData , seg1 + seg2 + seg3 + seg4, offset, dotWidth);
        
        seg4_arr = (parseInt(ZEROS, 2) | seg4).toString(2).slice(1,9).split("");
        seg3_arr = (parseInt(ZEROS, 2) | seg3).toString(2).slice(1,9).split("");
        seg2_arr = (parseInt(ZEROS, 2) | seg2).toString(2).slice(1,9).split("");
        seg1_arr = seg1.toString(2).split("");
        
        for (i = 0; i < len; i++) if (seg4_arr[i] == "1") drawDot(bitmapData, DATA_DOT_MODEL3_PACKET4[i], offset, dotWidth);
        for (i = 0; i < len; i++) if (seg3_arr[i] == "1") drawDot(bitmapData, DATA_DOT_MODEL3_PACKET3[i], offset, dotWidth);
        for (i = 0; i < len; i++) if (seg2_arr[i] == "1") drawDot(bitmapData, DATA_DOT_MODEL3_PACKET2[i], offset, dotWidth);
        for (i = 0, len = 1; i < len; i++) if (seg1_arr[i] == "1") drawDot(bitmapData, DATA_DOT_MODEL3_PACKET1[i], offset, dotWidth) ;
            
        return;
    }
    /**
     * Model２仕様の　および　チェックドットを生成
     * @param    bitmapData　ベースになるBitmapData
     * @param    num　NyID
     * @param    offset　黒淵のサイズ
     * @param    dotWidth　ドット幅
     */
    private static function setDataDotModel2(bitmapData:BitmapData, num:int, offset:int, dotWidth:int):void
    {
        var seg1:uint,
            seg2:uint,
            seg1_arr:Array,
            seg2_arr:Array,
            len:int = 8,
            i:int = 0;
                        
        seg1 |= num >> 8 & 0xff;
        seg2 |= num & 0xff;
        setCheckDotModel2(bitmapData , seg1 + seg2, offset, dotWidth);
        seg2_arr = (parseInt(ZEROS, 2) | seg2).toString(2).slice(1, 9).split("");
        seg1_arr = seg1.toString(2).split("");
        
        for (i = 0; i < len; i++) if (seg2_arr[i] == "1") drawDot(bitmapData, DATA_DOT_MODEL2_PACKET2[i], offset, dotWidth, 5);
        for (i = 0 , len = 1; i < len; i++) if (seg1_arr[i] == "1") drawDot(bitmapData, DATA_DOT_MODEL2_PACKET1[i], offset, dotWidth, 5);
    }
    /**
     * Model２仕様のチェックドットを生成
     * @param    bitmapData　ベースになるBitmapData
     * @param    num　NyID
     * @param    offset　黒淵のサイズ
     * @param    dotWidth　ドット幅
     */
    private static function setCheckDotModel2(bitmapData:BitmapData, num:int, offset:int,dotWidth:int):void
    {
        var value:int = num % 7,
            check_data:Array,
            i:int = 0,
            len:int = CHECK_DOT_PATTERN_MODEL3.length;
            
        value = (value >= 5) ? value + 1 : value;
        check_data = value.toString(2).split("").reverse();
        
        for (i = 0; i < len; i++)
            if (check_data[i] == "1") drawDot(bitmapData, CHECK_DOT_PATTERN_MODEL2[i], offset, dotWidth, 5);
            
        return ;
    }
    /**
     * Model２仕様のチェックドットを生成
     * @param    bitmapData　ベースになるBitmapData
     * @param    num　NyID
     * @param    offset　黒淵のサイズ
     * @param    dotWidth　ドット幅
     */
    private static function setCheckDotModel3(bitmapData:BitmapData, num:int, offset:int,dotWidth:int):void
    {
        var value:int = num % 31,
            check_data:Array,
            i:int = 0,
            len:int = CHECK_DOT_PATTERN_MODEL3.length;
            
        value = (value >= 21) ? value + 1 : value;
        check_data = value.toString(2).split("").reverse();
        
        for (i = 0; i < len; i++)
            if (check_data[i] == "1") drawDot(bitmapData, CHECK_DOT_PATTERN_MODEL3[i], offset, dotWidth);
            
        return ;
    }
    /**
     * ドットの描画
     * @param    bitmapData
     * @param    pos
     * @param    offset
     * @param    dotWidth
     * @param    r
     */
    private static function drawDot(bitmapData:BitmapData, pos:int, offset:int, dotWidth:int,r:int = 7):void
    {
        _rect.width = _rect.height = dotWidth;
        _rect.x = (pos % r) * dotWidth + offset;
        _rect.y = Math.floor( pos / r) * dotWidth + offset;
        bitmapData.fillRect(_rect, 0x000000);
    }
}
