/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wpos
 */

package  
{
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.text.TextFormat;
    
    /**
     * ...
     * @author umhr
     */
    public class Main2 extends Sprite 
    {
        private var _radiallyWipe:RadiallyWipe = new RadiallyWipe(350,200);
        public function Main2() 
        {
            
            _radiallyWipe.x = 50;
            _radiallyWipe.y = 100;
            
            var tf:TextField = new TextField();
            tf.defaultTextFormat = new TextFormat("_sans", 20);
            tf.text = "じゅげむ　じゅげむ　ごこうのすりきれ　かいじゃりすいぎょの　すいぎょうまつ　うんらいまつ　ふうらいまつ　くうねるところにすむところ　やぶらこうじのぶらこうじ　ぱいぽ　ぱいぽ　ぱいぽのしゅーりんがん　しゅーりんがんのぐーりんだい　ぐーりんだいのぽんぽこぴーの　ぽんぽこなーの　ちょうきゅうめいのちょうすけ";
            tf.multiline = true;
            tf.wordWrap = true;
            tf.width = 350;
            tf.height = 200;
            
            var bitmapData:BitmapData = new BitmapData(350, 200, true, 0xFF99FF66);
            bitmapData.draw(tf);
            
            _radiallyWipe.bitmapData = bitmapData;
            
            addChild(_radiallyWipe);
            addEventListener(Event.ENTER_FRAME, onEnter);
        }
        
        private function onEnter(e:Event):void 
        {
            _radiallyWipe.upDate();
        }
        
        
    }

}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Shape;
import flash.display.Sprite;

/**
 * ...
 * @author umhr
 */
class RadiallyWipe extends Sprite 
{
    public var w:int;
    public var h:int;
    private var _count:int;
    private var _bitmapData:BitmapData;
    private var _shape:Shape = new Shape();
    private var _background:Bitmap = new Bitmap();
    public function RadiallyWipe(w:int,h:int) 
    {
        this.w = w;
        this.h = h;
        init();
    }
    
    private function init():void {
        _shape.graphics.beginFill(0xFF0000);
        _shape.graphics.drawRect(0, 0, w, h);
        _shape.graphics.endFill();
        addChild(_shape);
    }
    
    public function upDate():void {
        var step:int = 3 * 60;
        _count ++ ;
        _count %= step;
        
        draw(_count / step);
        
    }
    
    private function draw(ratio:Number):void {
        
        _shape.graphics.clear();
        _shape.graphics.beginBitmapFill(_bitmapData);
        _shape.graphics.moveTo(w * 0.5, h * 0.5);
        _shape.graphics.lineTo(w * 0.5, 0);
        if (ratio > (0.25-Math.atan2(h * 0.5, w * 0.5)/(Math.PI*2))) {
            _shape.graphics.lineTo(w, 0);
        }
        if (ratio > 0.5 - (0.25 - (Math.atan2(h * 0.5, w * 0.5)) / (Math.PI * 2))) {
            _shape.graphics.lineTo(w, h);
        }
        if (ratio > (0.75-Math.atan2(h * 0.5, w * 0.5)/(Math.PI*2))) {
            _shape.graphics.lineTo(0, h);
        }
        if (ratio > 1-(0.25-(Math.atan2(h * 0.5, w * 0.5))/(Math.PI*2))) {
            _shape.graphics.lineTo(0, 0);
        }
        
        var tx:Number;
        var ty:Number;
        var d:Number = Math.sqrt(w * w * 0.25 + h * h * 0.25);
        tx = w*0.5 + Math.sin(ratio * Math.PI * 2) * d;
        ty = h*0.5 - Math.cos(ratio * Math.PI * 2) * d;
        tx = Math.min(w, Math.max(0, tx));
        ty = Math.min(h, Math.max(0, ty));
        _shape.graphics.lineTo(tx, ty);
        _shape.graphics.endFill();
        
    }
    
    public function set bitmapData(value:BitmapData):void 
    {
        _background.bitmapData = value;
        _background.alpha = 0.2;
        //this.addChild(_background);
        _bitmapData = value;
    }
}
