/**
 * Copyright Quasimondo ( http://wonderfl.net/user/Quasimondo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/worI
 */

package {
    import flash.display.Sprite;
    public class DynamicInterpolation extends Sprite {
        public function DynamicInterpolation() {
            
            var scaleCenter:Number = 0.7;
            var scaleFactor:Number = 3;
            
            
            graphics.lineStyle(0,0);
            graphics.drawRect(0,0,200,200);
            
           
            for ( var i:int = 0; i < 100; i++ )
            {
                var v:Number = interpolate(i / 100,scaleCenter,scaleFactor);
                graphics.drawCircle( i * 2, v * 200,1 );
             }
        }
        
        // all arguments must be in the range 0...1
        private function interpolate( value:Number, center:Number = 0.5, factor:Number = 1 ):Number
        {
            if ( value < center )
            {
               value = (1 - Math.pow( 1 - value * ( 1 / center), factor )) * center ;
            } else {
               value = Math.pow( (value - center) * ( 1 / ( 1 - center)), factor ) * ( 1 - center) + center;
            }
            return value;
        }

    }
}